/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.util.Comparator;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import jmri.ConsistManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttConsistManager;
import jmri.jmrix.mqtt.MqttLightManager;
import jmri.jmrix.mqtt.MqttPowerManager;
import jmri.jmrix.mqtt.MqttReporterManager;
import jmri.jmrix.mqtt.MqttSensorManager;
import jmri.jmrix.mqtt.MqttSignalMast;
import jmri.jmrix.mqtt.MqttThrottleManager;
import jmri.jmrix.mqtt.MqttTurnoutManager;
import jmri.util.NamedBeanComparator;

public class MqttSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private MqttAdapter mqttAdapter;

    public MqttSystemConnectionMemo() {
        super("M", "MQTT");
        InstanceManager.store(this, MqttSystemConnectionMemo.class);
    }

    @Override
    public void configureManagers() {
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setLightManager(this.getLightManager());
        InstanceManager.setReporterManager(this.getReporterManager());
        InstanceManager.setThrottleManager(this.getThrottleManager());
        InstanceManager.store(this.getPowerManager(), PowerManager.class);
        InstanceManager.store(this.getConsistManager(), ConsistManager.class);
        MqttSignalMast.setSendTopicPrefix(this.getMqttAdapter().getOptionState("15"));
        this.register();
    }

    @Override
    public void dispose() {
        InstanceManager.deregister(this, MqttSystemConnectionMemo.class);
        super.dispose();
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return null;
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    public MqttTurnoutManager getTurnoutManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttTurnoutManager)this.classObjectMap.computeIfAbsent(TurnoutManager.class, c -> {
            MqttTurnoutManager t = new MqttTurnoutManager(this);
            t.setSendTopicPrefix(this.getMqttAdapter().getOptionState("10.3"));
            t.setRcvTopicPrefix(this.getMqttAdapter().getOptionState("10.5"));
            return t;
        });
    }

    public MqttSensorManager getSensorManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttSensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> {
            MqttSensorManager t = new MqttSensorManager(this);
            t.setSendTopicPrefix(this.getMqttAdapter().getOptionState("11.3"));
            t.setRcvTopicPrefix(this.getMqttAdapter().getOptionState("11.5"));
            return t;
        });
    }

    public MqttLightManager getLightManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttLightManager)this.classObjectMap.computeIfAbsent(LightManager.class, c -> {
            MqttLightManager t = new MqttLightManager(this);
            t.setSendTopicPrefix(this.getMqttAdapter().getOptionState("12.3"));
            t.setRcvTopicPrefix(this.getMqttAdapter().getOptionState("12.5"));
            return t;
        });
    }

    public MqttReporterManager getReporterManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttReporterManager)this.classObjectMap.computeIfAbsent(ReporterManager.class, c -> {
            MqttReporterManager t = new MqttReporterManager(this);
            t.setRcvTopicPrefix(this.getMqttAdapter().getOptionState("13"));
            return t;
        });
    }

    public MqttThrottleManager getThrottleManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttThrottleManager)this.classObjectMap.computeIfAbsent(ThrottleManager.class, c -> {
            MqttThrottleManager t = new MqttThrottleManager(this);
            t.setSendThrottleTopic(this.getMqttAdapter().getOptionState("16.3"));
            t.setRcvThrottleTopic(this.getMqttAdapter().getOptionState("16.5"));
            t.setSendDirectionTopic(this.getMqttAdapter().getOptionState("17.3"));
            t.setRcvDirectionTopic(this.getMqttAdapter().getOptionState("17.5"));
            t.setSendFunctionTopic(this.getMqttAdapter().getOptionState("18.3"));
            t.setRcvFunctionTopic(this.getMqttAdapter().getOptionState("18.5"));
            return t;
        });
    }

    public MqttPowerManager getPowerManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttPowerManager)this.classObjectMap.computeIfAbsent(PowerManager.class, c -> {
            MqttPowerManager t = new MqttPowerManager(this);
            t.setSendTopic(this.getMqttAdapter().getOptionState("20.3"));
            t.setRcvTopic(this.getMqttAdapter().getOptionState("20.5"));
            return t;
        });
    }

    @Override
    public MqttConsistManager getConsistManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MqttConsistManager)this.classObjectMap.computeIfAbsent(ConsistManager.class, c -> {
            MqttConsistManager t = new MqttConsistManager(this);
            t.setSendTopic(this.getMqttAdapter().getOptionState("19.3"));
            return t;
        });
    }

    public void setPowerManager(@Nonnull PowerManager p) {
        this.store(p, PowerManager.class);
    }

    @Override
    public void setConsistManager(@Nonnull ConsistManager c) {
        this.store(c, ConsistManager.class);
    }

    void setMqttAdapter(MqttAdapter ma) {
        this.mqttAdapter = ma;
    }

    public MqttAdapter getMqttAdapter() {
        return this.mqttAdapter;
    }
}

