/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.mqtt.MqttAdapter;
import jmri.jmrix.mqtt.MqttConsistManager;
import jmri.jmrix.mqtt.MqttEventListener;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.MqttThrottleManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttThrottle
extends AbstractThrottle
implements MqttEventListener {
    private final MqttAdapter mqttAdapter;
    @Nonnull
    public String sendThrottleTopic = "cab/{0}/throttle";
    @Nonnull
    public String rcvThrottleTopic = "cab/{0}/throttle";
    @Nonnull
    public String sendDirectionTopic = "cab/{0}/direction";
    @Nonnull
    public String rcvDirectionTopic = "cab/{0}/direction";
    @Nonnull
    public String sendFunctionTopic = "cab/{0}/function/{1}";
    @Nonnull
    public String rcvFunctionTopic = "cab/{0}/function/{1}";
    protected int address = -1;
    private Pattern functionPattern;
    private MqttConsistManager consistManager;
    private static final Logger log = LoggerFactory.getLogger(MqttThrottle.class);

    public MqttThrottle(MqttSystemConnectionMemo memo) {
        super(memo);
        this.mqttAdapter = memo.getMqttAdapter();
        this.consistManager = memo.getConsistManager();
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.isForward = true;
        log.debug("MqttThrottle constructor");
    }

    public MqttThrottle(MqttSystemConnectionMemo memo, String sendThrottleTopic, String rcvThrottleTopic, String sendDirectionTopic, String rcvDirectionTopic, String sendFunctionTopic, String rcvFunctionTopic) {
        super(memo);
        this.mqttAdapter = memo.getMqttAdapter();
        this.consistManager = memo.getConsistManager();
        this.sendThrottleTopic = sendThrottleTopic;
        this.rcvThrottleTopic = rcvThrottleTopic;
        this.sendDirectionTopic = sendDirectionTopic;
        this.rcvDirectionTopic = rcvDirectionTopic;
        this.sendFunctionTopic = sendFunctionTopic;
        this.rcvFunctionTopic = rcvFunctionTopic;
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.isForward = true;
        log.debug("MqttThrottle constructor");
    }

    public MqttThrottle(MqttSystemConnectionMemo memo, String sendThrottleTopic, String rcvThrottleTopic, String sendDirectionTopic, String rcvDirectionTopic, String sendFunctionTopic, String rcvFunctionTopic, LocoAddress address) {
        super(memo);
        this.mqttAdapter = memo.getMqttAdapter();
        this.consistManager = memo.getConsistManager();
        this.sendThrottleTopic = sendThrottleTopic;
        this.rcvThrottleTopic = rcvThrottleTopic;
        this.sendDirectionTopic = sendDirectionTopic;
        this.rcvDirectionTopic = rcvDirectionTopic;
        this.sendFunctionTopic = sendFunctionTopic;
        this.rcvFunctionTopic = rcvFunctionTopic;
        this.setDccAddress(address.getNumber());
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        this.isForward = true;
        log.debug("MqttThrottle constructor called for address {}", (Object)address);
    }

    @Override
    public void setSpeedSetting(float speed) {
        super.setSpeedSetting(speed);
        if (speed < 0.0f) {
            speed = 0.0f;
            ThreadingUtil.runOnLayout(() -> this.mqttAdapter.publish(this.sendDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), "STOP"));
            super.setSpeedSetting(0.0f);
            log.debug("sent address {} direction {}", (Object)this.address, (Object)"STOP");
        }
        int intSpeed = Math.round(speed * 100.0f);
        if (speed > 0.0f && intSpeed == 0) {
            intSpeed = 1;
        }
        String stringSpeed = String.valueOf(intSpeed);
        ThreadingUtil.runOnLayout(() -> this.mqttAdapter.publish(this.sendThrottleTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), stringSpeed));
        log.debug("sent address {} speed {}", (Object)this.address, (Object)intSpeed);
    }

    @Override
    public void setIsForward(boolean forward) {
        super.setIsForward(forward);
        ThreadingUtil.runOnLayout(() -> this.mqttAdapter.publish(this.sendDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), forward ? "FORWARD" : "REVERSE"));
        log.debug("sent address {} direction {}", (Object)this.address, (Object)(forward ? "FORWARD" : "REVERSE"));
    }

    @Override
    public void sendFunctionGroup(int functionNum, boolean momentary) {
        ThreadingUtil.runOnLayoutEventually(() -> this.mqttAdapter.publish(this.sendFunctionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)).replaceFirst("\\{1\\}", String.valueOf(functionNum)), this.getFunction(functionNum) ? "ON" : "OFF"));
        log.debug("sent address {} function {} {}", new Object[]{this.address, functionNum, this.getFunction(functionNum) ? "ON" : "OFF"});
    }

    protected void throttleRelease() {
        this.active = false;
        ThreadingUtil.runOnLayout(() -> {
            this.mqttAdapter.publish(this.sendThrottleTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), "");
            this.mqttAdapter.publish(this.sendDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), "");
            for (int functionNum = 0; functionNum < this.getFunctions().length; ++functionNum) {
                this.mqttAdapter.publish(this.sendFunctionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)).replaceFirst("\\{1\\}", String.valueOf(functionNum)), "");
            }
        });
        this.consistManager.deactivateConsist(this.getLocoAddress());
        this.mqttAdapter.unsubscribe(this.rcvThrottleTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), this);
        this.mqttAdapter.unsubscribe(this.rcvDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), this);
        this.mqttAdapter.unsubscribe(this.rcvFunctionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)).replaceFirst("\\{1\\}", "+"), this);
    }

    @Override
    protected void throttleDispose() {
        log.debug("throttleDispose {}", (Object)this.address);
        this.finishRecord();
    }

    public int setDccAddress(int newaddress) {
        if (this.address > 0) {
            ThreadingUtil.runOnLayout(() -> {
                this.mqttAdapter.publish(this.sendThrottleTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), "");
                this.mqttAdapter.publish(this.sendDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), "");
                for (int functionNum = 0; functionNum < this.getFunctions().length; ++functionNum) {
                    this.mqttAdapter.publish(this.sendFunctionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)).replaceFirst("\\{1\\}", String.valueOf(functionNum)), "");
                }
            });
            this.mqttAdapter.unsubscribe(this.rcvThrottleTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), this);
            this.mqttAdapter.unsubscribe(this.rcvDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), this);
            this.mqttAdapter.unsubscribe(this.rcvFunctionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)).replaceFirst("\\{1\\}", "+"), this);
        }
        this.address = newaddress;
        this.mqttAdapter.subscribe(this.rcvThrottleTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), this);
        this.mqttAdapter.subscribe(this.rcvDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)), this);
        this.mqttAdapter.subscribe(this.rcvFunctionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)).replaceFirst("\\{1\\}", "+"), this);
        this.consistManager.activateConsist(this.getLocoAddress());
        this.setSpeedSetting(0.0f);
        this.setIsForward(true);
        this.functionPattern = Pattern.compile(this.rcvFunctionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)).replaceFirst("\\{1\\}", "(\\\\d+)"));
        return this.address;
    }

    public int getDccAddress() {
        return this.address;
    }

    @Override
    public LocoAddress getLocoAddress() {
        return new DccLocoAddress(this.address, MqttThrottleManager.isLongAddress(this.address));
    }

    @Override
    public void notifyMqttMessage(String receivedTopic, String message) {
        if (receivedTopic.endsWith(this.rcvThrottleTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)))) {
            Float speed;
            try {
                speed = Float.valueOf(Math.max(0.0f, Math.min(Float.parseFloat(message) / 100.0f, 1.0f)));
            }
            catch (Exception e) {
                if (message.length() != 0) {
                    log.error("Invalid throttle speed: '{}'", (Object)message);
                }
                speed = Float.valueOf(-1.0f);
            }
            super.setSpeedSetting(speed.floatValue());
        } else if (receivedTopic.endsWith(this.rcvDirectionTopic.replaceFirst("\\{0\\}", String.valueOf(this.address)))) {
            switch (message) {
                case "FORWARD": {
                    super.setIsForward(true);
                    break;
                }
                case "REVERSE": {
                    super.setIsForward(false);
                    break;
                }
                case "STOP": 
                case "": {
                    super.setSpeedSetting(-1.0f);
                    break;
                }
                default: {
                    log.error("Invalid message {}", (Object)message);
                    break;
                }
            }
        } else {
            Matcher functionMatcher = this.functionPattern.matcher(receivedTopic);
            if (functionMatcher.matches()) {
                this.updateFunction(Integer.parseInt(functionMatcher.group(1)), message.equals("ON"));
            }
        }
    }
}

