/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.util.EnumSet;
import java.util.HashMap;
import javax.annotation.Nonnull;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.MqttThrottle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttThrottleManager
extends AbstractThrottleManager {
    protected HashMap<LocoAddress, MqttThrottle> throttles = new HashMap(5);
    @Nonnull
    public String sendThrottleTopic = "cab/{0}/throttle";
    @Nonnull
    public String rcvThrottleTopic = "cab/{0}/throttle";
    @Nonnull
    public String sendDirectionTopic = "cab/{0}/direction";
    @Nonnull
    public String rcvDirectionTopic = "cab/{0}/direction";
    @Nonnull
    public String sendFunctionTopic = "cab/{0}/function/{1}";
    @Nonnull
    public String rcvFunctionTopic = "cab/{0}/function/{1}";
    private static final Logger log = LoggerFactory.getLogger(MqttThrottleManager.class);

    public MqttThrottleManager(MqttSystemConnectionMemo memo) {
        super(memo);
    }

    public void setSendThrottleTopic(@Nonnull String sendThrottleTopic) {
        this.sendThrottleTopic = sendThrottleTopic;
    }

    public void setRcvThrottleTopic(@Nonnull String rcvThrottleTopic) {
        this.rcvThrottleTopic = rcvThrottleTopic;
    }

    public void setSendDirectionTopic(@Nonnull String sendDirectionTopic) {
        this.sendDirectionTopic = sendDirectionTopic;
    }

    public void setRcvDirectionTopic(@Nonnull String rcvDirectionTopic) {
        this.rcvDirectionTopic = rcvDirectionTopic;
    }

    public void setSendFunctionTopic(@Nonnull String sendFunctionTopic) {
        this.sendFunctionTopic = sendFunctionTopic;
    }

    public void setRcvFunctionTopic(@Nonnull String rcvFunctionTopic) {
        this.rcvFunctionTopic = rcvFunctionTopic;
    }

    @Override
    public void requestThrottleSetup(LocoAddress address, boolean control) {
        log.debug("Requesting Throttle: {}", (Object)address);
        if (this.throttles.containsKey(address)) {
            this.notifyThrottleKnown(this.throttles.get(address), address);
        } else {
            MqttThrottle throttle = new MqttThrottle((MqttSystemConnectionMemo)this.adapterMemo, this.sendThrottleTopic, this.rcvThrottleTopic, this.sendDirectionTopic, this.rcvDirectionTopic, this.sendFunctionTopic, this.rcvFunctionTopic, address);
            this.throttles.put(address, throttle);
            this.notifyThrottleKnown(throttle, address);
        }
    }

    @Override
    public boolean hasDispatchFunction() {
        return true;
    }

    @Override
    protected boolean singleUse() {
        return false;
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return MqttThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && !MqttThrottleManager.isLongAddress(address);
    }

    @Override
    public boolean addressTypeUnique() {
        return true;
    }

    protected static boolean isLongAddress(int num) {
        return num >= 128;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("disposeThrottle {}", (Object)t);
        if (super.disposeThrottle(t, l) && t instanceof MqttThrottle) {
            MqttThrottle lnt = (MqttThrottle)t;
            this.throttles.remove(lnt.getLocoAddress());
            lnt.throttleDispose();
            return true;
        }
        log.error("Dispose Throttle failed {}", (Object)t);
        return false;
    }

    @Override
    public void dispatchThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("dispatchThrottle {}", (Object)t);
        this.disposeThrottle(t, l);
    }

    @Override
    public void releaseThrottle(DccThrottle t, ThrottleListener l) {
        log.debug("releaseThrottle {}", (Object)t);
        if (t instanceof MqttThrottle) {
            ((MqttThrottle)t).throttleRelease();
        }
        this.disposeThrottle(t, l);
    }
}

