/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt;

import java.text.MessageFormat;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Turnout;
import jmri.jmrix.mqtt.MqttContentParser;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.MqttTurnout;
import jmri.managers.AbstractTurnoutManager;

public class MqttTurnoutManager
extends AbstractTurnoutManager {
    @Nonnull
    public String sendTopicPrefix = "track/turnout/";
    @Nonnull
    public String rcvTopicPrefix = "track/turnout/";
    MqttContentParser<Turnout> parser = null;

    public MqttTurnoutManager(@Nonnull MqttSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public MqttSystemConnectionMemo getMemo() {
        return (MqttSystemConnectionMemo)this.memo;
    }

    public void setSendTopicPrefix(@Nonnull String sendTopicPrefix) {
        this.sendTopicPrefix = sendTopicPrefix;
    }

    public void setRcvTopicPrefix(@Nonnull String rcvTopicPrefix) {
        this.rcvTopicPrefix = rcvTopicPrefix;
    }

    @Override
    public String createSystemName(@Nonnull String topicSuffix, @Nonnull String prefix) throws JmriException {
        return prefix + this.typeLetter() + topicSuffix;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String suffix = systemName.substring(this.getSystemNamePrefix().length());
        String sendTopic = MessageFormat.format((String)(this.sendTopicPrefix.contains("{0}") ? this.sendTopicPrefix : this.sendTopicPrefix + "{0}"), suffix);
        String rcvTopic = MessageFormat.format((String)(this.rcvTopicPrefix.contains("{0}") ? this.rcvTopicPrefix : this.rcvTopicPrefix + "{0}"), suffix);
        MqttTurnout t = new MqttTurnout(this.getMemo().getMqttAdapter(), systemName, sendTopic, rcvTopic);
        t.setUserName(userName);
        if (this.parser != null) {
            t.setParser(this.parser);
        }
        return t;
    }

    @Override
    public String getEntryToolTip() {
        return "A string which will be inserted into \"" + this.sendTopicPrefix + "\" for transmission";
    }

    @Override
    public boolean allowMultipleAdditions(String systemName) {
        return true;
    }

    public void setParser(MqttContentParser<Turnout> parser) {
        this.parser = parser;
    }
}

