/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.jmrix.mqtt.MqttSignalMast;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSignalMastXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(MqttSignalMastXml.class);

    @Override
    public Element store(Object o) {
        MqttSignalMast p = (MqttSignalMast)o;
        Element e = new Element("mqttsignalmast");
        e.setAttribute("class", this.getClass().getName());
        e.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, e);
        Element unlit = new Element("unlit");
        if (p.allowUnLit()) {
            unlit.setAttribute("allowed", "yes");
        } else {
            unlit.setAttribute("allowed", "no");
        }
        e.addContent((Content)unlit);
        List<String> disabledAspects = p.getDisabledAspects();
        if (disabledAspects != null) {
            Element el = new Element("disabledAspects");
            for (String aspect : disabledAspects) {
                Element ele = new Element("disabledAspect");
                ele.addContent(aspect);
                el.addContent((Content)ele);
            }
            if (disabledAspects.size() != 0) {
                e.addContent((Content)el);
            }
        }
        return e;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean load(Element shared, Element perNode) {
        Element e;
        Element unlit;
        MqttSignalMast m;
        String sys = this.getSystemName(shared);
        SignalMast previous = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(sys);
        if (previous != null) {
            if (!(previous instanceof MqttSignalMast)) {
                log.error("Cannot load signal mast because system name {} is already in use.", (Object)sys);
                return false;
            }
            m = (MqttSignalMast)previous;
        } else {
            m = new MqttSignalMast(sys);
        }
        if (this.getUserName(shared) != null) {
            m.setUserName(this.getUserName(shared));
        }
        this.loadCommon(m, shared);
        if (shared.getChild("unlit") != null && (unlit = shared.getChild("unlit")).getAttribute("allowed") != null) {
            if (unlit.getAttribute("allowed").getValue().equals("no")) {
                m.setAllowUnLit(false);
            } else {
                m.setAllowUnLit(true);
            }
        }
        if ((e = shared.getChild("disabledAspects")) != null) {
            List list = e.getChildren("disabledAspect");
            for (Element aspect : list) {
                m.setAspectDisabled(aspect.getText());
            }
        }
        InstanceManager.getDefault(SignalMastManager.class).register(m);
        return true;
    }
}

