/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt.logixng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.logixng.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Publish
extends AbstractDigitalAction
implements PropertyChangeListener {
    private final LogixNG_SelectString _selectTopic = new LogixNG_SelectString(this, this);
    private final LogixNG_SelectString _selectMessage = new LogixNG_SelectString(this, this);
    private MqttSystemConnectionMemo _memo;
    private Retain _retain;
    private static final Logger log = LoggerFactory.getLogger(Publish.class);

    public Publish(String sys, String user, MqttSystemConnectionMemo memo) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._memo = memo;
        this._retain = Retain.Default;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Publish copy = new Publish(sysName, userName, this._memo);
        copy.setComment(this.getComment());
        this._selectTopic.copy(copy._selectTopic);
        this._selectMessage.copy(copy._selectMessage);
        copy.setRetain(this._retain);
        return manager.registerAction(copy);
    }

    public void setMemo(MqttSystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
    }

    public MqttSystemConnectionMemo getMemo() {
        return this._memo;
    }

    public LogixNG_SelectString getSelectTopic() {
        return this._selectTopic;
    }

    public LogixNG_SelectString getSelectMessage() {
        return this._selectMessage;
    }

    public void setRetain(Retain retain) {
        this.assertListenersAreNotRegistered(log, "setRetain");
        this._retain = retain;
    }

    public Retain getRetain() {
        return this._retain;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        String topic = this._selectTopic.evaluateValue(this.getConditionalNG());
        String data = this._selectMessage.evaluateValue(this.getConditionalNG());
        boolean retain = this._retain.getRetainValue(this._memo);
        ThreadingUtil.runOnLayoutWithJmriException(() -> this._memo.getMqttAdapter().publish(topic, data, retain));
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Publish_Short", new Object[0]);
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Publish_Long", this._selectTopic.getDescription(locale), this._selectMessage.getDescription(locale), this._retain.toString());
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        this._selectTopic.registerListeners();
        this._selectMessage.registerListeners();
    }

    @Override
    public void unregisterListenersForThisClass() {
        this._selectTopic.unregisterListeners();
        this._selectMessage.unregisterListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }

    public static enum Retain {
        Default(Bundle.getMessage("Publish_Retain_Default")),
        Yes(Bundle.getMessage("Publish_Retain_Yes")),
        No(Bundle.getMessage("Publish_Retain_No"));

        private final String _text;

        private Retain(String text) {
            this._text = text;
        }

        public boolean getRetainValue(MqttSystemConnectionMemo memo) {
            switch (this) {
                case Default: {
                    return memo.getMqttAdapter().retained;
                }
                case Yes: {
                    return true;
                }
                case No: {
                    return false;
                }
            }
            throw new IllegalArgumentException("invalid retain");
        }

        public String toString() {
            return this._text;
        }
    }
}

