/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt.logixng;

import java.util.Locale;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.Category;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.FemaleSocket;
import jmri.jmrit.logixng.actions.AbstractDigitalAction;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrix.mqtt.MqttEventListener;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.logixng.Bundle;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Subscribe
extends AbstractDigitalAction
implements MqttEventListener {
    private MqttSystemConnectionMemo _memo;
    private String _subscribeToTopic;
    private String _lastTopic;
    private String _lastMessage;
    private String _lastTopicLocalVariable;
    private boolean _removeChannelFromLastTopic;
    private String _lastMessageLocalVariable;
    private static final Logger log = LoggerFactory.getLogger(Subscribe.class);

    public Subscribe(String sys, String user, MqttSystemConnectionMemo memo) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        super(sys, user);
        this._memo = memo;
    }

    @Override
    public Base getDeepCopy(Map<String, String> systemNames, Map<String, String> userNames) throws ParserException {
        DigitalActionManager manager = InstanceManager.getDefault(DigitalActionManager.class);
        String sysName = systemNames.get(this.getSystemName());
        String userName = userNames.get(this.getSystemName());
        if (sysName == null) {
            sysName = manager.getAutoSystemName();
        }
        Subscribe copy = new Subscribe(sysName, userName, this._memo);
        copy.setComment(this.getComment());
        copy._subscribeToTopic = this._subscribeToTopic;
        copy._lastTopicLocalVariable = this._lastTopicLocalVariable;
        copy._removeChannelFromLastTopic = this._removeChannelFromLastTopic;
        copy._lastMessageLocalVariable = this._lastMessageLocalVariable;
        return manager.registerAction(copy);
    }

    public void setMemo(MqttSystemConnectionMemo memo) {
        this.assertListenersAreNotRegistered(log, "setMemo");
        this._memo = memo;
    }

    public MqttSystemConnectionMemo getMemo() {
        return this._memo;
    }

    public String getSubscribeToTopic() {
        return this._subscribeToTopic;
    }

    public void setSubscribeToTopic(String topic) {
        this._subscribeToTopic = topic;
    }

    public String getLastTopicLocalVariable() {
        return this._lastTopicLocalVariable;
    }

    public void setLastTopicLocalVariable(String variable) {
        this._lastTopicLocalVariable = variable;
    }

    public boolean getRemoveChannelFromLastTopic() {
        return this._removeChannelFromLastTopic;
    }

    public void setRemoveChannelFromLastTopic(boolean value) {
        this._removeChannelFromLastTopic = value;
    }

    public String getLastMessageLocalVariable() {
        return this._lastMessageLocalVariable;
    }

    public void setLastMessageLocalVariable(String variable) {
        this._lastMessageLocalVariable = variable;
    }

    @Override
    public Category getCategory() {
        return Category.ITEM;
    }

    @Override
    public void execute() throws JmriException {
        if (this._lastTopicLocalVariable != null && !this._lastTopicLocalVariable.isBlank()) {
            this.getConditionalNG().getSymbolTable().setValue(this._lastTopicLocalVariable, this._lastTopic);
        }
        if (this._lastMessageLocalVariable != null && !this._lastMessageLocalVariable.isBlank()) {
            this.getConditionalNG().getSymbolTable().setValue(this._lastMessageLocalVariable, this._lastMessage);
        }
    }

    @Override
    public FemaleSocket getChild(int index) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public String getShortDescription(Locale locale) {
        return Bundle.getMessage(locale, "Subscribe_Short", new Object[0]);
    }

    @Override
    public String getLongDescription(Locale locale) {
        return Bundle.getMessage(locale, "Subscribe_Long", this._subscribeToTopic);
    }

    @Override
    public void setup() {
    }

    @Override
    public void registerListenersForThisClass() {
        if (!this._listenersAreRegistered) {
            if (this._subscribeToTopic == null) {
                return;
            }
            ThreadingUtil.runOnLayout(() -> this._memo.getMqttAdapter().subscribe(this._subscribeToTopic, this));
            this._listenersAreRegistered = true;
        }
    }

    @Override
    public void unregisterListenersForThisClass() {
        if (this._listenersAreRegistered) {
            if (this._subscribeToTopic == null) {
                return;
            }
            ThreadingUtil.runOnLayout(() -> this._memo.getMqttAdapter().unsubscribe(this._subscribeToTopic, this));
            this._listenersAreRegistered = false;
        }
    }

    @Override
    public void notifyMqttMessage(String topic, String message) {
        this._lastTopic = topic;
        if (this._removeChannelFromLastTopic && this._lastTopic.startsWith(this._memo.getMqttAdapter().baseTopic)) {
            this._lastTopic = this._lastTopic.substring(this._memo.getMqttAdapter().baseTopic.length());
        }
        this._lastMessage = message;
        this.getConditionalNG().execute();
    }

    @Override
    public void disposeMe() {
    }
}

