/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt.logixng.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.util.configurexml.LogixNG_SelectStringXml;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.logixng.Publish;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class PublishXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        Publish p = (Publish)o;
        LogixNG_SelectStringXml selectTopicXml = new LogixNG_SelectStringXml();
        LogixNG_SelectStringXml selectDataXml = new LogixNG_SelectStringXml();
        Element element = new Element("MQTTPublish");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        if (p.getMemo() != null) {
            element.addContent((Content)new Element("systemConnection").addContent(p.getMemo().getSystemPrefix()));
        }
        element.addContent((Content)selectTopicXml.store(p.getSelectTopic(), "topic"));
        element.addContent((Content)selectDataXml.store(p.getSelectMessage(), "message"));
        element.addContent((Content)new Element("retain").addContent(p.getRetain().name()));
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        MqttSystemConnectionMemo memo = null;
        Element systemConnection = shared.getChild("systemConnection");
        if (systemConnection != null) {
            String systemConnectionName = systemConnection.getTextTrim();
            List<MqttSystemConnectionMemo> systemConnections = InstanceManager.getList(MqttSystemConnectionMemo.class);
            for (MqttSystemConnectionMemo m : systemConnections) {
                if (!m.getSystemPrefix().equals(systemConnectionName)) continue;
                memo = m;
                break;
            }
        }
        Publish h = new Publish(sys, uname, memo);
        LogixNG_SelectStringXml selectTopicXml = new LogixNG_SelectStringXml();
        LogixNG_SelectStringXml selectDataXml = new LogixNG_SelectStringXml();
        this.loadCommon(h, shared);
        selectTopicXml.load(shared.getChild("topic"), h.getSelectTopic());
        selectDataXml.load(shared.getChild("message"), h.getSelectMessage());
        Element retainElem = shared.getChild("retain");
        if (retainElem != null) {
            h.setRetain(Publish.Retain.valueOf(retainElem.getTextTrim()));
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

