/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt.logixng.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.logixng.Subscribe;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;

public class SubscribeXml
extends AbstractNamedBeanManagerConfigXML {
    @Override
    public Element store(Object o) {
        Subscribe p = (Subscribe)o;
        Element element = new Element("MQTTSubscribe");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        if (p.getMemo() != null) {
            element.addContent((Content)new Element("systemConnection").addContent(p.getMemo().getSystemPrefix()));
        }
        if (p.getSubscribeToTopic() != null) {
            element.addContent((Content)new Element("subscribeToTopic").addContent(p.getSubscribeToTopic()));
        }
        if (p.getLastTopicLocalVariable() != null) {
            element.addContent((Content)new Element("lastTopicLocalVariable").addContent(p.getLastTopicLocalVariable()));
        }
        element.addContent((Content)new Element("removeChannelFromLastTopic").addContent(p.getRemoveChannelFromLastTopic() ? "yes" : "no"));
        if (p.getLastMessageLocalVariable() != null) {
            element.addContent((Content)new Element("lastMessageLocalVariable").addContent(p.getLastMessageLocalVariable()));
        }
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) throws JmriConfigureXmlException {
        Element elem;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        MqttSystemConnectionMemo memo = null;
        Element systemConnection = shared.getChild("systemConnection");
        if (systemConnection != null) {
            String systemConnectionName = systemConnection.getTextTrim();
            List<MqttSystemConnectionMemo> systemConnections = InstanceManager.getList(MqttSystemConnectionMemo.class);
            for (MqttSystemConnectionMemo m : systemConnections) {
                if (!m.getSystemPrefix().equals(systemConnectionName)) continue;
                memo = m;
                break;
            }
        }
        Subscribe h = new Subscribe(sys, uname, memo);
        this.loadCommon(h, shared);
        if (shared.getChild("subscribeToTopic") != null) {
            h.setSubscribeToTopic(shared.getChild("subscribeToTopic").getTextTrim());
        }
        if (shared.getChild("lastTopicLocalVariable") != null) {
            h.setLastTopicLocalVariable(shared.getChild("lastTopicLocalVariable").getTextTrim());
        }
        h.setRemoveChannelFromLastTopic((elem = shared.getChild("removeChannelFromLastTopic")) != null ? elem.getTextTrim().equals("yes") : false);
        if (shared.getChild("lastMessageLocalVariable") != null) {
            h.setLastMessageLocalVariable(shared.getChild("lastMessageLocalVariable").getTextTrim());
        }
        InstanceManager.getDefault(DigitalActionManager.class).registerAction(h);
        return true;
    }
}

