/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt.logixng.swing;

import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectStringSwing;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.logixng.Publish;
import jmri.jmrix.mqtt.logixng.swing.Bundle;
import jmri.util.swing.JComboBoxUtil;

public class PublishSwing
extends AbstractDigitalActionSwing {
    private JComboBox<MqttConnection> _mqttConnection;
    private LogixNG_SelectStringSwing _selectTopicSwing;
    private LogixNG_SelectStringSwing _selectMessageSwing;
    private JComboBox<Publish.Retain> _retainComboBox;

    public PublishSwing() {
    }

    public PublishSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        Publish action = (Publish)object;
        if (action == null) {
            action = new Publish("IQDA1", null, null);
        }
        this._selectTopicSwing = new LogixNG_SelectStringSwing(this.getJDialog(), this);
        this._selectMessageSwing = new LogixNG_SelectStringSwing(this.getJDialog(), this);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JPanel tabbedPaneTopic = this._selectTopicSwing.createPanel(action.getSelectTopic());
        JPanel tabbedPaneData = this._selectMessageSwing.createPanel(action.getSelectMessage());
        JPanel internalPanel = new JPanel();
        JComponent[] components = new JComponent[]{tabbedPaneTopic, tabbedPaneData};
        List<JComponent> componentList = SwingConfiguratorInterface.parseMessage(Bundle.getMessage("Publish_Components"), components);
        for (JComponent c : componentList) {
            internalPanel.add(c);
        }
        JPanel mqttPanel = new JPanel();
        mqttPanel.add(new JLabel(Bundle.getMessage("MqttConnection")));
        this._mqttConnection = new JComboBox();
        List<MqttSystemConnectionMemo> systemConnections = InstanceManager.getList(MqttSystemConnectionMemo.class);
        for (MqttSystemConnectionMemo connection : systemConnections) {
            MqttConnection c = new MqttConnection(connection);
            this._mqttConnection.addItem(c);
            if (action.getMemo() != connection) continue;
            this._mqttConnection.setSelectedItem(c);
        }
        mqttPanel.add(this._mqttConnection);
        JPanel retainPanel = new JPanel();
        retainPanel.add(new JLabel(Bundle.getMessage("PublishSwing_Retain")));
        this._retainComboBox = new JComboBox();
        for (Publish.Retain e : Publish.Retain.values()) {
            this._retainComboBox.addItem(e);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._retainComboBox);
        this._retainComboBox.setSelectedItem((Object)action.getRetain());
        retainPanel.add(this._retainComboBox);
        this.panel.add(internalPanel);
        this.panel.add(retainPanel);
        this.panel.add(mqttPanel);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        Publish action = new Publish("IQDA1", null, null);
        this._selectTopicSwing.validate(action.getSelectTopic(), errorMessages);
        this._selectMessageSwing.validate(action.getSelectMessage(), errorMessages);
        return errorMessages.isEmpty();
    }

    @Override
    public String getAutoSystemName() {
        return InstanceManager.getDefault(DigitalActionManager.class).getAutoSystemName();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        MqttSystemConnectionMemo memo = this._mqttConnection.getItemAt((int)this._mqttConnection.getSelectedIndex())._memo;
        Publish action = new Publish(systemName, userName, memo);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof Publish)) {
            throw new IllegalArgumentException("object must be an Publish but is a: " + object.getClass().getName());
        }
        Publish action = (Publish)object;
        this._selectTopicSwing.updateObject(action.getSelectTopic());
        this._selectMessageSwing.updateObject(action.getSelectMessage());
        action.setMemo(this._mqttConnection.getItemAt((int)this._mqttConnection.getSelectedIndex())._memo);
        action.setRetain(this._retainComboBox.getItemAt(this._retainComboBox.getSelectedIndex()));
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Publish_Short");
    }

    @Override
    public void dispose() {
        this._selectTopicSwing.dispose();
        this._selectMessageSwing.dispose();
    }

    private static class MqttConnection {
        private MqttSystemConnectionMemo _memo;

        public MqttConnection(MqttSystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            return this._memo.getUserName();
        }
    }
}

