/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mqtt.logixng.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.logixng.Base;
import jmri.jmrit.logixng.DigitalActionManager;
import jmri.jmrit.logixng.MaleSocket;
import jmri.jmrit.logixng.actions.swing.AbstractDigitalActionSwing;
import jmri.jmrix.mqtt.MqttSystemConnectionMemo;
import jmri.jmrix.mqtt.logixng.Subscribe;
import jmri.jmrix.mqtt.logixng.swing.Bundle;

public class SubscribeSwing
extends AbstractDigitalActionSwing {
    private JComboBox<MqttConnection> _mqttConnection;
    JTextField _subscribeToTopicTextField;
    JTextField _lastTopicLocalVariableTextField;
    JCheckBox _removeChannelFromLastTopicCheckBox;
    JTextField _lastMessageLocalVariableTextField;

    public SubscribeSwing() {
    }

    public SubscribeSwing(JDialog dialog) {
        super.setJDialog(dialog);
    }

    @Override
    protected void createPanel(@CheckForNull Base object, @Nonnull JPanel buttonPanel) {
        Subscribe action = (Subscribe)object;
        if (action == null) {
            action = new Subscribe("IQDA1", null, null);
            action.setRemoveChannelFromLastTopic(true);
        }
        this.panel = new JPanel();
        JLabel subscribeToTopicLabel = new JLabel(Bundle.getMessage("Subscribe_subscribeToTopic"));
        JLabel lastTopicLocalVariableLabel = new JLabel(Bundle.getMessage("Subscribe_lastTopicLocalVariable"));
        JLabel lastMessageLocalVariableLabel = new JLabel(Bundle.getMessage("Subscribe_lastMessageLocalVariable"));
        this._subscribeToTopicTextField = new JTextField(40);
        this._lastTopicLocalVariableTextField = new JTextField(40);
        this._removeChannelFromLastTopicCheckBox = new JCheckBox(Bundle.getMessage("Subscribe_removeChannelFromLastTopic"));
        this._lastMessageLocalVariableTextField = new JTextField(40);
        this._subscribeToTopicTextField.setText(action.getSubscribeToTopic());
        this._lastTopicLocalVariableTextField.setText(action.getLastTopicLocalVariable());
        this._removeChannelFromLastTopicCheckBox.setSelected(action.getRemoveChannelFromLastTopic());
        this._lastMessageLocalVariableTextField.setText(action.getLastMessageLocalVariable());
        JPanel mqttPanel = new JPanel();
        mqttPanel.add(new JLabel(Bundle.getMessage("MqttConnection")));
        this._mqttConnection = new JComboBox();
        List<MqttSystemConnectionMemo> systemConnections = InstanceManager.getList(MqttSystemConnectionMemo.class);
        for (MqttSystemConnectionMemo connection : systemConnections) {
            MqttConnection c = new MqttConnection(connection);
            this._mqttConnection.addItem(c);
            if (action.getMemo() != connection) continue;
            this._mqttConnection.setSelectedItem(c);
        }
        mqttPanel.add(this._mqttConnection);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        this.panel.add((Component)subscribeToTopicLabel, c);
        subscribeToTopicLabel.setLabelFor(this._subscribeToTopicTextField);
        c.gridy = 1;
        this.panel.add((Component)lastTopicLocalVariableLabel, c);
        lastTopicLocalVariableLabel.setLabelFor(this._lastTopicLocalVariableTextField);
        c.gridy = 2;
        this.panel.add((Component)lastMessageLocalVariableLabel, c);
        lastMessageLocalVariableLabel.setLabelFor(this._lastMessageLocalVariableTextField);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        this.panel.add((Component)this._subscribeToTopicTextField, c);
        c.gridy = 1;
        this.panel.add((Component)this._lastTopicLocalVariableTextField, c);
        c.gridy = 2;
        this.panel.add((Component)this._lastMessageLocalVariableTextField, c);
        c.gridy = 3;
        this.panel.add((Component)this._removeChannelFromLastTopicCheckBox, c);
        c.gridwidth = 2;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 10;
        this.panel.add((Component)mqttPanel, c);
    }

    @Override
    public boolean validate(@Nonnull List<String> errorMessages) {
        return true;
    }

    @Override
    public String getAutoSystemName() {
        return InstanceManager.getDefault(DigitalActionManager.class).getAutoSystemName();
    }

    @Override
    public MaleSocket createNewObject(@Nonnull String systemName, @CheckForNull String userName) {
        MqttSystemConnectionMemo memo = this._mqttConnection.getItemAt((int)this._mqttConnection.getSelectedIndex())._memo;
        Subscribe action = new Subscribe(systemName, userName, memo);
        this.updateObject(action);
        return InstanceManager.getDefault(DigitalActionManager.class).registerAction(action);
    }

    @Override
    public void updateObject(@Nonnull Base object) {
        if (!(object instanceof Subscribe)) {
            throw new IllegalArgumentException("object must be an Subscribe but is a: " + object.getClass().getName());
        }
        Subscribe action = (Subscribe)object;
        action.setSubscribeToTopic(this._subscribeToTopicTextField.getText());
        action.setLastTopicLocalVariable(this._lastTopicLocalVariableTextField.getText());
        action.setRemoveChannelFromLastTopic(this._removeChannelFromLastTopicCheckBox.isSelected());
        action.setLastMessageLocalVariable(this._lastMessageLocalVariableTextField.getText());
        action.setMemo(this._mqttConnection.getItemAt((int)this._mqttConnection.getSelectedIndex())._memo);
    }

    @Override
    public String toString() {
        return Bundle.getMessage("Subscribe_Short");
    }

    @Override
    public void dispose() {
    }

    private static class MqttConnection {
        private MqttSystemConnectionMemo _memo;

        public MqttConnection(MqttSystemConnectionMemo memo) {
            this._memo = memo;
        }

        public String toString() {
            return this._memo.getUserName();
        }
    }
}

