/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcProgrammer;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcOpsModeProgrammer
extends MrcProgrammer
implements AddressedProgrammer {
    int mAddress;
    boolean mLongAddr;
    int addressLo = 0;
    int addressHi = 0;
    private static final Logger log = LoggerFactory.getLogger(MrcOpsModeProgrammer.class);

    public MrcOpsModeProgrammer(MrcSystemConnectionMemo memo, int pAddress, boolean pLongAddr) {
        super(memo);
        log.debug("MRC ops mode programmer {} {}", (Object)pAddress, (Object)pLongAddr);
        if (pLongAddr) {
            this.addressLo = pAddress;
            this.addressHi = pAddress >> 8;
            this.addressHi += 192;
        } else {
            this.addressLo = pAddress;
        }
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("write CV={} val={}", (Object)CV, (Object)val);
        MrcMessage msg = MrcMessage.getPOM(this.addressLo, this.addressHi, CV, val);
        this.useProgrammer(p);
        this._progRead = false;
        this.progState = 6;
        this._val = val;
        this._cv = CV;
        this.startShortTimer();
        this.memo.getMrcTrafficController().sendMrcMessage(msg);
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        log.debug("read CV={}", (Object)CV);
        log.error("readCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        log.debug("confirm CV={}", (Object)CV);
        log.error("confirmCV not available in this protocol");
        throw new ProgrammerException();
    }

    @Override
    protected void notifyProgListenerEnd(int value, int status) {
        log.debug("MrcOpsModeProgrammer adds 200mSec delay to response");
        try {
            this.wait(200L);
        }
        catch (InterruptedException e) {
            log.debug("unexpected exception", (Throwable)e);
        }
        super.notifyProgListenerEnd(value, status);
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSBYTEMODE);
        return ret;
    }

    @Override
    public boolean getCanRead() {
        return false;
    }

    @Override
    public boolean getLongAddress() {
        return this.mLongAddr;
    }

    @Override
    public int getAddressNumber() {
        return this.mAddress;
    }

    @Override
    public String getAddress() {
        return this.getAddressNumber() + " " + this.getLongAddress();
    }

    @Override
    void cleanup() {
    }
}

