/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcMessageException;
import jmri.jmrix.mrc.MrcPackets;
import jmri.jmrix.mrc.MrcPortController;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.util.StringUtil;
import jmri.util.WaitHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcPacketizer
extends MrcTrafficController {
    protected boolean echo = true;
    public LinkedList<MrcMessage> xmtList = new LinkedList();
    protected Runnable xmtHandler;
    protected Runnable rcvHandler;
    public MrcPortController controller = null;
    public DataInputStream istream = null;
    public OutputStream ostream = null;
    private static final int THROTTLEPACKETLENGTH = MrcPackets.getThrottlePacketLength();
    private static final int FUNCTIONGROUPLENGTH = MrcPackets.getFunctionPacketLength();
    private static final int READCVLENGTH = MrcPackets.getReadCVPacketLength();
    private static final int readCVReplyLength = MrcPackets.getReadCVPacketReplyLength();
    private static final int readDecoderAddressLength = MrcPackets.getReadDecoderAddressLength();
    private static final int WRITECVPROGLENGTH = MrcPackets.getWriteCVPROGPacketLength();
    private static final int WRITECVPOMLENGTH = MrcPackets.getWriteCVPOMPacketLength();
    private static final int SETCLOCKRATIOLENGTH = MrcPackets.getSetClockRatioPacketLength();
    private static final int SETCLOCKTIMELENGTH = MrcPackets.getSetClockTimePacketLength();
    private static final int setClockAMPMLength = MrcPackets.getSetClockAmPmPacketLength();
    private static final int powerOnLength = MrcPackets.getPowerOnPacketLength();
    private static final int powerOffLength = MrcPackets.getPowerOffPacketLength();
    private static final int addToConsistLength = MrcPackets.getClearConsistPacketLength();
    private static final int clearConsistLength = MrcPackets.getClearConsistPacketLength();
    private static final int routeControlLength = MrcPackets.getRouteControlPacketLength();
    private static final int clearRouteLength = MrcPackets.getClearRoutePacketLength();
    private static final int addToRouteLength = MrcPackets.getAddToRoutePacketLength();
    private static final int accessoryLength = MrcPackets.getAccessoryPacketLength();
    private byte[] rcvBuffer = new byte[1];
    static final int IDLESTATE = 0;
    static final int WAITFORCMDRECEIVED = 1;
    static final int DOUBLELOCOCONTROL = 2;
    static final int MISSEDPOLL = 4;
    static final int BADCOMMAND = 8;
    static final int CONFIRMATIONONLY = 16;
    int mCurrentState = 0;
    int consecutiveMissedPolls = 0;
    final MrcMessage noData = MrcMessage.setNoData();
    final byte[] noDataMsg = new byte[]{0, 0, 0, 0};
    static final Object transmitLock = new Object();
    private static final Logger log = LoggerFactory.getLogger(MrcPacketizer.class);

    @Override
    public boolean status() {
        return this.ostream != null && this.istream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMrcMessage(MrcMessage m) {
        ++this.transmittedMsgCount;
        m.setByteStream();
        if (log.isDebugEnabled()) {
            log.debug("queue Mrc packet: {}", (Object)m.toString());
        }
        try {
            Runnable runnable = this.xmtHandler;
            synchronized (runnable) {
                this.xmtList.addLast(m);
                if (log.isDebugEnabled()) {
                    log.debug("xmt list size {}", (Object)this.xmtList.size());
                    Iterator iterator = this.xmtList.iterator();
                    while (iterator.hasNext()) {
                        log.debug("  entry: {}", (Object)((MrcMessage)iterator.next()).toString());
                    }
                }
            }
        }
        catch (RuntimeException e) {
            log.warn("passing to xmit: unexpected exception", (Throwable)e);
        }
    }

    @Override
    public boolean isXmtBusy() {
        if (this.controller == null) {
            return false;
        }
        return !this.controller.okToSend();
    }

    public void connectPort(MrcPortController p) {
        this.istream = p.getInputStream();
        this.ostream = p.getOutputStream();
        if (this.controller != null) {
            log.warn("connectPort: connect called while connected");
        }
        this.controller = p;
    }

    public void disconnectPort(MrcPortController p) {
        this.istream = null;
        this.ostream = null;
        if (this.controller != p) {
            log.warn("disconnectPort: disconnect called from non-connected MrcPortController");
        }
        this.controller = null;
    }

    protected byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        while ((nchars = istream.read(this.rcvBuffer, 0, 1)) <= 0) {
        }
        return this.rcvBuffer[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="passing InterruptMessage unchanged")
    protected void transmitWait(int waitTime, int state, String InterruptMessage, int x) {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        long endTime = currentTime + (long)waitTime;
        while (endTime > (currentTime = Calendar.getInstance().getTimeInMillis())) {
            long wait = endTime - currentTime;
            try {
                Object object = transmitLock;
                synchronized (object) {
                    if (this.mCurrentState != state) {
                        return;
                    }
                    transmitLock.wait(wait);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error(InterruptMessage);
            }
        }
        log.debug("Timeout in transmitWait {}, mCurrentState: {} after {}", new Object[]{x, this.mCurrentState, waitTime});
    }

    protected void messageFailed(MrcMessage m) {
        log.debug("message transmitted");
        if (m.getSource() == null) {
            return;
        }
        SwingUtilities.invokeLater(new Failed(new Date(), m));
    }

    protected void messageTransmitted(MrcMessage msg) {
        if (!this.echo) {
            return;
        }
        SwingUtilities.invokeLater(new Echo(this, new Date(), msg));
    }

    public void startThreads() {
        int xmtpriority;
        int priority = Thread.currentThread().getPriority();
        log.debug("startThreads current priority = {} max available = 10 default = 5 min available = 1", (Object)priority);
        int n = xmtpriority = 9 > priority ? 10 : 9;
        if (this.xmtHandler == null) {
            this.xmtHandler = new XmtHandler();
        }
        Thread xmtThread = new Thread(this.xmtHandler, "Mrc transmit handler");
        log.debug("Xmt thread starts at priority {}", (Object)xmtpriority);
        xmtThread.setDaemon(true);
        xmtThread.setPriority(9);
        xmtThread.start();
        if (this.rcvHandler == null) {
            this.rcvHandler = new RcvHandler(this);
        }
        Thread rcvThread = new Thread(this.rcvHandler, "Mrc receive handler 10");
        rcvThread.setDaemon(true);
        rcvThread.setPriority(10);
        rcvThread.start();
    }

    static class Echo
    implements Runnable {
        MrcMessage msgForLater;
        MrcPacketizer myTc;
        Date timestamp;

        Echo(MrcPacketizer t, Date _timestamp, MrcMessage m) {
            this.myTc = t;
            this.msgForLater = m;
            this.timestamp = _timestamp;
        }

        @Override
        public void run() {
            this.myTc.notifyXmit(this.timestamp, this.msgForLater);
        }
    }

    static class Failed
    implements Runnable {
        MrcMessage msgForLater;
        Date timestamp;

        Failed(Date _timestamp, MrcMessage m) {
            this.msgForLater = m;
            this.timestamp = _timestamp;
        }

        @Override
        public void run() {
            this.msgForLater.getSource().notifyFailedXmit(this.timestamp, this.msgForLater);
        }
    }

    class XmtHandler
    implements Runnable {
        XmtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int x = 0;
            int state = 1;
            while (true) {
                MrcMessage m = MrcPacketizer.this.noData;
                byte[] msg = MrcPacketizer.this.noDataMsg;
                log.trace("check for input");
                XmtHandler xmtHandler = this;
                synchronized (xmtHandler) {
                    log.trace("start wait");
                    new WaitHandler(this);
                    log.trace("end wait");
                    if (MrcPacketizer.this.xmtList.size() != 0) {
                        m = MrcPacketizer.this.xmtList.removeFirst();
                        msg = m.getByteStream();
                        log.debug("xmt list size after get {}", (Object)MrcPacketizer.this.xmtList.size());
                        log.debug("Message to send on {}", (Object)m);
                    }
                }
                try {
                    if (m.getMessageClass() != 64) {
                        MrcPacketizer.this.mCurrentState = 1;
                        if (!m.isReplyExpected()) {
                            MrcPacketizer.this.mCurrentState = 16;
                        }
                        state = MrcPacketizer.this.mCurrentState;
                    }
                    MrcPacketizer.this.ostream.write(msg);
                    MrcPacketizer.this.ostream.flush();
                    MrcPacketizer.this.messageTransmitted(m);
                    if (m.getMessageClass() != 64) {
                        if (log.isTraceEnabled()) {
                            log.trace("end write to stream: {}", (Object)StringUtil.hexStringFromBytes(msg));
                            log.trace("wait : {} : {}", (Object)m.getTimeout(), (Object)x);
                        }
                        MrcPacketizer.this.transmitWait(m.getTimeout(), state, "transmitLoop interrupted", x);
                        ++x;
                    } else {
                        MrcPacketizer.this.mCurrentState = 0;
                    }
                    if (MrcPacketizer.this.mCurrentState == 1 || MrcPacketizer.this.mCurrentState == 16) {
                        log.debug("Timed out");
                        if (m.getRetries() >= 0) {
                            m.setRetries(m.getRetries() - 1);
                            xmtHandler = this;
                            synchronized (xmtHandler) {
                                MrcPacketizer.this.xmtList.addFirst(m);
                            }
                        } else {
                            MrcPacketizer.this.messageFailed(m);
                        }
                        MrcPacketizer.this.mCurrentState = 0;
                        MrcPacketizer.this.consecutiveMissedPolls = 0;
                        continue;
                    }
                    if (MrcPacketizer.this.mCurrentState == 4 && m.getRetries() >= 0) {
                        ++MrcPacketizer.this.consecutiveMissedPolls;
                        log.debug("Missed add to front");
                        if (MrcPacketizer.this.consecutiveMissedPolls < 5) {
                            xmtHandler = this;
                            synchronized (xmtHandler) {
                                MrcPacketizer.this.xmtList.addFirst(m);
                                MrcPacketizer.this.mCurrentState = 0;
                                if (log.isDebugEnabled()) {
                                    log.debug("xmt list size {}", (Object)MrcPacketizer.this.xmtList.size());
                                    Iterator iterator = MrcPacketizer.this.xmtList.iterator();
                                    while (iterator.hasNext()) {
                                        log.debug("message: {}", (Object)((MrcMessage)iterator.next()).toString());
                                    }
                                }
                                continue;
                            }
                        }
                        log.warn("Message missed {} polls for message {}", (Object)MrcPacketizer.this.consecutiveMissedPolls, (Object)m);
                        MrcPacketizer.this.consecutiveMissedPolls = 0;
                        continue;
                    }
                    if (MrcPacketizer.this.mCurrentState == 2 && m.getRetries() >= 0) {
                        if (log.isDebugEnabled()) {
                            log.debug("Auto Retry send message added back to queue: {}", (Object)Arrays.toString(msg));
                        }
                        m.setRetries(m.getRetries() - 1);
                        xmtHandler = this;
                        synchronized (xmtHandler) {
                            MrcPacketizer.this.xmtList.addFirst(m);
                            MrcPacketizer.this.mCurrentState = 0;
                        }
                        MrcPacketizer.this.consecutiveMissedPolls = 0;
                        continue;
                    }
                    if (MrcPacketizer.this.mCurrentState != 8) continue;
                    log.debug("Bad command sent");
                    MrcPacketizer.this.messageFailed(m);
                    MrcPacketizer.this.mCurrentState = 0;
                    MrcPacketizer.this.consecutiveMissedPolls = 0;
                    continue;
                }
                catch (IOException e) {
                    log.warn("sendMrcMessage: IOException", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class RcvHandler
    implements Runnable {
        MrcPacketizer trafficController;

        public RcvHandler(MrcPacketizer lt) {
            this.trafficController = lt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int firstByte = MrcPacketizer.this.readByteProtected(MrcPacketizer.this.istream) & 0xFF;
                        int secondByte = MrcPacketizer.this.readByteProtected(MrcPacketizer.this.istream) & 0xFF;
                        int thirdByte = MrcPacketizer.this.readByteProtected(MrcPacketizer.this.istream) & 0xFF;
                        while ((secondByte != 0 && secondByte != 1 || firstByte != thirdByte) && (firstByte != 0 || secondByte != 1)) {
                            log.debug("Skipping: {} {} {}", new Object[]{Integer.toHexString(firstByte), Integer.toHexString(secondByte), Integer.toHexString(thirdByte)});
                            firstByte = secondByte;
                            secondByte = thirdByte;
                            thirdByte = MrcPacketizer.this.readByteProtected(MrcPacketizer.this.istream) & 0xFF;
                        }
                        final Date time = new Date();
                        log.trace(" (RcvHandler) Start message with message: {} {}", (Object)Integer.toHexString(firstByte), (Object)Integer.toHexString(secondByte));
                        MrcMessage msg = null;
                        boolean pollForUs = false;
                        if (secondByte == 1) {
                            msg = new MrcMessage(6);
                            msg.setMessageClass(64);
                            if (firstByte == MrcPacketizer.this.cabAddress) {
                                pollForUs = true;
                            } else if (MrcPacketizer.this.mCurrentState == 1) {
                                log.debug("Missed our poll slot");
                                Object object = transmitLock;
                                synchronized (object) {
                                    MrcPacketizer.this.mCurrentState = 4;
                                    transmitLock.notify();
                                }
                            }
                            if (firstByte == 0) {
                                msg.setMessageClass(96);
                            }
                        } else {
                            switch (firstByte) {
                                case 0: {
                                    msg = new MrcMessage(4);
                                    msg.setMessageClass(64);
                                    break;
                                }
                                case 37: {
                                    msg = new MrcMessage(THROTTLEPACKETLENGTH);
                                    msg.setMessageClass(1);
                                    break;
                                }
                                case 52: 
                                case 68: 
                                case 84: 
                                case 116: 
                                case 132: 
                                case 164: {
                                    msg = new MrcMessage(FUNCTIONGROUPLENGTH);
                                    msg.setMessageClass(1);
                                    break;
                                }
                                case 67: {
                                    msg = new MrcMessage(READCVLENGTH);
                                    msg.setMessageClass(2);
                                    log.debug("Read CV Cmd");
                                    break;
                                }
                                case 66: {
                                    msg = new MrcMessage(readDecoderAddressLength);
                                    msg.setMessageClass(2);
                                    break;
                                }
                                case 36: {
                                    msg = new MrcMessage(WRITECVPROGLENGTH);
                                    msg.setMessageClass(2);
                                    break;
                                }
                                case 86: {
                                    msg = new MrcMessage(WRITECVPOMLENGTH);
                                    msg.setMessageClass(2);
                                    break;
                                }
                                case 18: {
                                    msg = new MrcMessage(SETCLOCKRATIOLENGTH);
                                    msg.setMessageClass(32);
                                    break;
                                }
                                case 19: {
                                    msg = new MrcMessage(SETCLOCKTIMELENGTH);
                                    msg.setMessageClass(32);
                                    break;
                                }
                                case 50: {
                                    msg = new MrcMessage(setClockAMPMLength);
                                    msg.setMessageClass(32);
                                    break;
                                }
                                case 102: {
                                    msg = new MrcMessage(readCVReplyLength);
                                    msg.setMessageClass(2);
                                    Object object = transmitLock;
                                    synchronized (object) {
                                        MrcPacketizer.this.mCurrentState = 0;
                                        transmitLock.notify();
                                    }
                                    log.debug("CV read reply");
                                    break;
                                }
                                case 51: {
                                    log.debug("Gd Prog Cmd Sent");
                                    Object object = transmitLock;
                                    synchronized (object) {
                                        MrcPacketizer.this.mCurrentState = 0;
                                        transmitLock.notify();
                                    }
                                    msg = new MrcMessage(4);
                                    msg.setMessageClass(2);
                                    break;
                                }
                                case 130: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(powerOnLength);
                                    msg.setMessageClass(16);
                                    break;
                                }
                                case 146: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(powerOffLength);
                                    msg.setMessageClass(16);
                                    break;
                                }
                                case 100: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(addToConsistLength);
                                    msg.setMessageClass(1);
                                    break;
                                }
                                case 98: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(clearConsistLength);
                                    msg.setMessageClass(1);
                                    break;
                                }
                                case 195: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(routeControlLength);
                                    msg.setMessageClass(4);
                                    break;
                                }
                                case 210: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(clearRouteLength);
                                    msg.setMessageClass(4);
                                    break;
                                }
                                case 211: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(addToRouteLength);
                                    msg.setMessageClass(4);
                                    break;
                                }
                                case 115: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(accessoryLength);
                                    msg.setMessageClass(4);
                                    break;
                                }
                                case 221: {
                                    Object object = transmitLock;
                                    synchronized (object) {
                                        MrcPacketizer.this.mCurrentState = 2;
                                        transmitLock.notify();
                                    }
                                    msg = new MrcMessage(4);
                                    msg.setMessageClass(1);
                                    break;
                                }
                                case 34: {
                                    MrcPacketizer.this.mCurrentState = 0;
                                    msg = new MrcMessage(4);
                                    msg.setMessageClass(1);
                                    Object object = transmitLock;
                                    synchronized (object) {
                                        MrcPacketizer.this.mCurrentState = 0;
                                        transmitLock.notify();
                                        break;
                                    }
                                }
                                case 85: {
                                    if (MrcPacketizer.this.mCurrentState == 16) {
                                        Object object = transmitLock;
                                        synchronized (object) {
                                            MrcPacketizer.this.mCurrentState = 0;
                                            transmitLock.notify();
                                        }
                                    }
                                    msg = new MrcMessage(4);
                                    break;
                                }
                                case 238: {
                                    MrcPacketizer.this.mCurrentState = 8;
                                    msg = new MrcMessage(4);
                                    break;
                                }
                                default: {
                                    msg = new MrcMessage(4);
                                    log.debug("UNKNOWN {}", (Object)Integer.toHexString(firstByte));
                                }
                            }
                        }
                        msg.setElement(0, firstByte);
                        msg.setElement(1, secondByte);
                        msg.setElement(2, thirdByte);
                        int len = msg.getNumDataElements();
                        log.trace("len: {}", (Object)len);
                        for (int i = 3; i < len; ++i) {
                            int b = MrcPacketizer.this.readByteProtected(MrcPacketizer.this.istream) & 0xFF;
                            msg.setElement(i, b);
                            log.trace("char {} is: {}", (Object)i, (Object)Integer.toHexString(b));
                        }
                        if (pollForUs) {
                            Runnable i = MrcPacketizer.this.xmtHandler;
                            synchronized (i) {
                                MrcPacketizer.this.xmtHandler.notify();
                            }
                        }
                        if ((msg.getMessageClass() & 0x40) != 64 && msg.getNumDataElements() > 6) {
                            if (!msg.validCheckSum()) {
                                log.warn("Ignore Mrc packet with bad checksum: {}", (Object)msg);
                                throw new MrcMessageException();
                            }
                            for (int i = 1; i < msg.getNumDataElements(); i += 2) {
                                if (msg.getElement(i) == 0) continue;
                                log.warn("Ignore Mrc packet with bad bit: {}", (Object)msg);
                                throw new MrcMessageException();
                            }
                        }
                        log.trace("queue message for notification: {}", (Object)msg);
                        final MrcMessage thisMsg = msg;
                        final MrcPacketizer thisTc = this.trafficController;
                        Runnable r = new Runnable(){
                            MrcMessage msgForLater;
                            MrcPacketizer myTc;
                            {
                                this.msgForLater = thisMsg;
                                this.myTc = thisTc;
                            }

                            @Override
                            public void run() {
                                this.myTc.notifyRcv(time, this.msgForLater);
                            }
                        };
                        SwingUtilities.invokeLater(r);
                    }
                }
                catch (MrcMessageException e) {
                    log.warn("run: unexpected MrcMessageException", (Throwable)e);
                    continue;
                }
                catch (EOFException e) {
                    log.trace("EOFException, is Mrc serial I/O using timeouts?");
                    continue;
                }
                catch (IOException e) {
                    log.debug("IOException, should only happen with HexFile", (Throwable)e);
                    MrcPacketizer.this.disconnectPort(MrcPacketizer.this.controller);
                    return;
                }
                catch (RuntimeException e) {
                    log.warn("Unknown Exception", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

