/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.ClockControl;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.Programmer;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.mrc.MrcClockControl;
import jmri.jmrix.mrc.MrcPowerManager;
import jmri.jmrix.mrc.MrcProgrammer;
import jmri.jmrix.mrc.MrcProgrammerManager;
import jmri.jmrix.mrc.MrcThrottleManager;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.jmrix.mrc.MrcTurnoutManager;
import jmri.jmrix.mrc.swing.MrcComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcSystemConnectionMemo
extends DefaultSystemConnectionMemo {
    ComponentFactory componentFactory = null;
    private MrcTrafficController mrcTrafficController;
    private static final Logger log = LoggerFactory.getLogger((String)MrcSystemConnectionMemo.class.getName());

    public MrcSystemConnectionMemo() {
        super("M", "MRC");
        this.register();
        InstanceManager.store(this, MrcSystemConnectionMemo.class);
        this.componentFactory = new MrcComponentFactory(this);
        InstanceManager.store(this.componentFactory, ComponentFactory.class);
    }

    public MrcTrafficController getMrcTrafficController() {
        if (this.mrcTrafficController == null) {
            log.error("found tc null in request", (Throwable)new Exception("traceback"));
        }
        return this.mrcTrafficController;
    }

    public void setMrcTrafficController(MrcTrafficController tc) {
        this.mrcTrafficController = tc;
        if (tc != null) {
            tc.setAdapterMemo(this);
        }
    }

    public MrcProgrammerManager getProgrammerManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (MrcProgrammerManager)this.classObjectMap.computeIfAbsent(MrcProgrammerManager.class, c -> new MrcProgrammerManager((Programmer)new MrcProgrammer(this), this));
    }

    public void setProgrammerManager(MrcProgrammerManager p) {
        this.store(p, MrcProgrammerManager.class);
    }

    public void configureManagers() {
        MrcPowerManager powerManager = new MrcPowerManager(this);
        this.store(powerManager, PowerManager.class);
        InstanceManager.store(powerManager, PowerManager.class);
        MrcTurnoutManager turnoutManager = new MrcTurnoutManager(this);
        this.store(turnoutManager, TurnoutManager.class);
        InstanceManager.setTurnoutManager(turnoutManager);
        MrcThrottleManager throttleManager = new MrcThrottleManager(this);
        this.store(throttleManager, ThrottleManager.class);
        InstanceManager.setThrottleManager(throttleManager);
        if (this.getProgrammerManager().isAddressedModePossible()) {
            this.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            this.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        MrcClockControl clockManager = new MrcClockControl(this.getMrcTrafficController(), this.getSystemPrefix());
        this.store(clockManager, ClockControl.class);
        InstanceManager.store(clockManager, ClockControl.class);
        InstanceManager.setDefault(ClockControl.class, clockManager);
    }

    public MrcPowerManager getPowerManager() {
        return (MrcPowerManager)this.get(PowerManager.class);
    }

    public MrcTurnoutManager getTurnoutManager() {
        return (MrcTurnoutManager)this.get(TurnoutManager.class);
    }

    public MrcThrottleManager getThrottleManager() {
        return (MrcThrottleManager)this.get(ThrottleManager.class);
    }

    public MrcClockControl getClockControl() {
        return (MrcClockControl)this.get(ClockControl.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.mrc.MrcActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        this.mrcTrafficController = null;
        InstanceManager.deregister(this, MrcSystemConnectionMemo.class);
        if (this.componentFactory != null) {
            InstanceManager.deregister(this.componentFactory, ComponentFactory.class);
        }
        super.dispose();
    }
}

