/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Date;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.jmrix.AbstractThrottle;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcPackets;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.jmrix.mrc.MrcTrafficListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrcThrottle
extends AbstractThrottle
implements MrcTrafficListener {
    private MrcTrafficController tc = null;
    DccLocoAddress address;
    int addressLo = 0;
    int addressHi = 0;
    private static final Logger log = LoggerFactory.getLogger(MrcThrottle.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MrcThrottle(MrcSystemConnectionMemo memo, DccLocoAddress address) {
        super(memo);
        this.tc = memo.getMrcTrafficController();
        this.speedStepMode = SpeedStepMode.NMRA_DCC_128;
        MrcThrottle mrcThrottle = this;
        synchronized (mrcThrottle) {
            this.speedSetting = 0.0f;
        }
        this.address = address;
        this.isForward = true;
        if (address.isLongAddress()) {
            this.addressLo = address.getNumber();
            this.addressHi = address.getNumber() >> 8;
            this.addressHi += 192;
        } else {
            this.addressLo = address.getNumber();
        }
        this.tc.addTrafficListener(1, this);
    }

    @Override
    public LocoAddress getLocoAddress() {
        return this.address;
    }

    @Override
    protected void sendFunctionGroup1() {
        int data = 0 | (this.getFunction(0) ? 16 : 0) | (this.getFunction(1) ? 1 : 0) | (this.getFunction(2) ? 2 : 0) | (this.getFunction(3) ? 4 : 0) | (this.getFunction(4) ? 8 : 0);
        MrcMessage m = MrcMessage.getSendFunction(1, this.addressLo, this.addressHi, data += 128);
        if (m != null) {
            this.tc.sendMrcMessage(m);
        }
    }

    @Override
    protected void sendFunctionGroup2() {
        int data = 0 | (this.getFunction(8) ? 8 : 0) | (this.getFunction(7) ? 4 : 0) | (this.getFunction(6) ? 2 : 0) | (this.getFunction(5) ? 1 : 0);
        MrcMessage m = MrcMessage.getSendFunction(2, this.addressLo, this.addressHi, data += 176);
        if (m != null) {
            this.tc.sendMrcMessage(m);
        }
    }

    @Override
    protected void sendFunctionGroup3() {
        int data = 0 | (this.getFunction(9) ? 1 : 0) | (this.getFunction(10) ? 2 : 0) | (this.getFunction(11) ? 4 : 0) | (this.getFunction(12) ? 8 : 0);
        MrcMessage m = MrcMessage.getSendFunction(3, this.addressLo, this.addressHi, data += 160);
        if (m != null) {
            this.tc.sendMrcMessage(m);
        }
    }

    @Override
    protected void sendFunctionGroup4() {
        int data = 0 | (this.getFunction(16) ? 8 : 0) | (this.getFunction(15) ? 4 : 0) | (this.getFunction(14) ? 2 : 0) | (this.getFunction(13) ? 1 : 0);
        MrcMessage m = MrcMessage.getSendFunction(4, this.addressLo, this.addressHi, data += 208);
        if (m != null) {
            this.tc.sendMrcMessage(m);
        }
        data = 0 | (this.getFunction(20) ? 8 : 0) | (this.getFunction(19) ? 4 : 0) | (this.getFunction(18) ? 2 : 0) | (this.getFunction(17) ? 1 : 0);
        m = MrcMessage.getSendFunction(5, this.addressLo, this.addressHi, data += 192);
        if (m != null) {
            this.tc.sendMrcMessage(m);
        }
    }

    @Override
    protected void sendFunctionGroup5() {
        int data = 0 | (this.getFunction(28) ? 128 : 0) | (this.getFunction(27) ? 64 : 0) | (this.getFunction(26) ? 32 : 0) | (this.getFunction(25) ? 16 : 0) | (this.getFunction(24) ? 8 : 0) | (this.getFunction(23) ? 4 : 0) | (this.getFunction(22) ? 2 : 0) | (this.getFunction(21) ? 1 : 0);
        MrcMessage m = MrcMessage.getSendFunction(6, this.addressLo, this.addressHi, data);
        if (m != null) {
            this.tc.sendMrcMessage(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
    public void setSpeedSetting(float speed) {
        MrcMessage m;
        float oldSpeed;
        MrcThrottle mrcThrottle = this;
        synchronized (mrcThrottle) {
            oldSpeed = this.speedSetting;
            this.speedSetting = speed;
        }
        if (this.speedStepMode == SpeedStepMode.NMRA_DCC_128) {
            log.debug("setSpeedSetting= {}", (Object)Float.valueOf(speed));
            int value = (int)(126.0f * speed);
            if (value > 0) {
                ++value;
            }
            if (value > 127) {
                value = 127;
            }
            if (value < 0) {
                value = 1;
            }
            if (this.isForward) {
                value += 128;
            }
            m = MrcMessage.getSendSpeed128(this.addressLo, this.addressHi, value);
        } else {
            int value = (int)(28.0f * speed);
            if (value > 0) {
                value += 3;
            }
            if (value > 32) {
                value = 31;
            }
            if (value < 0) {
                value = 2;
            }
            m = MrcMessage.getSendSpeed28(this.addressLo, this.addressHi, value, this.isForward);
        }
        this.tc.sendMrcMessage(m);
        MrcThrottle mrcThrottle2 = this;
        synchronized (mrcThrottle2) {
            this.firePropertyChange("SpeedSetting", Float.valueOf(oldSpeed), Float.valueOf(this.speedSetting));
        }
        this.record(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsForward(boolean forward) {
        boolean old = this.isForward;
        this.isForward = forward;
        MrcThrottle mrcThrottle = this;
        synchronized (mrcThrottle) {
            this.setSpeedSetting(this.speedSetting);
        }
        log.debug("setIsForward= {}", (Object)forward);
        this.firePropertyChange("IsForward", old, this.isForward);
    }

    @Override
    public void throttleDispose() {
        this.finishRecord();
    }

    public String toString() {
        return this.getLocoAddress().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="fixed number of possible values")
    public void notifyRcv(Date timestamp, MrcMessage m) {
        if (m.getMessageClass() != 1 || m.getMessageClass() == 1 && (m.getElement(0) == 34 || m.getElement(0) == 221)) {
            return;
        }
        if (m.getLocoAddress() == this.address.getNumber()) {
            if (MrcPackets.startsWith(m, MrcPackets.THROTTLEPACKETHEADER)) {
                MrcThrottle mrcThrottle = this;
                synchronized (mrcThrottle) {
                    if (m.getElement(10) == 2) {
                        float val;
                        log.debug("speed Packet from another controller for our loco");
                        int speed = m.getElement(8);
                        if ((m.getElement(8) & 0x80) == 128) {
                            if (!this.isForward) {
                                this.isForward = true;
                                this.firePropertyChange("IsForward", !this.isForward, this.isForward);
                            }
                        } else if (this.isForward) {
                            this.isForward = false;
                            this.firePropertyChange("IsForward", !this.isForward, this.isForward);
                        }
                        if ((speed = (speed & 0x7F) - 1) < 0) {
                            speed = 0;
                        }
                        if ((val = (float)speed / 126.0f) != this.speedSetting) {
                            float old = this.speedSetting;
                            this.speedSetting = val;
                            this.firePropertyChange("SpeedSetting", Float.valueOf(old), Float.valueOf(this.speedSetting));
                            this.record(val);
                        }
                    } else if (m.getElement(10) == 0) {
                        int value = m.getElement(8) & 0xFF;
                        value = (m.getElement(8) & 0x60) == 96 ? (value -= 96) : (value -= 64);
                        if ((value >> 4 & 1) == 1) {
                            value -= 16;
                            value = (value << 1) + 1;
                        } else {
                            value <<= 1;
                        }
                        float val = -1.0f;
                        if ((value -= 3) != -1) {
                            if (value < 1) {
                                value = 0;
                            }
                            val = (float)value / 28.0f;
                        }
                        if (val != this.speedSetting) {
                            this.firePropertyChange("SpeedSetting", Float.valueOf(this.speedSetting), Float.valueOf(val));
                            this.speedSetting = val;
                            this.record(val);
                        }
                    }
                }
            } else if (MrcPackets.startsWith(m, MrcPackets.FUNCTIONGROUP1PACKETHEADER)) {
                int data = m.getElement(8) & 0xFF;
                this.updateFunction(0, (data & 0x10) == 16);
                this.updateFunction(1, (data & 1) == 1);
                this.updateFunction(2, (data & 2) == 2);
                this.updateFunction(3, (data & 4) == 4);
                this.updateFunction(4, (data & 8) == 8);
            } else if (MrcPackets.startsWith(m, MrcPackets.FUNCTIONGROUP2PACKETHEADER)) {
                int data = m.getElement(8) & 0xFF;
                this.updateFunction(5, (data & 1) == 1);
                this.updateFunction(6, (data & 2) == 2);
                this.updateFunction(7, (data & 4) == 4);
                this.updateFunction(8, (data & 8) == 8);
            } else if (MrcPackets.startsWith(m, MrcPackets.FUNCTIONGROUP3PACKETHEADER)) {
                int data = m.getElement(8) & 0xFF;
                this.updateFunction(9, (data & 1) == 1);
                this.updateFunction(10, (data & 2) == 2);
                this.updateFunction(11, (data & 4) == 4);
                this.updateFunction(12, (data & 8) == 8);
            } else if (MrcPackets.startsWith(m, MrcPackets.FUNCTIONGROUP4PACKETHEADER)) {
                int data = m.getElement(8) & 0xFF;
                this.updateFunction(13, (data & 1) == 1);
                this.updateFunction(14, (data & 2) == 2);
                this.updateFunction(15, (data & 4) == 4);
                this.updateFunction(16, (data & 8) == 8);
            } else if (MrcPackets.startsWith(m, MrcPackets.FUNCTIONGROUP5PACKETHEADER)) {
                int data = m.getElement(8) & 0xFF;
                this.updateFunction(17, (data & 1) == 1);
                this.updateFunction(18, (data & 2) == 2);
                this.updateFunction(19, (data & 4) == 4);
                this.updateFunction(20, (data & 8) == 8);
            } else if (MrcPackets.startsWith(m, MrcPackets.FUNCTIONGROUP6PACKETHEADER)) {
                int data = m.getElement(8) & 0xFF;
                this.updateFunction(21, (data & 1) == 1);
                this.updateFunction(22, (data & 2) == 2);
                this.updateFunction(23, (data & 4) == 4);
                this.updateFunction(24, (data & 8) == 8);
                this.updateFunction(25, (data & 0x10) == 16);
                this.updateFunction(26, (data & 0x20) == 32);
                this.updateFunction(27, (data & 0x40) == 64);
                this.updateFunction(28, (data & 0x80) == 128);
            }
        }
    }

    @Override
    public void notifyXmit(Date timestamp, MrcMessage m) {
    }

    @Override
    public void notifyFailedXmit(Date timestamp, MrcMessage m) {
    }
}

