/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc;

import javax.annotation.Nonnull;
import jmri.Turnout;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.MrcTrafficController;
import jmri.jmrix.mrc.MrcTurnout;
import jmri.managers.AbstractTurnoutManager;

public class MrcTurnoutManager
extends AbstractTurnoutManager {
    MrcTrafficController tc = null;

    public MrcTurnoutManager(MrcSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getMrcTrafficController();
    }

    @Override
    @Nonnull
    public MrcSystemConnectionMemo getMemo() {
        return (MrcSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a Turnout address");
        }
        MrcTurnout t = new MrcTurnout(addr, this.tc, this.getSystemPrefix());
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }
}

