/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc.serialdriver;

import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.SerialPort;
import jmri.jmrix.mrc.MrcPacketizer;
import jmri.jmrix.mrc.MrcPortController;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.jmrix.mrc.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends MrcPortController {
    protected String[] validOption1 = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new MrcSystemConnectionMemo());
        this.setManufacturer("MRC");
        this.options.put("CabAddress", new AbstractPortController.Option("Cab Address:", this.validOption1, false));
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = SerialDriverAdapter.activatePort(this.getSystemPrefix(), portName, log, 1, SerialPort.Parity.ODD);
        if (this.currentSerialPort == null) {
            log.error("failed to connect MRC to {}", (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("Connecting MRC to {} {}", (Object)portName, (Object)this.currentSerialPort);
        int baud = this.currentBaudNumber(this.getCurrentBaudRate());
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        MrcPacketizer packets = new MrcPacketizer();
        packets.connectPort(this);
        this.getSystemConnectionMemo().setMrcTrafficController(packets);
        packets.setAdapterMemo(this.getSystemConnectionMemo());
        packets.setCabNumber(Integer.parseInt(this.getOptionState("CabAddress")));
        this.getSystemConnectionMemo().configureManagers();
        packets.startThreads();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return new String[]{"38,400 bps"};
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[]{38400};
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

