/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.mrc.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.mrc.MrcMessage;
import jmri.jmrix.mrc.MrcPacketizer;
import jmri.jmrix.mrc.MrcPortController;
import jmri.jmrix.mrc.MrcSystemConnectionMemo;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends MrcPortController
implements Runnable {
    private Thread sourceThread;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new MrcSystemConnectionMemo());
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: ", (Throwable)e);
        }
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        MrcPacketizer tc = new MrcPacketizer();
        tc.connectPort(this);
        this.getSystemConnectionMemo().setMrcTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        tc.setCabNumber(2);
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Mrc Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
        tc.startThreads();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.info("MRC Simulator Started");
        int cab = 1;
        while (true) {
            try {
                SimulatorAdapter simulatorAdapter = this;
                synchronized (simulatorAdapter) {
                    this.wait(100L);
                }
            }
            catch (InterruptedException e) {
                log.debug("Interrupted, ending");
                return;
            }
            MrcMessage m = this.readMessage();
            if (log.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                if (m != null) {
                    for (int i = 0; i < m.getNumDataElements(); ++i) {
                        buf.append(Integer.toHexString(0xFF & m.getElement(i))).append(" ");
                    }
                } else {
                    buf.append("null message buffer");
                }
                log.debug("Mrc Simulator Thread received message: {}", (Object)buf);
            }
            if (m != null && m.getNumDataElements() > 4) {
                MrcMessage r = new MrcMessage(4);
                r.setElement(0, 85);
                r.setElement(1, 0);
                r.setElement(2, 85);
                r.setElement(3, 0);
                this.writeReply(r);
                if (m.isReplyExpected()) {
                    r = this.generateReply(m);
                    this.writeReply(r);
                }
                if (!log.isDebugEnabled()) continue;
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < r.getNumDataElements(); ++i) {
                    buf.append(Integer.toHexString(0xFF & r.getElement(i))).append(" ");
                }
                log.debug("Mrc Simulator Thread sent reply: {}", (Object)buf);
                continue;
            }
            if (cab > 8) {
                cab = 1;
            }
            int[] poll = new int[]{cab, 1, cab, 0, cab++, 0};
            MrcMessage r = new MrcMessage(poll);
            this.writeReply(r);
        }
    }

    private MrcMessage readMessage() {
        MrcMessage msg = null;
        try {
            if (this.inpipe.available() > 0) {
                msg = this.loadChars();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return msg;
    }

    private MrcMessage loadChars() throws IOException {
        byte[] rcvBuffer = new byte[32];
        int nchars = this.inpipe.read(rcvBuffer, 0, 32);
        MrcMessage msg = new MrcMessage(nchars);
        for (int i = 0; i < nchars; ++i) {
            msg.setElement(i, rcvBuffer[i] & 0xFF);
        }
        return msg;
    }

    private MrcMessage generateReply(MrcMessage m) {
        MrcMessage reply = new MrcMessage(4);
        if (m.getNumDataElements() < 4) {
            reply.setElement(0, 238);
            reply.setElement(1, 0);
            reply.setElement(2, 238);
            reply.setElement(3, 0);
            return reply;
        }
        int command = m.getElement(0);
        if (command != m.getElement(2) && m.getElement(1) != 1) {
            reply.setElement(0, 238);
            reply.setElement(1, 0);
            reply.setElement(2, 238);
            reply.setElement(3, 0);
            return reply;
        }
        switch (command) {
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 50: {
                break;
            }
            case 37: {
                reply.setElement(0, 34);
                reply.setElement(1, 0);
                reply.setElement(2, 34);
                reply.setElement(3, 0);
                break;
            }
            case 68: {
                reply = new MrcMessage(6);
                reply.setElement(0, 3);
                reply.setElement(1, 1);
                reply.setElement(2, 3);
                reply.setElement(3, 0);
                reply.setElement(4, 3);
                reply.setElement(5, 0);
                break;
            }
            default: {
                reply.setElement(0, 85);
                reply.setElement(1, 0);
                reply.setElement(2, 85);
                reply.setElement(3, 0);
            }
        }
        return reply;
    }

    private void writeReply(MrcMessage r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.getNumDataElements(); ++i) {
            try {
                this.outpipe.writeByte((byte)r.getElement(i));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.outpipe.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

