/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceBinaryCommand {
    private static final int BUFFER_SIZE_16 = 16;
    private static final int BUFFER_SIZE_8 = 8;
    private static final int BUFFER_SIZE_4 = 4;
    private static final int BUFFER_SIZE_2 = 2;
    private static final Logger log = LoggerFactory.getLogger(NceBinaryCommand.class);

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Long-standing API, risky to update")
    public static byte[] accDecoder(int number, boolean closed) {
        if (number < 1 || number > 2048) {
            log.error("invalid NCE accessory address {}", (Object)number);
            return null;
        }
        byte op_1 = closed ? (byte)3 : 4;
        int addr_h = number / 256;
        int addr_l = number & 0xFF;
        byte[] retVal = new byte[]{-83, (byte)addr_h, (byte)addr_l, op_1, 0};
        return retVal;
    }

    public static byte[] accMemoryRead(int address) {
        int addr_h = address / 256;
        int addr_l = address & 0xFF;
        byte[] retVal = new byte[]{-113, (byte)addr_h, (byte)addr_l};
        return retVal;
    }

    public static byte[] accMemoryRead1(int address) {
        int addr_h = address / 256;
        int addr_l = address & 0xFF;
        byte[] retVal = new byte[]{-99, (byte)addr_h, (byte)addr_l};
        return retVal;
    }

    public static byte[] accMemoryWriteN(int address, byte[] data) {
        int addr_h = address / 256;
        int addr_l = address & 0xFF;
        byte[] retVal = new byte[20];
        int j = 0;
        retVal[j++] = -114;
        retVal[j++] = (byte)addr_h;
        retVal[j++] = (byte)addr_l;
        retVal[j++] = (byte)data.length;
        int i = 0;
        while (i < data.length) {
            retVal[j] = data[i];
            ++i;
            ++j;
        }
        return retVal;
    }

    public static byte[] accMemoryWrite8(int address, byte[] data) {
        int addr_h = address / 256;
        int addr_l = address & 0xFF;
        byte[] retVal = new byte[11];
        int j = 0;
        retVal[j++] = -102;
        retVal[j++] = (byte)addr_h;
        retVal[j++] = (byte)addr_l;
        int i = 0;
        while (i < data.length) {
            retVal[j] = data[i];
            ++i;
            ++j;
        }
        return retVal;
    }

    public static byte[] accMemoryWrite4(int address, byte[] data) {
        int addr_h = address / 256;
        int addr_l = address & 0xFF;
        byte[] retVal = new byte[7];
        int j = 0;
        retVal[j++] = -103;
        retVal[j++] = (byte)addr_h;
        retVal[j++] = (byte)addr_l;
        int i = 0;
        while (i < data.length) {
            retVal[j] = data[i];
            ++i;
            ++j;
        }
        return retVal;
    }

    public static byte[] accMemoryWrite2(int address, byte[] data) {
        int addr_h = address / 256;
        int addr_l = address & 0xFF;
        byte[] retVal = new byte[5];
        int j = 0;
        retVal[j++] = -104;
        retVal[j++] = (byte)addr_h;
        retVal[j++] = (byte)addr_l;
        int i = 0;
        while (i < data.length) {
            retVal[j] = data[i];
            ++i;
            ++j;
        }
        return retVal;
    }

    public static byte[] accMemoryWrite1(int address, byte data) {
        int addr_h = address / 256;
        int addr_l = address & 0xFF;
        byte[] retVal = new byte[]{-105, (byte)addr_h, (byte)addr_l, data};
        return retVal;
    }

    public static byte[] accAiu2Read(int cabId) {
        byte[] retVal = new byte[]{-101, (byte)cabId};
        return retVal;
    }

    public static byte[] usbSetCabId(int cab) {
        byte[] retVal = new byte[]{-79, (byte)cab};
        return retVal;
    }

    public static byte[] usbMemoryWrite1(byte data) {
        byte[] retVal = new byte[]{-76, data};
        return retVal;
    }

    public static byte[] usbMemoryRead(int num) {
        byte[] retVal = new byte[]{-75, (byte)num};
        return retVal;
    }

    public static byte[] usbMemoryPointer(int cab, int loc) {
        byte[] retVal = new byte[]{-77, (byte)cab, (byte)loc};
        return retVal;
    }

    public static byte[] accStopClock() {
        byte[] retVal = new byte[]{-125};
        return retVal;
    }

    public static byte[] accStartClock() {
        byte[] retVal = new byte[]{-124};
        return retVal;
    }

    public static byte[] accSetClock(int hours, int minutes) {
        byte[] retVal = new byte[]{-123, (byte)hours, (byte)minutes};
        return retVal;
    }

    public static byte[] accSetClock1224(boolean flag) {
        boolean bit = false;
        if (flag) {
            bit = true;
        }
        byte[] retVal = new byte[]{-122, (byte)(bit ? 1 : 0)};
        return retVal;
    }

    public static byte[] accSetClockRatio(int ratio) {
        byte[] retVal = new byte[]{-121, (byte)ratio};
        return retVal;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Long-standing API, risky to update")
    public static byte[] nceLocoCmd(int locoAddr, byte locoSubCmd, byte locoData) {
        if (locoSubCmd > 23) {
            log.error("invalid NCE loco command {}", (Object)locoSubCmd);
            return null;
        }
        int locoAddr_h = locoAddr / 256;
        int locoAddr_l = locoAddr & 0xFF;
        byte[] retVal = new byte[]{-94, (byte)locoAddr_h, (byte)locoAddr_l, locoSubCmd, locoData};
        return retVal;
    }

    public static byte[] getNceEpromRev() {
        byte[] retVal = new byte[]{-86};
        return retVal;
    }

    public static byte[] usbOpsModeLoco(NceTrafficController tc, int locoAddr, int cvAddr, int cvData) {
        byte[] retVal = new byte[6];
        int locoAddr_h = locoAddr / 256;
        int locoAddr_l = locoAddr & 0xFF;
        int cvAddr_h = cvAddr / 256;
        int cvAddr_l = cvAddr & 0xFF;
        retVal[0] = -82;
        retVal[1] = (byte)locoAddr_h;
        retVal[2] = (byte)locoAddr_l;
        retVal[3] = (byte)cvAddr_h;
        retVal[4] = (byte)cvAddr_l;
        retVal[5] = (byte)cvData;
        return retVal;
    }

    public static byte[] usbOpsModeAccy(int accyAddr, int cvAddr, int cvData) {
        byte[] retVal = new byte[6];
        int accyAddr_h = accyAddr / 256;
        int accyAddr_l = accyAddr & 0xFF;
        int cvAddr_h = cvAddr / 256;
        int cvAddr_l = cvAddr & 0xFF;
        retVal[0] = -81;
        retVal[1] = (byte)accyAddr_h;
        retVal[2] = (byte)accyAddr_l;
        retVal[3] = (byte)cvAddr_h;
        retVal[4] = (byte)cvAddr_l;
        retVal[5] = (byte)cvData;
        return retVal;
    }
}

