/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.implementation.DefaultClockControl;
import jmri.jmrix.nce.Bundle;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceClockControl
extends DefaultClockControl
implements NceListener {
    private NceTrafficController tc = null;
    private static final boolean DEBUG_SHOW_PUBLIC_CALLS = true;
    private static final boolean DEBUG_SHOW_SYNC_CALLS = false;
    public static final int CS_CLOCK_MEM_SIZE = 16;
    public static final int CS_CLOCK_SCALE = 0;
    public static final int CS_CLOCK_TICK = 1;
    public static final int CS_CLOCK_SECONDS = 2;
    public static final int CS_CLOCK_MINUTES = 3;
    public static final int CS_CLOCK_HOURS = 4;
    public static final int CS_CLOCK_AMPM = 5;
    public static final int CS_CLOCK_1224 = 6;
    public static final int CS_CLOCK_STATUS = 13;
    public static final int CMD_CLOCK_SET_TIME_SIZE = 3;
    public static final int CMD_CLOCK_SET_PARAM_SIZE = 2;
    public static final int CMD_CLOCK_SET_RUN_SIZE = 1;
    public static final int CMD_CLOCK_SET_REPLY_SIZE = 1;
    public static final int CMD_MEM_SET_REPLY_SIZE = 1;
    public static final int MAX_ERROR_ARRAY = 4;
    public static final double TARGET_SYNC_DELAY = 55.0;
    public static final int SYNCMODE_OFF = 0;
    public static final int SYNCMODE_NCE_MASTER = 1;
    public static final int SYNCMODE_INTERNAL_MASTER = 2;
    public static final int WAIT_CMD_EXECUTION = 1000;
    DecimalFormat fiveDigits = new DecimalFormat("0.00000");
    DecimalFormat fourDigits = new DecimalFormat("0.0000");
    DecimalFormat threeDigits = new DecimalFormat("0.000");
    DecimalFormat twoDigits = new DecimalFormat("0.00");
    private int waiting = 0;
    private final int clockMode = 0;
    private boolean waitingForCmdRead = false;
    private boolean waitingForCmdStop = false;
    private boolean waitingForCmdStart = false;
    private boolean waitingForCmdRatio = false;
    private boolean waitingForCmdTime = false;
    private boolean waitingForCmd1224 = false;
    private NceReply lastClockReadPacket = null;
    private int nceLastHour;
    private int nceLastMinute;
    private int nceLastSecond;
    private int nceLastRatio;
    private boolean nceLastAmPm;
    private boolean nceLast1224;
    private boolean issueDeferredGetTime = false;
    private final int nceSyncInitStateCounter = 0;
    private final int nceSyncRunStateCounter = 0;
    Timebase internalClock;
    Timer alarmSyncUpdate = null;
    PropertyChangeListener minuteChangeListener;
    private static final Logger log = LoggerFactory.getLogger(NceClockControl.class);

    public NceClockControl(NceTrafficController tc, String prefix) {
        this.tc = tc;
        this.internalClock = InstanceManager.getNullableDefault(Timebase.class);
        if (this.internalClock == null) {
            log.error("No Timebase Instance");
            return;
        }
        this.minuteChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                NceClockControl.this.newInternalMinute();
            }
        };
        this.internalClock.addMinuteChangeListener(this.minuteChangeListener);
    }

    @Override
    public void message(NceMessage m) {
        log.error("message received: {}", (Object)m);
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    public void reply(NceReply r) {
        log.trace("NceReply(len {}) waiting: {} watingForRead: {} waitingForCmdTime: {} waitingForCmd1224: {} waitingForCmdRatio: {} waitingForCmdStop: {} waitingForCmdStart: {}", new Object[]{r.getNumDataElements(), this.waiting, this.waitingForCmdRead, this.waitingForCmdTime, this.waitingForCmd1224, this.waitingForCmdRatio, this.waitingForCmdStop, this.waitingForCmdStart});
        if (this.waiting <= 0) {
            log.error("{}", (Object)Bundle.getMessage("LogReplyEnexpected"));
            return;
        }
        --this.waiting;
        if (this.waitingForCmdRead && r.getNumDataElements() == 16) {
            this.readClockPacket(r);
            this.waitingForCmdRead = false;
            return;
        }
        if (this.waitingForCmdTime) {
            if (r.getNumDataElements() != 1) {
                log.error("{}{}", (Object)Bundle.getMessage("LogNceClockReplySizeError"), (Object)r.getNumDataElements());
                return;
            }
            this.waitingForCmdTime = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("NCE set clock replied: {}", (Object)r.getElement(0));
            }
            return;
        }
        if (r.getNumDataElements() != 1) {
            log.error("{}{}", (Object)Bundle.getMessage("LogNceClockReplySizeError"), (Object)r.getNumDataElements());
            return;
        }
        if (this.waitingForCmd1224) {
            this.waitingForCmd1224 = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("{}{}", (Object)Bundle.getMessage("LogNceClock1224CmdError"), (Object)r.getElement(0));
            }
            return;
        }
        if (this.waitingForCmdRatio) {
            this.waitingForCmdRatio = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("{}{}", (Object)Bundle.getMessage("LogNceClockRatioCmdError"), (Object)r.getElement(0));
            }
            return;
        }
        if (this.waitingForCmdStop) {
            this.waitingForCmdStop = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("{}{}", (Object)Bundle.getMessage("LogNceClockStopCmdError"), (Object)r.getElement(0));
            }
            return;
        }
        if (this.waitingForCmdStart) {
            this.waitingForCmdStart = false;
            if (r.getElement(0) != NceMessage.NCE_OKAY) {
                log.error("waitingForCmdStart: {}{}", (Object)Bundle.getMessage("LogNceClockStartCmdError"), (Object)r.getElement(0));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            if (this.waiting > 0) {
                buf.append("waiting: ").append(this.waiting);
            }
            if (this.waitingForCmdRead) {
                buf.append("waitingForCmdRead: ").append(this.waitingForCmdRead);
            }
            if (this.waitingForCmdTime) {
                buf.append("waitingForCmdTime: ").append(this.waitingForCmdTime);
            }
            if (this.waitingForCmd1224) {
                buf.append("waitingForCmd1224: ").append(this.waitingForCmd1224);
            }
            if (this.waitingForCmdRatio) {
                buf.append("waitingForCmdRatio: ").append(this.waitingForCmdRatio);
            }
            if (this.waitingForCmdStop) {
                buf.append("waitingForCmdStop: ").append(this.waitingForCmdStop);
            }
            if (this.waitingForCmdStart) {
                buf.append("waitingForCmdStart: ").append(this.waitingForCmdStart);
            }
            log.debug("NceReply(len {}) {}", (Object)r.getNumDataElements(), (Object)buf);
            buf = new StringBuffer();
            for (int i = 0; i < r.getNumDataElements(); ++i) {
                buf.append(" ").append(r.getElement(i));
            }
            log.debug("{}:{}", (Object)Bundle.getMessage("LogReplyUnexpected"), (Object)buf);
        }
    }

    @Override
    public String getHardwareClockName() {
        log.debug("getHardwareClockName");
        return "Nce Fast Clock";
    }

    @Override
    public boolean canCorrectHardwareClock() {
        log.debug("getHardwareClockName");
        return false;
    }

    @Override
    public boolean canSet12Or24HourClock() {
        log.debug("canSet12Or24HourClock");
        return true;
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="I18N of log message")
    public void setRate(double newRate) {
        log.debug("setRate: {}", (Object)newRate);
        int newRatio = (int)newRate;
        if (newRatio < 1 || newRatio > 15) {
            log.error("{}", (Object)Bundle.getMessage("LogNceClockRatioRangeError"));
        } else {
            this.issueClockRatio(newRatio);
        }
    }

    @Override
    public boolean requiresIntegerRate() {
        log.debug("requiresIntegerRate");
        return true;
    }

    @Override
    public double getRate() {
        this.issueReadOnlyRequest();
        log.debug("getRate: {}", (Object)this.nceLastRatio);
        return this.nceLastRatio;
    }

    @Override
    public void setTime(Date now) {
        log.debug("setTime: {}", (Object)now);
        this.issueClockSet(now.getHours(), now.getMinutes(), now.getSeconds());
    }

    @Override
    public Date getTime() {
        this.issueReadOnlyRequest();
        this.issueDeferredGetTime = true;
        Date now = this.internalClock.getTime();
        if (this.lastClockReadPacket != null) {
            if (this.nceLast1224) {
                now.setHours(this.nceLastHour);
            } else if (this.nceLastAmPm) {
                now.setHours(this.nceLastHour);
            } else {
                now.setHours(this.nceLastHour + 12);
            }
            now.setMinutes(this.nceLastMinute);
            now.setSeconds(this.nceLastSecond);
        }
        log.debug("getTime returning: {}", (Object)now);
        return now;
    }

    @Override
    public void startHardwareClock(Date now) {
        log.debug("startHardwareClock: {}", (Object)now);
        this.issueClockSet(now.getHours(), now.getMinutes(), now.getSeconds());
        this.issueClockStart();
    }

    @Override
    public void stopHardwareClock() {
        log.debug("stopHardwareClock");
        this.issueClockStop();
    }

    public void initiateRead() {
        log.debug("initiateRead");
        this.issueReadOnlyRequest();
    }

    public void dispose() {
        if (this.minuteChangeListener != null) {
            this.internalClock.removeMinuteChangeListener(this.minuteChangeListener);
            this.minuteChangeListener = null;
        }
    }

    public void newInternalMinute() {
    }

    private void readClockPacket(NceReply r) {
        int sc;
        this.lastClockReadPacket = r;
        this.nceLastHour = r.getElement(4) & 0xFF;
        this.nceLastMinute = r.getElement(3) & 0xFF;
        this.nceLastSecond = r.getElement(2) & 0xFF;
        this.nceLast1224 = r.getElement(6) == 1;
        this.nceLastAmPm = r.getElement(5) == 65;
        if (this.issueDeferredGetTime) {
            this.issueDeferredGetTime = false;
            Date now = this.internalClock.getTime();
            if (this.nceLast1224) {
                now.setHours(this.nceLastHour);
            } else if (this.nceLastAmPm) {
                now.setHours(this.nceLastHour);
            } else {
                now.setHours(this.nceLastHour + 12);
            }
            now.setMinutes(this.nceLastMinute);
            now.setSeconds(this.nceLastSecond);
            this.internalClock.userSetTime(now);
        }
        if ((sc = r.getElement(0) & 0xFF) > 0) {
            this.nceLastRatio = 250 / sc;
        }
    }

    private void issueClockRatio(int r) {
        log.debug("sending ratio {} to nce cmd station", (Object)r);
        byte[] cmd = NceBinaryCommand.accSetClockRatio(r);
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdRatio = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private void issueClock1224(boolean mode) {
        byte[] cmd = NceBinaryCommand.accSetClock1224(mode);
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmd1224 = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    private void issueClockStop() {
        byte[] cmd = NceBinaryCommand.accStopClock();
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdStop = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    private void issueClockStart() {
        byte[] cmd = NceBinaryCommand.accStartClock();
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdStart = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    private void issueReadOnlyRequest() {
        if (!this.waitingForCmdRead) {
            byte[] cmd = NceBinaryCommand.accMemoryRead(this.tc.csm.getClockAddr());
            NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 16);
            ++this.waiting;
            this.waitingForCmdRead = true;
            this.tc.sendNceMessage(cmdNce, this);
        }
    }

    private void issueClockSet(int hh, int mm, int ss) {
        this.issueClockSetMem(hh, mm, ss);
    }

    private void issueClockSetMem(int hh, int mm, int ss) {
        byte[] b = new byte[]{(byte)ss, (byte)mm, (byte)hh};
        byte[] cmd = NceBinaryCommand.accMemoryWriteN(this.tc.csm.getClockAddr() + 2, b);
        NceMessage cmdNce = NceMessage.createBinaryMessage(this.tc, cmd, 1);
        ++this.waiting;
        this.waitingForCmdTime = true;
        this.tc.sendNceMessage(cmdNce, this);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private Date getNceDate() {
        Date now = this.internalClock.getTime();
        if (this.lastClockReadPacket != null) {
            now.setHours(this.lastClockReadPacket.getElement(4));
            now.setMinutes(this.lastClockReadPacket.getElement(3));
            now.setSeconds(this.lastClockReadPacket.getElement(2));
        }
        return now;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private double getNceTime() {
        double nceTime = 0.0;
        if (this.lastClockReadPacket != null) {
            nceTime = (double)(this.lastClockReadPacket.getElement(4) * 3600 + this.lastClockReadPacket.getElement(3) * 60 + this.lastClockReadPacket.getElement(2)) + (double)this.lastClockReadPacket.getElement(1) * 0.25;
        }
        return nceTime;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private double getIntTime() {
        Date now = this.internalClock.getTime();
        int ms = (int)(now.getTime() % 1000L);
        int ss = now.getSeconds();
        int mm = now.getMinutes();
        int hh = now.getHours();
        log.trace("getIntTime: {}:{}:{}.{}", new Object[]{hh, mm, ss, ms});
        return hh * 60 * 60 + mm * 60 + ss + ms / 1000;
    }
}

