/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import jmri.DccLocoAddress;
import jmri.implementation.DccConsist;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsist
extends DccConsist
implements NceListener {
    public static final int CONSIST_MIN = 1;
    public static final int CONSIST_MAX = 127;
    private NceTrafficController tc = null;
    private boolean _valid = false;
    private int _busy = 0;
    private int _replyLen = 0;
    private static final int REPLY_1 = 1;
    private byte _consistNum = 0;
    private NceReadConsist mb = null;
    private static final Logger log = LoggerFactory.getLogger(NceConsist.class);

    public NceConsist(int address, NceSystemConnectionMemo m) {
        super(address);
        this.tc = m.getNceTrafficController();
        this.loadConsist(address);
    }

    public NceConsist(DccLocoAddress locoAddress, NceSystemConnectionMemo m) {
        super(locoAddress);
        this.tc = m.getNceTrafficController();
        this.loadConsist(locoAddress.getNumber());
    }

    @Override
    public void dispose() {
        if (this.consistList == null) {
            return;
        }
        if (!this.consistList.isEmpty()) {
            DccLocoAddress locoAddress = (DccLocoAddress)this.consistList.get(0);
            this.killConsist(locoAddress.getNumber(), locoAddress.isLongAddress());
        }
        this.stopReadNCEconsistThread();
        super.dispose();
        this.consistList = null;
    }

    @Override
    public void setConsistType(int consist_type) {
        if (consist_type == 0) {
            this.consistType = consist_type;
        } else {
            log.error("Consist Type Not Supported");
            this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
        }
    }

    @Override
    public int sizeLimit() {
        return 6;
    }

    @Override
    public synchronized void add(DccLocoAddress locoAddress, boolean directionNormal) {
        if (!this.contains(locoAddress)) {
            if (this.consistList.isEmpty()) {
                byte command = 11;
                if (!directionNormal) {
                    command = 10;
                }
                this.addLocoToConsist(locoAddress.getNumber(), locoAddress.isLongAddress(), command);
                this.consistPosition.put(locoAddress, 0);
            } else if (this.consistList.size() == 1) {
                byte command = 13;
                if (!directionNormal) {
                    command = 12;
                }
                this.addLocoToConsist(locoAddress.getNumber(), locoAddress.isLongAddress(), command);
                this.consistPosition.put(locoAddress, 255);
            } else {
                byte command = 15;
                if (!directionNormal) {
                    command = 14;
                }
                this.addLocoToConsist(locoAddress.getNumber(), locoAddress.isLongAddress(), command);
                this.consistPosition.put(locoAddress, this.consistPosition.size());
            }
            this.consistList.add(locoAddress);
            this.consistDir.put(locoAddress, directionNormal);
        } else {
            log.error("Loco {} is already part of this consist {}", (Object)locoAddress, (Object)this.getConsistAddress());
        }
    }

    public void restore(DccLocoAddress locoAddress, boolean directionNormal, int position) {
        this.consistPosition.put(locoAddress, position);
        super.restore(locoAddress, directionNormal);
    }

    @Override
    public synchronized void remove(DccLocoAddress locoAddress) {
        if (this.contains(locoAddress)) {
            int position = this.getPosition(locoAddress);
            if (position == 0 || position == 255) {
                log.info("Can not delete lead or rear loco from a NCE consist!");
                this.notifyConsistListeners(locoAddress, 512);
                return;
            }
            this.removeLocoFromConsist(locoAddress.getNumber(), locoAddress.isLongAddress());
            this.resetRosterEntryCVValue(locoAddress);
            this.consistRoster.remove(locoAddress);
            this.consistPosition.remove(locoAddress);
            this.consistDir.remove(locoAddress);
            this.consistList.remove(locoAddress);
            this.notifyConsistListeners(locoAddress, 2);
        } else {
            log.error("Loco {} is not part of this consist {}", (Object)locoAddress, (Object)this.getConsistAddress());
        }
    }

    private void loadConsist(int consistNum) {
        if (consistNum > 127 || consistNum < 1) {
            log.error("Requesting consist {} out of range", (Object)consistNum);
            return;
        }
        this._consistNum = (byte)consistNum;
        this.startReadNCEconsistThread(false);
    }

    public void checkConsist() {
        if (!this.isValid()) {
            return;
        }
        this.setValid(false);
        this.startReadNCEconsistThread(true);
    }

    private synchronized void startReadNCEconsistThread(boolean check) {
        if (this.tc.getUsbSystem() == 0) {
            this.mb = new NceReadConsist();
            this.mb.setName("Read Consist " + this._consistNum);
            this.mb.setConsist(this._consistNum);
            this.mb.setCheck(check);
            this.mb.start();
        }
    }

    private synchronized void stopReadNCEconsistThread() {
        if (this.mb != null) {
            try {
                this.mb.interrupt();
                this.mb.join();
            }
            catch (InterruptedException ex) {
                log.warn("stopReadNCEconsistThread interrupted");
            }
            catch (Throwable t) {
                log.error("stopReadNCEconsistThread caught ", t);
                throw t;
            }
            finally {
                this.mb = null;
            }
        }
    }

    public DccLocoAddress getLocoAddressByPosition(int position) {
        ArrayList<DccLocoAddress> list = this.getConsistList();
        for (int i = 0; i < list.size(); ++i) {
            DccLocoAddress locoAddress = list.get(i);
            if (this.getPosition(locoAddress) != position) continue;
            return locoAddress;
        }
        return null;
    }

    public boolean isValid() {
        return this._valid;
    }

    private void setValid(boolean valid) {
        this._valid = valid;
    }

    private void addLocoToConsist(int address, boolean isLong, byte command) {
        if (isLong) {
            address += 49152;
        }
        this.sendNceBinaryCommand(address, command, this._consistNum);
    }

    private void removeLocoFromConsist(int address, boolean isLong) {
        if (isLong) {
            address += 49152;
        }
        this.sendNceBinaryCommand(address, (byte)16, (byte)0);
    }

    void killConsist(int address, boolean isLong) {
        if (isLong) {
            address += 49152;
        }
        this.sendNceBinaryCommand(address, (byte)17, (byte)0);
    }

    private void sendNceBinaryCommand(int nceAddress, byte nceLocoCmd, byte consistNumber) {
        byte[] bl = NceBinaryCommand.nceLocoCmd(nceAddress, nceLocoCmd, consistNumber);
        this.sendNceMessage(bl, 1);
    }

    private void sendNceMessage(byte[] b, int replyLength) {
        NceMessage m = NceMessage.createBinaryMessage(this.tc, b, replyLength);
        ++this._busy;
        this._replyLen = replyLength;
        this.tc.sendNceMessage(m, this);
    }

    @Override
    public void message(NceMessage m) {
    }

    @Override
    public void reply(NceReply r) {
        if (this._busy == 0) {
            log.debug("Consist {} read reply not for this consist", (Object)this._consistNum);
            return;
        }
        if (r.getNumDataElements() != this._replyLen) {
            log.error("reply length error, expecting: {} got: {}", (Object)this._replyLen, (Object)r.getNumDataElements());
            return;
        }
        if (this._replyLen == 1 && r.getElement(0) == NceMessage.NCE_OKAY) {
            log.debug("Command complete okay for consist {}", (Object)this.getConsistAddress());
        } else {
            log.error("Error, command failed for consist {}", (Object)this.getConsistAddress());
        }
    }

    public class NceReadConsist
    extends Thread
    implements NceListener {
        private int _consistNum = 0;
        private int _busy = 0;
        private boolean _validConsist = false;
        private boolean _check = false;
        private int _replyLen = 0;
        private static final int REPLY_16 = 16;
        private int _locoNum = 0;
        private static final int LEAD = 0;
        private static final int REAR = 1;
        private static final int MID = 2;

        public void setConsist(int number) {
            this._consistNum = number;
        }

        public void setCheck(boolean check) {
            this._check = check;
        }

        @Override
        public void run() {
            try {
                this.readConsistMemory(this._consistNum, 0);
                this.readConsistMemory(this._consistNum, 1);
                this.readConsistMemory(this._consistNum, 2);
                NceConsist.this.setValid(true);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable t) {
                throw t;
            }
        }

        private void readConsistMemory(int consistNum, int eNum) throws InterruptedException {
            if (consistNum > 127 || consistNum < 1) {
                log.error("Requesting consist {} out of range", (Object)consistNum);
                return;
            }
            if (!this.readWait()) {
                log.error("Time out reading NCE command station consist memory");
                return;
            }
            this._locoNum = eNum;
            int nceMemAddr = consistNum * 2 + NceConsist.this.tc.csm.getConsistHeadAddr();
            if (eNum == 1) {
                nceMemAddr = consistNum * 2 + NceConsist.this.tc.csm.getConsistTailAddr();
            }
            if (eNum == 2) {
                nceMemAddr = consistNum * 8 + NceConsist.this.tc.csm.getConsistMidAddr();
            }
            if (eNum == 0 || this._validConsist) {
                byte[] bl = NceBinaryCommand.accMemoryRead(nceMemAddr);
                this.sendNceMessage(bl, 16);
            }
        }

        private void sendNceMessage(byte[] b, int replyLength) {
            NceMessage m = NceMessage.createBinaryMessage(NceConsist.this.tc, b, replyLength);
            ++this._busy;
            this._replyLen = replyLength;
            NceConsist.this.tc.sendNceMessage(m, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readWait() throws InterruptedException {
            int waitcount = 30;
            while (this._busy > 0) {
                NceReadConsist nceReadConsist = this;
                synchronized (nceReadConsist) {
                    this.wait(1000L);
                }
                if (waitcount-- >= 0) continue;
                log.error("read timeout");
                return false;
            }
            return true;
        }

        @Override
        public void message(NceMessage m) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
        public void reply(NceReply r) {
            int index;
            if (this._busy == 0) {
                log.debug("Consist {} read reply not for this consist", (Object)this._consistNum);
                return;
            }
            log.debug("Consist {} read reply number {}", (Object)this._consistNum, (Object)this._locoNum);
            if (r.getNumDataElements() != this._replyLen) {
                log.error("reply length error, expecting: {} got: {}", (Object)this._replyLen, (Object)r.getNumDataElements());
                return;
            }
            if (this._check) {
                log.debug("Checking {}", (Object)this._consistNum);
                if (this._locoNum == 0) {
                    this._validConsist = this.checkLocoConsist(r, 0, 0);
                }
                if (this._validConsist && this._locoNum == 1) {
                    this._validConsist = this.checkLocoConsist(r, 0, 255);
                }
                if (this._validConsist && this._locoNum == 2) {
                    for (index = 0; index < 8; index += 2) {
                        this.checkLocoConsist(r, index, NceConsist.this.consistPosition.size());
                    }
                }
            } else {
                if (this._locoNum == 0) {
                    this._validConsist = this.addLocoConsist(r, 0, 0);
                }
                if (this._validConsist && this._locoNum == 1) {
                    this._validConsist = this.addLocoConsist(r, 0, 255);
                }
                if (this._validConsist && this._locoNum == 2) {
                    for (index = 0; index < 8; index += 2) {
                        this.addLocoConsist(r, index, NceConsist.this.consistPosition.size());
                    }
                }
            }
            --this._busy;
            NceReadConsist nceReadConsist = this;
            synchronized (nceReadConsist) {
                this.notify();
            }
        }

        private boolean addLocoConsist(NceReply r, int index, int position) {
            int address = this.getLocoAddrText(r, index);
            boolean isLong = this.getLocoAddressType(r, index);
            if (address != 0) {
                log.debug("Add loco address {} to consist {}", (Object)address, (Object)this._consistNum);
                NceConsist.this.restore(new DccLocoAddress(address, isLong), true, position);
                return true;
            }
            return false;
        }

        private boolean checkLocoConsist(NceReply r, int index, int position) {
            boolean isLong;
            int address = this.getLocoAddrText(r, index);
            DccLocoAddress locoAddress = new DccLocoAddress(address, isLong = this.getLocoAddressType(r, index));
            if (NceConsist.this.contains(locoAddress)) {
                log.debug("Loco address {} found match for consist {}", (Object)locoAddress, (Object)this._consistNum);
            } else if (address != 0) {
                log.debug("New loco address {} found for consist {}", (Object)locoAddress, (Object)this._consistNum);
                NceConsist.this.restore(locoAddress, true, position);
            } else {
                log.debug("Found loco address 0 for consist {} index {} position {}", new Object[]{this._consistNum, index, position});
                locoAddress = NceConsist.this.getLocoAddressByPosition(position);
                if (locoAddress != null) {
                    NceConsist.this.remove(locoAddress);
                }
            }
            return true;
        }

        private int getLocoAddrText(NceReply r, int index) {
            int rC = r.getElement(index++);
            rC = rC << 8 & 0x3F00;
            int rC_l = r.getElement(index);
            return rC += (rC_l &= 0xFF);
        }

        private boolean getLocoAddressType(NceReply r, int index) {
            int rC = r.getElement(index);
            return (rC &= 0xC0) == 192;
        }
    }
}

