/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.jmrix.ConnectionStatus;
import jmri.jmrix.JmrixConfigPane;
import jmri.jmrix.nce.NceConsist;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistManager
extends AbstractConsistManager {
    private NceSystemConnectionMemo memo = null;
    private static final Logger log = LoggerFactory.getLogger(NceConsistManager.class);

    public NceConsistManager(NceSystemConnectionMemo m) {
        this.memo = m;
    }

    @Override
    public void requestUpdateFromLayout() {
        if (this.shouldRequestUpdateFromLayout()) {
            this.startConsistReader();
        }
    }

    @Override
    public boolean isCommandStationConsistPossible() {
        return false;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return false;
    }

    @Override
    public Consist addConsist(LocoAddress locoAddress) {
        if (!(locoAddress instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("locoAddress is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(locoAddress)) {
            return (Consist)this.consistTable.get(locoAddress);
        }
        log.debug("Add consist, address {}", (Object)locoAddress);
        NceConsist consist = new NceConsist((DccLocoAddress)locoAddress, this.memo);
        this.consistTable.put(locoAddress, consist);
        this.notifyConsistListChanged();
        return consist;
    }

    private void addConsist(NceConsist consist) {
        log.debug("Add consist {}", (Object)consist.getConsistAddress());
        this.consistTable.put(consist.getConsistAddress(), consist);
        this.notifyConsistListChanged();
    }

    @Override
    public Consist getConsist(LocoAddress locoAddress) {
        log.debug("Requesting NCE consist {}", (Object)locoAddress);
        NceConsist consist = (NceConsist)super.getConsist(locoAddress);
        return consist;
    }

    @Override
    public void delConsist(LocoAddress locoAddress) {
        NceConsist consist = (NceConsist)this.getConsist(locoAddress);
        consist.dispose();
        super.delConsist(locoAddress);
    }

    public void startConsistReader() {
        if (this.memo.getNceUsbSystem() == 0 && !this.memo.getNceTrafficController().getPortName().equals(JmrixConfigPane.NONE_SELECTED) && this.memo.getNceTrafficController().getCommandOptions() > 0) {
            new NceConsistReader().start();
        }
    }

    public class NceConsistReader
    extends Thread {
        int _consistNum = 127;

        NceConsistReader() {
            this.setName("Initialize NCE consists");
        }

        @Override
        public void run() {
            this.searchNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void searchNext() {
            NceConsistReader nceConsistReader = this;
            synchronized (nceConsistReader) {
                while (!ConnectionStatus.instance().getConnectionState(NceConsistManager.this.memo.getUserName(), NceConsistManager.this.memo.getNceTrafficController().getPortName()).equals("Connected")) {
                    log.debug("Waiting for NCE connected");
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            while (this._consistNum >= 1) {
                if (log.isDebugEnabled()) {
                    log.debug("Reading consist from command station: {}", (Object)this._consistNum);
                }
                NceConsist consist = new NceConsist(this._consistNum, NceConsistManager.this.memo);
                while (!consist.isValid()) {
                    NceConsistReader nceConsistReader2 = this;
                    synchronized (nceConsistReader2) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (consist.getConsistList().size() > 0) {
                    NceConsistManager.this.addConsist(consist);
                }
                --this._consistNum;
            }
            NceConsistManager.this.notifyConsistListChanged();
        }
    }
}

