/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Light;
import jmri.Manager;
import jmri.jmrix.nce.Bundle;
import jmri.jmrix.nce.NceLight;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.managers.AbstractLightManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceLightManager
extends AbstractLightManager {
    private static final Logger log = LoggerFactory.getLogger(NceLightManager.class);

    public NceLightManager(NceSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public NceSystemConnectionMemo getMemo() {
        return (NceSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Light createNewLight(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int bitNum = this.getBitFromSystemName(systemName);
        if (bitNum == 0) {
            throw new IllegalArgumentException("Invalid Bit from System Name: " + systemName);
        }
        String sName = this.getSystemPrefix() + "L" + bitNum;
        NceLight lgt = new NceLight(sName, userName, this.getMemo().getNceTrafficController(), this);
        return lgt;
    }

    public int getBitFromSystemName(String systemName) {
        if (!systemName.startsWith(this.getSystemPrefix()) || !systemName.startsWith(this.getSystemPrefix() + "L")) {
            log.error("illegal character in header field of nce light system name: {}", (Object)systemName);
            return 0;
        }
        int num = 0;
        try {
            num = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1, systemName.length()));
        }
        catch (NumberFormatException e) {
            log.debug("illegal character in number field of system name: {}", (Object)systemName);
            return 0;
        }
        if (num < 1) {
            log.error("invalid nce light system name: {}", (Object)systemName);
            return 0;
        }
        if (num > 2044) {
            log.warn("bit number out of range in nce light system name: {}", (Object)systemName);
            return 0;
        }
        return num;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        return super.validateNmraAccessorySystemNameFormat(name, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return this.getBitFromSystemName(systemName) != 0 ? Manager.NameValidity.VALID : Manager.NameValidity.INVALID;
    }

    @Override
    public boolean validSystemNameConfig(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

