/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.ncemon.NceMonBinary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMessage
extends AbstractMRMessage {
    private static final Logger log = LoggerFactory.getLogger(NceMessage.class);
    private static final NceMonBinary nceMon = new NceMonBinary();
    public static final int NOP_CMD = 128;
    public static final int ASSIGN_CAB_CMD = 129;
    public static final int READ_CLOCK_CMD = 130;
    public static final int STOP_CLOCK_CMD = 131;
    public static final int START_CLOCK_CMD = 132;
    public static final int SET_CLOCK_CMD = 133;
    public static final int CLOCK_1224_CMD = 134;
    public static final int CLOCK_RATIO_CMD = 135;
    public static final int DEQUEUE_CMD = 136;
    public static final int READ_AUI4_CMD = 138;
    public static final int DUMMY_CMD = 140;
    public static final int SPEED_MODE_CMD = 141;
    public static final int WRITE_N_CMD = 142;
    public static final int READ16_CMD = 143;
    public static final int DISPLAY3_CMD = 144;
    public static final int DISPLAY4_CMD = 145;
    public static final int DISPLAY2_CMD = 146;
    public static final int QUEUE3_TMP_CMD = 147;
    public static final int QUEUE4_TMP_CMD = 148;
    public static final int QUEUE5_TMP_CMD = 149;
    public static final int QUEUE6_TMP_CMD = 150;
    public static final int WRITE1_CMD = 151;
    public static final int WRITE2_CMD = 152;
    public static final int WRITE4_CMD = 153;
    public static final int WRITE8_CMD = 154;
    public static final int READ_AUI2_CMD = 155;
    public static final int MACRO_CMD = 156;
    public static final int READ1_CMD = 157;
    public static final int ENTER_PROG_CMD = 158;
    public static final int EXIT_PROG_CMD = 159;
    public static final int WRITE_PAGED_CV_CMD = 160;
    public static final int READ_PAGED_CV_CMD = 161;
    public static final int LOCO_CMD = 162;
    public static final int QUEUE3_TRK_CMD = 163;
    public static final int QUEUE4_TRK_CMD = 164;
    public static final int QUEUE5_TRK_CMD = 165;
    public static final int WRITE_REG_CMD = 166;
    public static final int READ_REG_CMD = 167;
    public static final int WRITE_DIR_CV_CMD = 168;
    public static final int READ_DIR_CV_CMD = 169;
    public static final int SW_REV_CMD = 170;
    public static final int RESET_SOFT_CMD = 171;
    public static final int RESET_HARD_CMD = 172;
    public static final int SEND_ACC_SIG_MACRO_CMD = 173;
    public static final int OPS_PROG_LOCO_CMD = 174;
    public static final int OPS_PROG_ACCY_CMD = 175;
    public static final int FACTORY_TEST_CMD = 176;
    public static final int USB_SET_CAB_CMD = 177;
    public static final int USB_MEM_POINTER_CMD = 179;
    public static final int USB_MEM_WRITE_CMD = 180;
    public static final int USB_MEM_READ_CMD = 181;
    public static final byte LOCO_CMD_SELECT_LOCO = 0;
    public static final byte LOCO_CMD_REV_28SPEED = 1;
    public static final byte LOCO_CMD_FWD_28SPEED = 2;
    public static final byte LOCO_CMD_REV_128SPEED = 3;
    public static final byte LOCO_CMD_FWD_128SPEED = 4;
    public static final byte LOCO_CMD_REV_ESTOP = 5;
    public static final byte LOCO_CMD_FWD_ESTOP = 6;
    public static final byte LOCO_CMD_FG1 = 7;
    public static final byte LOCO_CMD_FG2 = 8;
    public static final byte LOCO_CMD_FG3 = 9;
    public static final byte LOCO_CMD_FG4 = 21;
    public static final byte LOCO_CMD_FG5 = 22;
    public static final byte LOCO_CMD_REV_CONSIST_LEAD = 10;
    public static final byte LOCO_CMD_FWD_CONSIST_LEAD = 11;
    public static final byte LOCO_CMD_REV_CONSIST_REAR = 12;
    public static final byte LOCO_CMD_FWD_CONSIST_REAR = 13;
    public static final byte LOCO_CMD_REV_CONSIST_MID = 14;
    public static final byte LOCO_CMD_FWD_CONSIST_MID = 15;
    public static final byte LOCO_CMD_DELETE_LOCO_CONSIST = 16;
    public static final byte LOCO_CMD_KILL_CONSIST = 17;
    public static final int ENABLE_MAIN_CMD = 137;
    public static final int KILL_MAIN_CMD = 139;
    public static final int SENDn_BYTES_CMD = 144;
    public static final int QUEUEn_BYTES_CMD = 160;
    protected static final int NCE_PAGED_CV_TIMEOUT = 20000;
    protected static final int NCE_DIRECT_CV_TIMEOUT = 10000;
    protected static final int SHORT_TIMEOUT = 10000;
    public static final int REPLY_1 = 1;
    public static final int REPLY_2 = 2;
    public static final int REPLY_3 = 3;
    public static final int REPLY_4 = 4;
    public static final int REPLY_16 = 16;
    public static char NCE_OKAY = (char)33;
    int replyLen = 1;

    public NceMessage() {
    }

    public NceMessage(int i) {
        super(i);
    }

    public NceMessage(@Nonnull NceMessage m) {
        super(m);
        this.replyLen = m.replyLen;
    }

    public NceMessage(@Nonnull String m) {
        super(m);
    }

    public void setReplyLen(int len) {
        this.replyLen = len;
    }

    public int getReplyLen() {
        return this.replyLen;
    }

    public boolean isKillMain() {
        if (this.isBinary()) {
            return this.getOpCode() == 139;
        }
        return this.getOpCode() == 75;
    }

    public boolean isEnableMain() {
        if (this.isBinary()) {
            return this.getOpCode() == 137;
        }
        return this.getOpCode() == 69;
    }

    public static NceMessage getEnableMain(NceTrafficController tc) {
        if (tc.getUsbSystem() != 0) {
            log.error("attempt to send unsupported binary command ENABLE_MAIN_CMD to NCE USB");
            return null;
        }
        NceMessage m = new NceMessage(1);
        if (tc.getCommandOptions() >= 0) {
            m.setBinary(true);
            m.setReplyLen(1);
            m.setOpCode(137);
        } else {
            m.setBinary(false);
            m.setOpCode(69);
        }
        return m;
    }

    public static NceMessage getKillMain(NceTrafficController tc) {
        if (tc.getUsbSystem() != 0) {
            log.error("attempt to send unsupported binary command KILL_MAIN_CMD to NCE USB");
            return null;
        }
        NceMessage m = new NceMessage(1);
        if (tc.getCommandOptions() >= 0) {
            m.setBinary(true);
            m.setReplyLen(1);
            m.setOpCode(139);
        } else {
            m.setBinary(false);
            m.setOpCode(75);
        }
        return m;
    }

    @Nonnull
    public static NceMessage getProgMode(@Nonnull NceTrafficController tc) {
        if (tc.getUsbSystem() != 0 && (tc.getCmdGroups() & 2L) != 2L) {
            log.error("attempt to send unsupported binary command ENTER_PROG_CMD to NCE USB");
        }
        NceMessage m = new NceMessage(1);
        if (tc.getCommandOptions() >= 20) {
            tc.setNceProgMode(true);
            m.setBinary(true);
            m.setReplyLen(1);
            m.setOpCode(158);
            m.setTimeout(10000);
        } else {
            m.setBinary(false);
            m.setOpCode(77);
            m.setTimeout(10000);
        }
        return m;
    }

    @CheckForNull
    public static NceMessage getExitProgMode(@Nonnull NceTrafficController tc) {
        NceMessage m = new NceMessage(1);
        if (tc.getCommandOptions() >= 20) {
            if (!tc.getNceProgMode()) {
                return null;
            }
            if (tc.getUsbSystem() == 2 || tc.getUsbSystem() == 5 || tc.getUsbSystem() == 3) {
                log.error("attempt to send unsupported binary command EXIT_PROG_CMD to NCE USB");
            }
            tc.setNceProgMode(false);
            m.setBinary(true);
            m.setReplyLen(1);
            m.setOpCode(159);
            m.setTimeout(10000);
        } else {
            m.setBinary(false);
            m.setOpCode(88);
            m.setTimeout(10000);
        }
        return m;
    }

    @Nonnull
    public static NceMessage getReadPagedCV(@Nonnull NceTrafficController tc, int cv) {
        if (tc.getUsbSystem() != 0 && (tc.getCmdGroups() & 2L) != 2L) {
            log.error("attempt to send unsupported binary command READ_PAGED_CV_CMD to NCE USB");
        }
        if (tc.getCommandOptions() >= 20) {
            NceMessage m = new NceMessage(3);
            m.setBinary(true);
            m.setReplyLen(2);
            m.setOpCode(161);
            m.setElement(1, cv >> 8);
            m.setElement(2, cv & 0xFF);
            m.setNeededMode(4);
            m.setTimeout(20000);
            return m;
        }
        NceMessage m = new NceMessage(4);
        m.setBinary(false);
        m.setOpCode(82);
        m.addIntAsThree(cv, 1);
        m.setNeededMode(4);
        m.setTimeout(20000);
        return m;
    }

    @Nonnull
    public static NceMessage getWritePagedCV(@Nonnull NceTrafficController tc, int cv, int val) {
        if (tc.getUsbSystem() != 0 && (tc.getCmdGroups() & 2L) != 2L) {
            log.error("attempt to send unsupported binary command WRITE_PAGED_CV_CMD to NCE USB");
        }
        if (tc.getCommandOptions() >= 20) {
            NceMessage m = new NceMessage(4);
            m.setBinary(true);
            m.setReplyLen(1);
            m.setOpCode(160);
            m.setElement(1, cv >> 8);
            m.setElement(2, cv & 0xFF);
            m.setElement(3, val);
            m.setNeededMode(4);
            m.setTimeout(20000);
            return m;
        }
        NceMessage m = new NceMessage(8);
        m.setBinary(false);
        m.setOpCode(80);
        m.addIntAsThree(cv, 1);
        m.setElement(4, 32);
        m.addIntAsThree(val, 5);
        m.setNeededMode(4);
        m.setTimeout(20000);
        return m;
    }

    @CheckForNull
    public static NceMessage getReadRegister(@Nonnull NceTrafficController tc, int reg) {
        if (tc.getUsbSystem() == 2 || tc.getUsbSystem() == 5 || tc.getUsbSystem() == 3) {
            log.error("attempt to send unsupported binary command READ_REG_CMD to NCE USB");
            return null;
        }
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        if (tc.getCommandOptions() >= 20) {
            NceMessage m = new NceMessage(2);
            m.setBinary(true);
            m.setReplyLen(2);
            m.setOpCode(167);
            m.setElement(1, reg);
            m.setNeededMode(4);
            m.setTimeout(20000);
            return m;
        }
        NceMessage m = new NceMessage(2);
        m.setBinary(false);
        m.setOpCode(86);
        String s = "" + reg;
        m.setElement(1, s.charAt(s.length() - 1));
        m.setNeededMode(4);
        m.setTimeout(20000);
        return m;
    }

    public static NceMessage getWriteRegister(NceTrafficController tc, int reg, int val) {
        if (tc.getUsbSystem() == 2 || tc.getUsbSystem() == 5 || tc.getUsbSystem() == 3) {
            log.error("attempt to send unsupported binary command WRITE_REG_CMD to NCE USB");
            return null;
        }
        if (reg > 8) {
            log.error("register number too large: {}", (Object)reg);
        }
        if (tc.getCommandOptions() >= 20) {
            NceMessage m = new NceMessage(3);
            m.setBinary(true);
            m.setReplyLen(1);
            m.setOpCode(166);
            m.setElement(1, reg);
            m.setElement(2, val);
            m.setNeededMode(4);
            m.setTimeout(20000);
            return m;
        }
        NceMessage m = new NceMessage(6);
        m.setBinary(false);
        m.setOpCode(83);
        String s = "" + reg;
        m.setElement(1, s.charAt(s.length() - 1));
        m.setElement(2, 32);
        m.addIntAsThree(val, 3);
        m.setNeededMode(4);
        m.setTimeout(20000);
        return m;
    }

    public static NceMessage getReadDirectCV(NceTrafficController tc, int cv) {
        if (tc.getUsbSystem() == 2 || tc.getUsbSystem() == 5 || tc.getUsbSystem() == 3) {
            log.error("attempt to send unsupported binary command READ_DIR_CV_CMD to NCE USB");
            return null;
        }
        if (tc.getCommandOptions() < 20) {
            log.error("getReadDirectCV with option {}", (Object)tc.getCommandOptions());
            return null;
        }
        NceMessage m = new NceMessage(3);
        m.setBinary(true);
        m.setReplyLen(2);
        m.setOpCode(169);
        m.setElement(1, cv >> 8);
        m.setElement(2, cv & 0xFF);
        m.setNeededMode(4);
        m.setTimeout(10000);
        return m;
    }

    public static NceMessage getWriteDirectCV(NceTrafficController tc, int cv, int val) {
        if (tc.getUsbSystem() == 2 || tc.getUsbSystem() == 5 || tc.getUsbSystem() == 3) {
            log.error("attempt to send unsupported binary command WRITE_DIR_CV_CMD to NCE USB");
            return null;
        }
        if (tc.getCommandOptions() < 20) {
            log.error("getWriteDirectCV with option {}", (Object)tc.getCommandOptions());
        }
        NceMessage m = new NceMessage(4);
        m.setBinary(true);
        m.setReplyLen(1);
        m.setOpCode(168);
        m.setElement(1, cv >> 8);
        m.setElement(2, cv & 0xFF);
        m.setElement(3, val);
        m.setNeededMode(4);
        m.setTimeout(10000);
        return m;
    }

    public static NceMessage getEpromVersion(NceTrafficController tc) {
        byte[] bl = NceBinaryCommand.getNceEpromRev();
        NceMessage m = NceMessage.createBinaryMessage(tc, bl, 3);
        return m;
    }

    public static NceMessage sendLocoCmd(NceTrafficController tc, int locoAddr, byte locoSubCmd, byte locoData) {
        byte[] bl = NceBinaryCommand.nceLocoCmd(locoAddr, locoSubCmd, locoData);
        NceMessage m = NceMessage.createBinaryMessage(tc, bl, 1);
        return m;
    }

    public static NceMessage sendPacketMessage(NceTrafficController tc, byte[] bytes) {
        NceMessage m = NceMessage.sendPacketMessage(tc, bytes, 2);
        return m;
    }

    public static NceMessage sendPacketMessage(NceTrafficController tc, byte[] bytes, int retries) {
        if (tc.getUsbSystem() != 0) {
            log.error("attempt to send unsupported sendPacketMessage to NCE USB cmd: 0x{}", (Object)Integer.toHexString(144 + bytes.length));
            return null;
        }
        if (tc.getCommandOptions() >= 0) {
            if (bytes.length < 3 || bytes.length > 6) {
                log.error("Send of NCE track packet too short or long:{} packet:{}", (Object)Integer.toString(bytes.length), (Object)Arrays.toString(bytes));
            }
            NceMessage m = new NceMessage(2 + bytes.length);
            m.setBinary(true);
            m.setTimeout(10000);
            m.setReplyLen(1);
            int i = 0;
            m.setElement(i++, 144 + bytes.length);
            m.setElement(i++, retries);
            for (int j = 0; j < bytes.length; ++j) {
                m.setElement(i++, bytes[j] & 0xFF);
            }
            return m;
        }
        NceMessage m = new NceMessage(5 + 3 * bytes.length);
        m.setBinary(false);
        int i = 0;
        m.setElement(i++, 83);
        m.setElement(i++, 32);
        m.setElement(i++, 67);
        m.setElement(i++, 48);
        m.setElement(i++, 50);
        for (int j = 0; j < bytes.length; ++j) {
            m.setElement(i++, 32);
            m.addIntAsTwoHex(bytes[j] & 0xFF, i);
            i += 2;
        }
        m.setTimeout(10000);
        return m;
    }

    public static NceMessage createBinaryMessage(NceTrafficController tc, byte[] bytes) {
        return NceMessage.createBinaryMessage(tc, bytes, 1);
    }

    public static NceMessage createBinaryMessage(NceTrafficController tc, byte[] bytes, int replyLen) {
        if (tc.getCommandOptions() < 10) {
            log.error("Attempt to send NCE command to EPROM built before 2004");
        }
        if (bytes.length < 1 || bytes.length > 20) {
            log.error("NCE command message length error:{}", (Object)bytes.length);
        }
        NceMessage m = new NceMessage(bytes.length);
        m.setBinary(true);
        m.setReplyLen(replyLen);
        m.setTimeout(10000);
        for (int j = 0; j < bytes.length; ++j) {
            m.setElement(j, bytes[j] & 0xFF);
        }
        return m;
    }

    public static NceMessage queuePacketMessage(NceTrafficController tc, byte[] bytes) {
        if (tc.getUsbSystem() != 0) {
            log.error("attempt to send unsupported queuePacketMessage to NCE USB");
            return null;
        }
        if (tc.getCommandOptions() >= 0) {
            if (bytes.length < 3 || bytes.length > 6) {
                log.error("Queue of NCE track packet too long:{} packet :{}", (Object)Integer.toString(bytes.length), (Object)Arrays.toString(bytes));
            }
            NceMessage m = new NceMessage(1 + bytes.length);
            m.setBinary(true);
            m.setReplyLen(1);
            int i = 0;
            m.setElement(i++, 160 + bytes.length);
            for (int j = 0; j < bytes.length; ++j) {
                m.setElement(i++, bytes[j] & 0xFF);
            }
            return m;
        }
        NceMessage m = new NceMessage(1 + 3 * bytes.length);
        m.setBinary(false);
        int i = 0;
        m.setElement(i++, 81);
        for (int j = 0; j < bytes.length; ++j) {
            m.setElement(i++, 32);
            m.addIntAsTwoHex(bytes[j] & 0xFF, i);
            i += 2;
        }
        return m;
    }

    public static NceMessage createAccySignalMacroMessage(NceTrafficController tc, int op, int addr, int data) {
        if (tc.getCommandOptions() < 10) {
            log.error("Attempt to send NCE command to EPROM built before 2004");
        }
        NceMessage m = new NceMessage(5);
        m.setBinary(true);
        m.setReplyLen(1);
        m.setTimeout(10000);
        m.setOpCode(173);
        m.setElement(1, addr >> 8 & 0xFF);
        m.setElement(2, addr & 0xFF);
        m.setElement(3, op);
        m.setElement(4, data);
        return m;
    }

    public static NceMessage createAccDecoderPktOpsMode(NceTrafficController tc, int accyAddr, int cvAddr, int cvData) {
        NceMessage m = new NceMessage(6);
        m.setBinary(true);
        m.setReplyLen(1);
        m.setTimeout(10000);
        byte[] mess = NceBinaryCommand.usbOpsModeAccy(accyAddr, cvAddr, cvData);
        m.setOpCode(mess[0]);
        m.setElement(1, mess[1]);
        m.setElement(2, mess[2]);
        m.setElement(3, mess[3]);
        m.setElement(4, mess[4]);
        m.setElement(5, mess[5]);
        return m;
    }

    @Override
    public String toMonitorString() {
        return nceMon.displayMessage(this);
    }
}

