/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.Programmer;
import jmri.jmrix.nce.NceOpsModeProgrammer;
import jmri.jmrix.nce.NceProgrammer;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.managers.DefaultProgrammerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceProgrammerManager
extends DefaultProgrammerManager {
    NceTrafficController tc;
    NceSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(NceProgrammerManager.class);

    public NceProgrammerManager(@Nonnull NceSystemConnectionMemo memo) {
        super(NceProgrammerManager.checkGlobalProgrammerAvailable(memo.getNceTrafficController()) ? new NceProgrammer(memo.getNceTrafficController()) : null, memo);
        this.tc = memo.getNceTrafficController();
        this.memo = memo;
        log.trace("NceProgrammerManager({}) with {}", (Object)memo, (Object)NceProgrammerManager.checkGlobalProgrammerAvailable(memo.getNceTrafficController()));
        Objects.requireNonNull(memo, "require NceSystemConnectionMemo");
    }

    @Override
    public boolean isAddressedModePossible() {
        Objects.requireNonNull(this.tc, "require NceTrafficController");
        Objects.requireNonNull(this.memo, "require NceSystemConnectionMemo");
        switch (this.memo.getNceUsbSystem()) {
            case 3: {
                log.trace("isAddressedModePossible returns false");
                return false;
            }
        }
        log.trace("isAddressedModePossible returns true");
        return true;
    }

    @Override
    public boolean isGlobalProgrammerAvailable() {
        Objects.requireNonNull(this.tc, "require NceTrafficController");
        return NceProgrammerManager.checkGlobalProgrammerAvailable(this.tc);
    }

    private static boolean checkGlobalProgrammerAvailable(@Nonnull NceTrafficController tc) {
        switch (tc.getUsbSystem()) {
            case 0: 
            case 1: 
            case 4: {
                log.trace("checkGlobalProgrammerAvailable returns true");
                return true;
            }
        }
        log.trace("checkGlobalProgrammerAvailable returns false");
        return false;
    }

    @Override
    public Programmer getGlobalProgrammer() {
        if (!this.isGlobalProgrammerAvailable()) {
            return null;
        }
        return super.getGlobalProgrammer();
    }

    @Override
    public AddressedProgrammer getAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return new NceOpsModeProgrammer(this.tc, pAddress, pLongAddress);
    }

    @Override
    public AddressedProgrammer reserveAddressedProgrammer(boolean pLongAddress, int pAddress) {
        return null;
    }
}

