/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.nce.Bundle;
import jmri.jmrix.nce.NceAIU;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSensor;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.managers.AbstractSensorManager;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceSensorManager
extends AbstractSensorManager
implements NceListener {
    private final NceSensorManager mInstance;
    private final int aiuCabIdMin;
    private final int aiuCabIdMax;
    private NceAIU[] aiuArray = null;
    private int[] activeAIUs = null;
    private int activeAIUMax = 0;
    private static final int MINPIN = 1;
    private static final int MAXPIN = 14;
    volatile Thread pollThread;
    volatile boolean stopPolling = false;
    NceListener listener;
    private boolean loggedAiuNotSupported = false;
    private final int shortCycleInterval = 200;
    private final int longCycleInterval = 10000;
    private final long maxSilentInterval = 30000L;
    private final int pollTimeout = 20000;
    private int aiuCycleCount;
    private long lastMessageReceived;
    private NceAIU currentAIU;
    private boolean awaitingReply = false;
    private boolean awaitingDelay = false;
    int aiucab = 0;
    int pin = 0;
    int iName = 0;
    private static final Logger log = LoggerFactory.getLogger(NceSensorManager.class);

    public NceSensorManager(NceSystemConnectionMemo memo) {
        super(memo);
        this.aiuCabIdMin = memo.getNceTrafficController().csm.getCabMin();
        this.aiuCabIdMax = memo.getNceTrafficController().csm.getCabMax();
        this.aiuArray = new NceAIU[this.aiuCabIdMax + 1];
        for (int i = this.aiuCabIdMin; i <= this.aiuCabIdMax; ++i) {
            this.aiuArray[i] = null;
        }
        this.activeAIUs = new int[this.aiuCabIdMax];
        this.mInstance = this;
        this.listener = new NceListener(){

            @Override
            public void message(NceMessage m) {
            }

            @Override
            public void reply(NceReply r) {
                if (r.isSensorMessage()) {
                    NceSensorManager.this.mInstance.handleSensorMessage(r);
                }
            }
        };
        memo.getNceTrafficController().addNceListener(this.listener);
    }

    @Override
    @Nonnull
    public NceSystemConnectionMemo getMemo() {
        return (NceSystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        this.stopPolling = true;
        Thread thread = this.pollThread;
        if (thread != null) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException ex) {
                log.warn("dispose interrupted");
            }
        }
        this.getMemo().getNceTrafficController().removeNceListener(this.listener);
        super.dispose();
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String normName;
        int number = 0;
        try {
            String address = systemName.substring(this.getSystemPrefix().length() + 1);
            normName = this.createSystemName(address, this.getSystemPrefix());
            number = Integer.parseInt(normName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException | JmriException e) {
            throw new IllegalArgumentException("Unable to convert " + systemName.substring(this.getSystemPrefix().length() + 1) + " to NCE sensor address");
        }
        NceSensor s = new NceSensor(normName);
        s.setUserName(userName);
        int index = number / 16 + 1;
        if (this.aiuArray[index] == null) {
            this.aiuArray[index] = new NceAIU();
            this.buildActiveAIUs();
        }
        this.aiuArray[index].registerSensor(s, number - (index - 1) * 16);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildActiveAIUs() {
        if ((this.getMemo().getNceTrafficController().getCmdGroups() & 4L) != 4L && !this.loggedAiuNotSupported) {
            log.info("AIU not supported in this configuration");
            this.loggedAiuNotSupported = true;
            return;
        }
        this.activeAIUMax = 0;
        for (int a = this.aiuCabIdMin; a <= this.aiuCabIdMax; ++a) {
            if (this.aiuArray[a] == null) continue;
            this.activeAIUs[this.activeAIUMax++] = a;
        }
        this.aiuCycleCount = 0;
        this.lastMessageReceived = Long.MIN_VALUE;
        if (this.activeAIUMax > 0) {
            if (this.pollThread == null) {
                this.pollThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NceSensorManager.this.pollManager();
                    }
                });
                this.pollThread.setName(this.getMemo().getNceTrafficController().getUserName() + " Sensor Poll");
                this.pollThread.setDaemon(true);
                this.pollThread.start();
            } else {
                NceSensorManager nceSensorManager = this;
                synchronized (nceSensorManager) {
                    if (this.awaitingDelay) {
                        this.notify();
                    }
                }
            }
        }
    }

    public NceMessage makeAIUPoll(int aiuNo) {
        if (this.getMemo().getNceTrafficController().getUsbSystem() == 0) {
            return this.makeAIUPoll4ByteReply(aiuNo);
        }
        return this.makeAIUPoll2ByteReply(aiuNo);
    }

    private NceMessage makeAIUPoll4ByteReply(int aiuNo) {
        NceMessage m = new NceMessage(2);
        m.setBinary(true);
        m.setReplyLen(4);
        m.setElement(0, 138);
        m.setElement(1, aiuNo);
        m.setTimeout(20000);
        return m;
    }

    private NceMessage makeAIUPoll2ByteReply(int aiuNo) {
        NceMessage m = new NceMessage(2);
        m.setBinary(true);
        m.setReplyLen(2);
        m.setElement(0, 155);
        m.setElement(1, aiuNo);
        m.setTimeout(20000);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollManager() {
        if ((this.getMemo().getNceTrafficController().getCmdGroups() & 4L) != 4L) {
            if (!this.loggedAiuNotSupported) {
                log.info("AIU not supported in this configuration");
                this.loggedAiuNotSupported = true;
            }
        } else {
            while (!this.stopPolling) {
                for (int a = 0; a < this.activeAIUMax; ++a) {
                    int aiuNo = this.activeAIUs[a];
                    this.currentAIU = this.aiuArray[aiuNo];
                    if (this.currentAIU == null) continue;
                    NceMessage m = this.makeAIUPoll(aiuNo);
                    NceSensorManager nceSensorManager = this;
                    synchronized (nceSensorManager) {
                        log.debug("queueing poll request for AIU {}", (Object)aiuNo);
                        this.getMemo().getNceTrafficController().sendNceMessage(m, this);
                        this.awaitingReply = true;
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                    int delay = 200;
                    if (this.aiuCycleCount >= 2 && this.lastMessageReceived >= System.currentTimeMillis() - 30000L) {
                        delay = 10000;
                    }
                    NceSensorManager nceSensorManager2 = this;
                    synchronized (nceSensorManager2) {
                        if (this.awaitingReply && !this.stopPolling) {
                            log.warn("timeout awaiting poll response for AIU {}", (Object)aiuNo);
                            delay = 20000;
                        }
                        try {
                            this.awaitingDelay = true;
                            this.wait(delay);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        finally {
                            this.awaitingDelay = false;
                        }
                        continue;
                    }
                }
                ++this.aiuCycleCount;
            }
        }
    }

    @Override
    public void message(NceMessage r) {
        log.warn("unexpected message");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reply(NceReply r) {
        if (!r.isUnsolicited()) {
            int bits;
            NceSensorManager nceSensorManager = this;
            synchronized (nceSensorManager) {
                bits = r.pollValue();
                this.awaitingReply = false;
                this.notify();
            }
            this.currentAIU.markChanges(bits);
            if (log.isDebugEnabled()) {
                Object str = StringUtil.twoHexFromInt(bits >> 4 & 0xF);
                str = (String)str + " ";
                str = StringUtil.appendTwoHexFromInt(bits & 0xF, (String)str);
                log.debug("sensor poll reply received: \"{}\"", str);
            }
        }
    }

    public void handleSensorMessage(AbstractMRReply r) {
        int index = r.getElement(1) - 48;
        int indicator = r.getElement(2);
        if (r.getElement(0) == 97 && r.getElement(1) >= 48 && r.getElement(1) <= 111 && (indicator >= 65 && indicator <= 94 || indicator >= 97 && indicator <= 126)) {
            this.lastMessageReceived = System.currentTimeMillis();
            if (this.aiuArray[index] == null) {
                log.debug("unsolicited message \"{}\" for unused sensor array", (Object)r.toString());
            } else {
                int newState;
                int sensorNo;
                if (indicator >= 96) {
                    sensorNo = indicator - 97;
                    newState = 2;
                } else {
                    sensorNo = indicator - 65;
                    newState = 4;
                }
                Sensor s = this.aiuArray[index].getSensor(sensorNo);
                if (s.getInverted()) {
                    if (newState == 2) {
                        newState = 4;
                    } else if (newState == 4) {
                        newState = 2;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Handling sensor message \"{}\" for {} {}", new Object[]{r, s.getSystemName(), s.describeState(newState)});
                }
                this.aiuArray[index].sensorChange(sensorNo, newState);
            }
        } else {
            log.warn("incorrect sensor message: {}", (Object)r.toString());
        }
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (curAddress.contains(":")) {
            int seperator = curAddress.indexOf(":");
            try {
                this.aiucab = Integer.parseInt(curAddress.substring(0, seperator));
                this.pin = Integer.parseInt(curAddress.substring(seperator + 1));
            }
            catch (NumberFormatException ex) {
                throw new JmriException(Bundle.getMessage(Locale.ENGLISH, "CreateSystemNameBadColonFormat", curAddress));
            }
            this.iName = (this.aiucab - 1) * 16 + this.pin - 1;
        } else {
            try {
                this.iName = Integer.parseInt(curAddress);
            }
            catch (NumberFormatException ex) {
                throw new JmriException(Bundle.getMessage(Locale.ENGLISH, "CreateSystemNameBadValueFormat", curAddress));
            }
            this.pin = this.iName % 16 + 1;
            this.aiucab = this.iName / 16 + 1;
        }
        if (this.pin < 1 || this.pin > 14) {
            throw new JmriException(Bundle.getMessage(Locale.ENGLISH, "CreateSystemNameBadPinValue", this.pin, curAddress, 1, 14));
        }
        if (this.aiucab < this.aiuCabIdMin || this.aiucab > this.aiuCabIdMax) {
            throw new JmriException(Bundle.getMessage(Locale.ENGLISH, "CreateSystemNameBadAIUValue", this.aiucab, curAddress, this.aiuCabIdMin, this.aiuCabIdMin));
        }
        return prefix + this.typeLetter() + this.iName;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        int num;
        String[] parts;
        if (name.contains(":")) {
            parts = super.validateSystemNameFormat(name, locale).substring(this.getSystemNamePrefix().length()).split(":");
            if (parts.length != 2) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNeedCabAndPin", name), Bundle.getMessage(locale, "InvalidSystemNameNeedCabAndPin", name));
            }
        } else {
            parts = new String[]{"0", "0"};
            try {
                num = Integer.parseInt(super.validateSystemNameFormat(name, locale).substring(this.getSystemNamePrefix().length()));
                if (num < this.aiuCabIdMin * 16) {
                    throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax), Bundle.getMessage(locale, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax));
                }
                parts[0] = Integer.toString(num / 16 + 1);
                parts[1] = Integer.toString(num % 16 + 1);
            }
            catch (NumberFormatException ex) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNeedCabAndPin", name), Bundle.getMessage(locale, "InvalidSystemNameNeedCabAndPin", name));
            }
        }
        try {
            num = Integer.parseInt(parts[0]);
            if (num < this.aiuCabIdMin || num > this.aiuCabIdMax) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax), Bundle.getMessage(locale, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax));
            }
        }
        catch (NumberFormatException ex) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax), Bundle.getMessage(locale, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax));
        }
        try {
            num = Integer.parseInt(parts[1]);
            if (num < 1 || num > 14) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUPin", name), Bundle.getMessage(locale, "InvalidSystemNameBadAIUPin", name));
            }
        }
        catch (NumberFormatException ex) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax), Bundle.getMessage(locale, "InvalidSystemNameBadAIUCab", name, this.aiuCabIdMin, this.aiuCabIdMax));
        }
        return name;
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        if (super.validSystemNameFormat(systemName) == Manager.NameValidity.VALID) {
            try {
                this.validateSystemNameFormat(systemName);
            }
            catch (IllegalArgumentException ex) {
                if (systemName.endsWith(":")) {
                    try {
                        int num = Integer.parseInt(systemName.substring(this.getSystemNamePrefix().length(), systemName.length() - 1));
                        if (num >= this.aiuCabIdMin && num <= this.aiuCabIdMax) {
                            return Manager.NameValidity.VALID_AS_PREFIX_ONLY;
                        }
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                        // empty catch block
                    }
                }
                return Manager.NameValidity.INVALID;
            }
        }
        return Manager.NameValidity.VALID;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

