/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.AddressedProgrammerManager;
import jmri.ClockControl;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.NamedBean;
import jmri.PowerManager;
import jmri.SensorManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.nce.NceClockControl;
import jmri.jmrix.nce.NceConsistManager;
import jmri.jmrix.nce.NceLightManager;
import jmri.jmrix.nce.NcePowerManager;
import jmri.jmrix.nce.NceProgrammerManager;
import jmri.jmrix.nce.NceSensorManager;
import jmri.jmrix.nce.NceThrottleManager;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.NceTurnoutManager;
import jmri.jmrix.nce.swing.NceComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceSystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    ComponentFactory componentFactory;
    private NceTrafficController nceTrafficController;
    private static final Logger log = LoggerFactory.getLogger(NceSystemConnectionMemo.class);

    public NceSystemConnectionMemo() {
        super("N", "NCE");
        this.register();
        InstanceManager.store(this, NceSystemConnectionMemo.class);
        this.componentFactory = new NceComponentFactory(this);
        InstanceManager.store(this.componentFactory, ComponentFactory.class);
    }

    public void setNceUsbSystem(int result) {
        this.getNceTrafficController().setUsbSystem(result);
    }

    public int getNceUsbSystem() {
        if (this.getNceTrafficController() != null) {
            return this.getNceTrafficController().getUsbSystem();
        }
        return 0;
    }

    public void setNceCmdGroups(long result) {
        this.getNceTrafficController().setCmdGroups(result);
    }

    public long getNceCmdGroups() {
        if (this.getNceTrafficController() != null) {
            return this.getNceTrafficController().getCmdGroups();
        }
        return 0L;
    }

    public NceTrafficController getNceTrafficController() {
        return this.nceTrafficController;
    }

    public void setNceTrafficController(NceTrafficController tc) {
        this.nceTrafficController = tc;
        if (tc != null) {
            tc.setAdapterMemo(this);
        }
    }

    public NceProgrammerManager getProgrammerManager() {
        if (this.getDisabled()) {
            return null;
        }
        return (NceProgrammerManager)this.classObjectMap.computeIfAbsent(NceProgrammerManager.class, c -> new NceProgrammerManager(this));
    }

    public void setProgrammerManager(NceProgrammerManager p) {
        this.store(p, NceProgrammerManager.class);
    }

    public void configureCommandStation(int val) {
        this.getNceTrafficController().setCommandOptions(val);
        this.store(this.nceTrafficController, CommandStation.class);
        InstanceManager.store(this.nceTrafficController, CommandStation.class);
    }

    @Override
    public void configureManagers() {
        log.trace("configureManagers() with: {} ", (Object)this.getNceUsbSystem());
        NcePowerManager powerManager = new NcePowerManager(this);
        this.store(powerManager, PowerManager.class);
        InstanceManager.store(powerManager, PowerManager.class);
        NceTurnoutManager turnoutManager = new NceTurnoutManager(this);
        this.store(turnoutManager, TurnoutManager.class);
        InstanceManager.setTurnoutManager(turnoutManager);
        NceLightManager lightManager = new NceLightManager(this);
        this.store(lightManager, LightManager.class);
        InstanceManager.setLightManager(lightManager);
        NceSensorManager sensorManager = new NceSensorManager(this);
        this.store(sensorManager, SensorManager.class);
        InstanceManager.setSensorManager(sensorManager);
        NceThrottleManager throttleManager = new NceThrottleManager(this);
        this.store(throttleManager, ThrottleManager.class);
        InstanceManager.setThrottleManager(throttleManager);
        if (this.getProgrammerManager().isAddressedModePossible()) {
            log.trace("store AddressedProgrammerManager");
            this.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            log.trace("store GlobalProgrammerManager");
            this.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        NceClockControl clockManager = new NceClockControl(this.getNceTrafficController(), this.getSystemPrefix());
        this.store(clockManager, ClockControl.class);
        InstanceManager.store(clockManager, ClockControl.class);
        InstanceManager.setDefault(ClockControl.class, clockManager);
        this.setConsistManager(new NceConsistManager(this));
        log.trace("configureManagers() end");
    }

    public NcePowerManager getPowerManager() {
        return (NcePowerManager)this.get(PowerManager.class);
    }

    public NceTurnoutManager getTurnoutManager() {
        return (NceTurnoutManager)this.get(TurnoutManager.class);
    }

    public NceLightManager getLightManager() {
        return (NceLightManager)this.get(LightManager.class);
    }

    public NceSensorManager getSensorManager() {
        return (NceSensorManager)this.get(SensorManager.class);
    }

    public NceThrottleManager getThrottleManager() {
        return (NceThrottleManager)this.get(ThrottleManager.class);
    }

    public NceClockControl getClockControl() {
        return (NceClockControl)this.get(ClockControl.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.nce.NceActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        this.nceTrafficController = null;
        InstanceManager.deregister(this, NceSystemConnectionMemo.class);
        if (this.componentFactory != null) {
            InstanceManager.deregister(this.componentFactory, ComponentFactory.class);
        }
        super.dispose();
    }
}

