/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import java.util.EnumSet;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.LocoAddress;
import jmri.SpeedStepMode;
import jmri.ThrottleListener;
import jmri.jmrix.AbstractThrottleManager;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceThrottle;
import jmri.jmrix.nce.NceTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceThrottleManager
extends AbstractThrottleManager {
    NceTrafficController tc = null;
    String prefix = "";
    private static final Logger log = LoggerFactory.getLogger(NceThrottleManager.class);

    public NceThrottleManager(NceSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getNceTrafficController();
        this.prefix = memo.getSystemPrefix();
    }

    @Override
    public void requestThrottleSetup(LocoAddress a, boolean control) {
        if (a instanceof DccLocoAddress) {
            DccLocoAddress address = (DccLocoAddress)a;
            log.debug("new NceThrottle for {}", (Object)address);
            this.notifyThrottleKnown(new NceThrottle((NceSystemConnectionMemo)this.adapterMemo, address), address);
        } else {
            log.error("{} is not a DccLocoAddress", (Object)a);
            this.failedThrottleRequest(a, "LocoAddress " + a + " is not a DccLocoAddress");
        }
    }

    @Override
    public boolean canBeLongAddress(int address) {
        return address >= 0 && address <= 10239;
    }

    @Override
    public boolean canBeShortAddress(int address) {
        return address >= 1 && address <= 127;
    }

    @Override
    public boolean addressTypeUnique() {
        return false;
    }

    @Override
    public EnumSet<SpeedStepMode> supportedSpeedModes() {
        return EnumSet.of(SpeedStepMode.NMRA_DCC_128, SpeedStepMode.NMRA_DCC_28);
    }

    @Override
    public boolean disposeThrottle(DccThrottle t, ThrottleListener l) {
        if (super.disposeThrottle(t, l) && t instanceof NceThrottle) {
            NceThrottle nct = (NceThrottle)t;
            nct.throttleDispose();
            return true;
        }
        return false;
    }
}

