/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.CommandStation;
import jmri.JmriException;
import jmri.NmraPacket;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.nce.NceAIUChecker;
import jmri.jmrix.nce.NceCmdStationMemory;
import jmri.jmrix.nce.NceConnectionStatus;
import jmri.jmrix.nce.NceInterface;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceMessageCheck;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSensorManager;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTurnoutMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceTrafficController
extends AbstractMRTrafficController
implements NceInterface,
CommandStation {
    NceSensorManager mSensorManager = null;
    public static final int OPTION_FORCE_ASCII = -1;
    public static final int OPTION_1999 = 0;
    public static final int OPTION_2004 = 10;
    public static final int OPTION_2006 = 20;
    public static final int OPTION_1_28 = 30;
    public static final int OPTION_1_65 = 40;
    public static final int OPTION_PH5 = 80;
    public static final int OPTION_FORCE_BINARY = 10000;
    private int commandOptions = 20;
    public boolean commandOptionSet = false;
    private boolean nceEpromMarch2007 = false;
    private boolean pwrProVer060203orLater = false;
    private final int[] pwrProVers = new int[3];
    private boolean simulatorRunning = false;
    public static final int USB_SYSTEM_NONE = 0;
    public static final int USB_SYSTEM_POWERCAB = 1;
    public static final int USB_SYSTEM_SB3 = 2;
    public static final int USB_SYSTEM_POWERPRO = 3;
    public static final int USB_SYSTEM_TWIN = 4;
    public static final int USB_SYSTEM_SB5 = 5;
    private int usbSystem = 0;
    private boolean usbSystemSet = false;
    public static final long CMDS_NONE = 0L;
    public static final long CMDS_ACCYADDR250 = 1L;
    public static final long CMDS_PROGTRACK = 2L;
    public static final long CMDS_AUI_READ = 4L;
    public static final long CMDS_MEM = 8L;
    public static final long CMDS_OPS_PGM = 16L;
    public static final long CMDS_CLOCK = 32L;
    public static final long CMDS_USB = 64L;
    public static final long CMDS_NOT_USB = 128L;
    public static final long CMDS_ALL_SYS = 256L;
    private long cmdGroups = 0L;
    private boolean cmdGroupsSet = false;
    private boolean nceProgMode = false;
    NceConnectionStatus pollEprom = new NceConnectionStatus(this);
    NceAIUChecker pollAiuStatus = null;
    NceTurnoutMonitor pollHandler = null;
    boolean expectReplyEprom = false;
    protected int replyLen;
    protected boolean replyBinary;
    protected boolean unsolicitedSensorMessageSeen = false;
    private NceSystemConnectionMemo memo = null;
    public NceCmdStationMemory csm;
    private static final Logger log = LoggerFactory.getLogger(NceTrafficController.class);

    @Override
    public synchronized void addNceListener(NceListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeNceListener(NceListener l) {
        this.removeListener(l);
    }

    @Override
    protected int enterProgModeDelayTime() {
        return 1000;
    }

    @Override
    public boolean sendPacket(byte[] packet, int count) {
        NceMessage m;
        boolean isUsb;
        boolean bl = isUsb = this.getUsbSystem() == 1 || this.getUsbSystem() == 2 || this.getUsbSystem() == 5 || this.getUsbSystem() == 4;
        if (NmraPacket.isAccSignalDecoderPkt(packet) && NmraPacket.getAccSignalDecoderPktAddress(packet) > 0 && NmraPacket.getAccSignalDecoderPktAddress(packet) <= 2044) {
            int addr = NmraPacket.getAccSignalDecoderPktAddress(packet);
            byte aspect = packet[2];
            log.debug("isAccSignalDecoderPkt(packet) sigAddr ={}, aspect ={}", (Object)addr, (Object)aspect);
            m = NceMessage.createAccySignalMacroMessage(this, 5, addr, aspect);
        } else if (isUsb && NmraPacket.isAccDecoderPktOpsMode(packet)) {
            int accyAddr = NmraPacket.getAccDecoderPktOpsModeAddress(packet);
            int cvAddr = ((3 & packet[2]) << 8 | 0xFF & packet[3]) + 1;
            int cvData = 0xFF & packet[4];
            log.debug("isAccDecoderPktOpsMode(packet) accyAddr ={}, cvAddr = {}, cvData ={}", new Object[]{accyAddr, cvAddr, cvData});
            m = NceMessage.createAccDecoderPktOpsMode(this, accyAddr, cvAddr, cvData);
        } else if (isUsb && NmraPacket.isAccDecoderPktOpsModeLegacy(packet)) {
            int accyAddr = NmraPacket.getAccDecoderPktOpsModeLegacyAddress(packet);
            int cvData = 0xFF & packet[3];
            int cvAddr = ((3 & packet[1]) << 8 | 0xFF & packet[2]) + 1;
            log.debug("isAccDecoderPktOpsModeLegacy(packet) accyAddr ={}, cvAddr = {}, cvData ={}", new Object[]{accyAddr, cvAddr, cvData});
            m = NceMessage.createAccDecoderPktOpsMode(this, accyAddr, cvAddr, cvData);
        } else {
            m = NceMessage.sendPacketMessage(this, packet);
            if (m == null) {
                return false;
            }
        }
        this.sendNceMessage(m, null);
        return true;
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((NceListener)client).message((NceMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((NceListener)client).reply((NceReply)r);
    }

    public void setSensorManager(NceSensorManager m) {
        this.mSensorManager = m;
    }

    public NceSensorManager getSensorManager() {
        return this.mSensorManager;
    }

    public String getPwrProVersHexText() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(this.pwrProVers[0] & 0xFF)).append(".");
        sb.append(Integer.toHexString(this.pwrProVers[1] & 0xFF)).append(".");
        sb.append(Integer.toHexString(this.pwrProVers[2] & 0xFF));
        return sb.toString();
    }

    public void setPwrProVers(byte VV, byte MM, byte mm) {
        this.pwrProVers[0] = VV & 0xFF;
        this.pwrProVers[1] = MM & 0xFF;
        this.pwrProVers[2] = mm & 0xFF;
    }

    public boolean isPwrProVer060203orLater() {
        return this.pwrProVer060203orLater;
    }

    public void setPwrProVer060203orLater(boolean isTrue) {
        this.pwrProVer060203orLater = isTrue;
    }

    public boolean isNceEpromMarch2007() {
        return this.nceEpromMarch2007;
    }

    public void setNceEpromMarch2007(boolean b) {
        this.nceEpromMarch2007 = b;
    }

    public boolean isSimulatorRunning() {
        return this.simulatorRunning;
    }

    public void setSimulatorRunning(boolean b) {
        this.simulatorRunning = b;
    }

    public void setCommandOptions(int val) {
        this.commandOptions = val;
        if (this.commandOptionSet) {
            log.warn("setCommandOptions called more than once");
        }
        this.commandOptionSet = true;
    }

    public int getCommandOptions() {
        return this.commandOptions;
    }

    public void setUsbSystem(int val) {
        this.usbSystem = val;
        if (this.usbSystemSet) {
            log.warn("setUsbSystem called more than once");
        }
        this.usbSystemSet = true;
    }

    public int getUsbSystem() {
        return this.usbSystem;
    }

    public void setCmdGroups(long val) {
        this.cmdGroups = val;
        if (this.cmdGroupsSet) {
            log.warn("setCmdGroups called more than once");
        }
        this.cmdGroupsSet = true;
    }

    public long getCmdGroups() {
        return this.cmdGroups;
    }

    public boolean getNceProgMode() {
        return this.nceProgMode;
    }

    public void setNceProgMode(boolean b) {
        this.nceProgMode = b;
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        if (!this.commandOptionSet) {
            if (log.isDebugEnabled()) {
                log.debug("Command options are not valid yet!!");
            }
            return null;
        }
        NceMessage m = this.pollEprom.nceEpromPoll();
        if (m != null) {
            this.expectReplyEprom = true;
            return m;
        }
        this.expectReplyEprom = false;
        if (this.pollAiuStatus == null) {
            this.pollAiuStatus = new NceAIUChecker(this);
            return this.pollAiuStatus.nceAiuPoll();
        }
        if (this.pollHandler == null) {
            this.pollHandler = new NceTurnoutMonitor(this);
        }
        this.mWaitBeforePoll = 200;
        return this.pollHandler.pollMessage();
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        if (this.expectReplyEprom) {
            return this.pollEprom;
        }
        if (this.pollHandler == null) {
            return this.pollAiuStatus;
        }
        return this.pollHandler;
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="passing exception text")
    public void sendNceMessage(NceMessage m, NceListener reply) {
        try {
            NceMessageCheck.checkMessage(this.getAdapterMemo(), m);
        }
        catch (JmriException e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        this.sendMessage(m, reply);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        this.replyBinary = m.isBinary();
        this.replyLen = ((NceMessage)m).getReplyLen();
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return NceMessage.getProgMode(this);
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return NceMessage.getExitProgMode(this);
    }

    public void setAdapterMemo(NceSystemConnectionMemo adaptermemo) {
        this.memo = adaptermemo;
    }

    public NceSystemConnectionMemo getAdapterMemo() {
        return this.memo;
    }

    @Override
    protected AbstractMRReply newReply() {
        NceReply reply = new NceReply(this);
        reply.setBinary(this.replyBinary);
        return reply;
    }

    @Override
    protected boolean canReceive() {
        if (this.getCommandOptions() < 20) {
            return true;
        }
        if (this.replyLen > 0) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.error("unsolicited character received");
        }
        return false;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        msg.setBinary(this.replyBinary);
        if (this.replyBinary) {
            if (this.replyLen == 0 && this.getCommandOptions() < 20) {
                if (msg.getNumDataElements() == 1 && msg.getElement(0) == 97) {
                    return false;
                }
                if (msg.getNumDataElements() == 2 && msg.getElement(0) == 97 && msg.getElement(1) >= 48) {
                    return false;
                }
                if (msg.getNumDataElements() == 3 && msg.getElement(0) == 97 && msg.getElement(1) >= 48 && msg.getElement(2) >= 65 && msg.getElement(2) <= 111) {
                    return true;
                }
            }
            if (msg.getNumDataElements() >= this.replyLen) {
                this.replyLen = 0;
                return true;
            }
            return false;
        }
        int num = msg.getNumDataElements();
        int ptr = num - 1;
        if (num >= 9 && msg.getElement(ptr) == 32 && msg.getElement(ptr - 1) == 58 && msg.getElement(ptr - 2) == 68) {
            return true;
        }
        return num >= 19 && msg.getElement(ptr - 2) == 42 && msg.getElement(ptr - 3) == 42 && msg.getElement(ptr - 4) == 42 && msg.getElement(ptr - 5) == 42 && msg.getElement(ptr - 6) == 32 && msg.getElement(ptr - 7) == 68 && msg.getElement(ptr - 8) == 79 && msg.getElement(ptr - 9) == 79 && msg.getElement(ptr - 10) == 84 && msg.getElement(ptr - 11) == 83 && msg.getElement(ptr - 12) == 82;
    }

    @Override
    public String getUserName() {
        if (this.memo == null) {
            return "NCE";
        }
        return this.memo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.memo == null) {
            return "N";
        }
        return this.memo.getSystemPrefix();
    }
}

