/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.boosterprog;

import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.AddressedProgrammer;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.boosterprog.Bundle;
import jmri.jmrix.nce.swing.NcePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterProgPanel
extends NcePanel {
    JTextField start = new JTextField(6);
    JTextField length = new JTextField(12);
    JLabel status = new JLabel();
    private AddressedProgrammer p = null;
    private static final Logger log = LoggerFactory.getLogger(BoosterProgPanel.class);

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            try {
                this.initComponents((NceSystemConnectionMemo)context);
            }
            catch (Exception e) {
                log.warn("BoosterProg initContext", (Throwable)e);
            }
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.boosterprog.BoosterProgPanel";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("TitleBoosterProg"));
        return x.toString();
    }

    @Override
    public Dimension getMinimumDimension() {
        return new Dimension(400, 200);
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.setLayout(new BoxLayout(this, 1));
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JLabel warn = new JLabel(Bundle.getMessage("Warn1"));
        warn.setAlignmentX(0.0f);
        p.add(warn);
        warn = new JLabel(Bundle.getMessage("Warn2"));
        warn.setAlignmentX(0.0f);
        p.add(warn);
        box.add(p);
        box.add(Box.createRigidArea(new Dimension(0, 5)));
        p = new JPanel();
        p.setLayout(new FlowLayout());
        JButton b = new JButton(Bundle.getMessage("ButtonSet"));
        p.add(new JLabel(Bundle.getMessage("LabelStart")));
        this.start.setText("30");
        p.add(this.start);
        p.add(Box.createHorizontalGlue());
        p.add(b);
        b.addActionListener(e -> this.setStartPushed());
        box.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        b = new JButton(Bundle.getMessage("ButtonSet"));
        p.add(new JLabel(Bundle.getMessage("LabelDuration")));
        this.length.setText("420");
        p.add(this.length);
        p.add(Box.createHorizontalGlue());
        p.add(b);
        b.addActionListener(e -> this.setDurationPushed());
        box.add(p);
        this.add(box);
        this.add(Box.createVerticalGlue());
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(new JLabel(Bundle.getMessage("StatusLabel") + " "));
        p.add(this.status);
        this.status.setText(Bundle.getMessage("StatusOK"));
        p.setAlignmentX(0.0f);
        this.add(p);
    }

    private void getProgrammer() {
        this.p = this.memo.getProgrammerManager().getAddressedProgrammer(true, 0);
    }

    private void releaseProgrammer() {
        if (this.p != null) {
            this.memo.getProgrammerManager().releaseAddressedProgrammer(this.p);
        }
        this.p = null;
    }

    void setStartPushed() {
        this.getProgrammer();
        this.status.setText(Bundle.getMessage("StatusProgramming"));
        int val = Integer.parseInt(this.start.getText());
        try {
            this.p.writeCV("255", val, new ProgListener(){

                @Override
                public void programmingOpReply(int value, int retval) {
                    BoosterProgPanel.this.status.setText(Bundle.getMessage("StatusOK"));
                }
            });
        }
        catch (ProgrammerException e) {
            this.status.setText(Bundle.getMessage("StatusError") + e);
        }
        finally {
            this.releaseProgrammer();
        }
    }

    void setStart(int val) {
        this.getProgrammer();
        try {
            this.p.writeCV("255", val, new ProgListener(){

                @Override
                public void programmingOpReply(int value, int retval) {
                }
            });
        }
        catch (ProgrammerException programmerException) {
        }
        finally {
            this.releaseProgrammer();
        }
    }

    void setDuration(final int val) {
        this.getProgrammer();
        try {
            this.p.writeCV("253", val / 256, new ProgListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void programmingOpReply(int value, int retval) {
                    3 var3_3 = this;
                    synchronized (var3_3) {
                        try {
                            this.wait(1500L);
                        }
                        catch (InterruptedException i) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    try {
                        BoosterProgPanel.this.p.writeCV("254", val % 256, new ProgListener(){

                            @Override
                            public void programmingOpReply(int value, int retval) {
                            }
                        });
                    }
                    catch (ProgrammerException programmerException) {
                    }
                    finally {
                        BoosterProgPanel.this.releaseProgrammer();
                    }
                }
            });
        }
        catch (ProgrammerException e) {
            this.releaseProgrammer();
        }
    }

    void setDurationPushed() {
        this.getProgrammer();
        this.status.setText(Bundle.getMessage("StatusProgramming"));
        int val = Integer.parseInt(this.length.getText()) / 256;
        try {
            this.p.writeCV("253", val, new ProgListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void programmingOpReply(int value, int retval) {
                    4 var3_3 = this;
                    synchronized (var3_3) {
                        try {
                            this.wait(1500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    BoosterProgPanel.this.durationPart2();
                }
            });
        }
        catch (ProgrammerException e) {
            this.status.setText(Bundle.getMessage("StatusError") + e);
            this.releaseProgrammer();
        }
    }

    void durationPart2() {
        this.status.setText(Bundle.getMessage("StatusProgramming"));
        int val = Integer.parseInt(this.length.getText()) % 256;
        try {
            this.p.writeCV("254", val, new ProgListener(){

                @Override
                public void programmingOpReply(int value, int retval) {
                    BoosterProgPanel.this.status.setText(Bundle.getMessage("StatusOK"));
                }
            });
        }
        catch (ProgrammerException e) {
            this.status.setText(Bundle.getMessage("StatusError") + e);
        }
        finally {
            this.releaseProgrammer();
        }
    }
}

