/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.consist;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.consist.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistBackup
extends Thread
implements NceListener {
    private int consistRecLen = 16;
    private int replyLen = 0;
    private int waiting = 0;
    private boolean fileValid = false;
    private final byte[] nceConsistData = new byte[this.consistRecLen];
    JLabel textConsist = new JLabel();
    JLabel consistNumber = new JLabel();
    private NceTrafficController tc = null;
    private int consistStartNum = -1;
    private int consistEndNum = -1;
    private static final Logger log = LoggerFactory.getLogger(NceConsistBackup.class);

    public NceConsistBackup(NceTrafficController t) {
        this.tc = t;
        this.consistStartNum = this.tc.csm.getConsistMin();
        this.consistEndNum = this.tc.csm.getConsistMax();
    }

    @Override
    public void run() {
        Object fileName;
        String fileNameLC;
        JmriJFileChooser fc = new JmriJFileChooser(FileUtil.getUserFilesPath());
        fc.addChoosableFileFilter(new TextFilter());
        File fs = new File("NCE consist backup.txt");
        fc.setSelectedFile(fs);
        int retVal = fc.showSaveDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        File f = fc.getSelectedFile();
        if (fc.getFileFilter() != fc.getAcceptAllFileFilter() && !(fileNameLC = ((String)(fileName = f.getAbsolutePath())).toLowerCase()).endsWith(".txt")) {
            fileName = (String)fileName + ".txt";
            f = new File((String)fileName);
        }
        if (f.exists() && JmriJOptionPane.showConfirmDialog(null, MessageFormat.format(Bundle.getMessage("FileExists"), f.getName()), Bundle.getMessage("OverwriteFile"), 2) != 0) {
            return;
        }
        try (PrintWriter fileOut = new PrintWriter((Writer)new BufferedWriter(new FileWriter(f)), true);){
            if (JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("BackupTakesAwhile"), Bundle.getMessage("NceConsistBackup"), 0) != 0) {
                fileOut.close();
                return;
            }
            JPanel ps = new JPanel();
            JmriJFrame fstatus = new JmriJFrame(Bundle.getMessage("NceConsistBackup"));
            fstatus.setLocationRelativeTo(null);
            fstatus.setSize(300, 100);
            fstatus.getContentPane().add(ps);
            ps.add(this.textConsist);
            ps.add(this.consistNumber);
            this.textConsist.setText(Bundle.getMessage("ConsistLineNumber"));
            this.textConsist.setVisible(true);
            this.consistNumber.setVisible(true);
            this.waiting = 0;
            this.fileValid = true;
            int consistBytesEach = this.tc.csm.getConsistMidEntries() * 2 + 2 + 2;
            int memOffsetEnd = consistBytesEach * (1 + this.consistEndNum - this.consistStartNum);
            int consistRecNum = 0;
            int consistNum = this.consistStartNum;
            for (int memOffset = 0; memOffset < memOffsetEnd; memOffset += this.consistRecLen) {
                consistNum = this.consistStartNum + memOffset / consistBytesEach;
                consistRecNum = memOffset / this.consistRecLen;
                this.consistNumber.setText(Integer.toString(consistNum));
                fstatus.setVisible(true);
                this.getNceConsist(consistRecNum);
                if (!this.fileValid) {
                    memOffset = memOffsetEnd;
                }
                if (!this.fileValid) continue;
                StringBuilder buf = new StringBuilder();
                buf.append(":").append(Integer.toHexString(this.tc.csm.getConsistHeadAddr() + memOffset));
                for (int i = 0; i < this.consistRecLen; ++i) {
                    buf.append(" ").append(StringUtil.twoHexFromInt(this.nceConsistData[i++]));
                    buf.append(StringUtil.twoHexFromInt(this.nceConsistData[i]));
                }
                log.debug("consist {}", (Object)buf);
                fileOut.println(buf.toString());
            }
            if (this.fileValid) {
                String line = ":0000";
                fileOut.println(line);
            }
            fileOut.flush();
            fileOut.close();
            fstatus.dispose();
            if (this.fileValid) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SuccessfulBackup"), Bundle.getMessage("NceConsistBackup"), 1);
            } else {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("BackupFailed"), Bundle.getMessage("NceConsistBackup"), 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void getNceConsist(int cN) {
        NceMessage m = this.readConsistMemory(cN);
        this.tc.sendNceMessage(m, this);
        this.readWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readWait() {
        int waitcount = 30;
        while (this.waiting > 0) {
            NceConsistBackup nceConsistBackup = this;
            synchronized (nceConsistBackup) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (waitcount-- >= 0) continue;
            log.error("read timeout");
            this.fileValid = false;
            return false;
        }
        return true;
    }

    private NceMessage readConsistMemory(int consistNum) {
        int nceConsistAddr = consistNum * this.consistRecLen + this.tc.csm.getConsistHeadAddr();
        this.replyLen = 16;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryRead(nceConsistAddr);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 16);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        if (r.getNumDataElements() != this.replyLen) {
            log.error("reply length incorrect");
            return;
        }
        for (int i = 0; i < 16; ++i) {
            this.nceConsistData[i] = (byte)r.getElement(i);
        }
        --this.waiting;
        NceConsistBackup nceConsistBackup = this;
        synchronized (nceConsistBackup) {
            this.notify();
        }
    }
}

