/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.consist;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.consist.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistRestore
extends Thread
implements NceListener {
    private static final int CONSIST_LNTH = 16;
    private static final int REPLY_1 = 1;
    private int replyLen = 0;
    private int waiting = 0;
    private boolean fileValid = false;
    JLabel textConsist = new JLabel();
    JLabel consistNumber = new JLabel();
    private NceTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(NceConsistRestore.class);

    public NceConsistRestore(NceTrafficController t) {
        this.tc = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JmriJFileChooser fc = new JmriJFileChooser(FileUtil.getUserFilesPath());
        fc.addChoosableFileFilter(new TextFilter());
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        File f = fc.getSelectedFile();
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            JmriJFrame fstatus;
            block24: {
                JPanel ps = new JPanel();
                fstatus = new JmriJFrame(Bundle.getMessage("NceConsistRestore"));
                fstatus.setLocationRelativeTo(null);
                fstatus.setSize(300, 100);
                fstatus.getContentPane().add(ps);
                ps.add(this.textConsist);
                ps.add(this.consistNumber);
                this.textConsist.setText(Bundle.getMessage("ConsistLineNumber"));
                this.textConsist.setVisible(true);
                this.consistNumber.setVisible(true);
                this.waiting = 0;
                this.fileValid = false;
                int consistNum = 0;
                int curConsist = this.tc.csm.getConsistHeadAddr();
                byte[] consistData = new byte[16];
                int consistMemMim = this.tc.csm.getConsistHeadAddr();
                int consistMemMax = consistMemMim + 256 + 256 + this.tc.csm.getConsistMidSize();
                do {
                    String line = in.readLine();
                    this.consistNumber.setText(Integer.toString(consistNum++));
                    if (line == null) {
                        log.error("NCE consist file terminator :0000 not found");
                        break block24;
                    }
                    log.debug("consist {}", (Object)line);
                    String consistAddr = ":" + Integer.toHexString(curConsist);
                    String[] consistLine = line.split(" ");
                    if (consistLine[0].equalsIgnoreCase(":0000")) {
                        this.fileValid = true;
                        break block24;
                    }
                    int consistMemAddr = Integer.parseUnsignedInt(consistLine[0].replace(":", ""), 16);
                    if (consistMemAddr < consistMemMim) {
                        log.warn("consist mem file out of range, ending restore, got: {} mimimum: {} ", (Object)Integer.toHexString(consistMemAddr), (Object)Integer.toHexString(consistMemMim));
                        this.fileValid = true;
                        break block24;
                    }
                    if (consistMemAddr >= consistMemMax) {
                        log.warn("consist mem file out of range, ending restore, got: {} maximum: {} ", (Object)Integer.toHexString(consistMemAddr), (Object)Integer.toHexString(consistMemMax));
                        this.fileValid = true;
                        break block24;
                    }
                    if (consistMemAddr != curConsist) {
                        log.warn("consist mem file out of range, ending restore, got: {} expected: {} ", (Object)Integer.toHexString(consistMemAddr), (Object)Integer.toHexString(curConsist));
                        this.fileValid = true;
                        break block24;
                    }
                    if (!consistAddr.equalsIgnoreCase(consistLine[0])) {
                        log.error("Restore file selected is not a valid backup file");
                        log.error("Consist memory address in restore file should be {}, read {}", (Object)consistAddr, (Object)consistLine[0]);
                        break block24;
                    }
                    if (curConsist == this.tc.csm.getConsistHeadAddr() && JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("RestoreTakesAwhile"), Bundle.getMessage("NceConsistRestore"), 0) != 0) break block24;
                    fstatus.setVisible(true);
                    for (int i = 0; i < 8; ++i) {
                        int j = i << 1;
                        byte[] b = StringUtil.bytesFromHexString(consistLine[i + 1]);
                        consistData[j] = b[0];
                        consistData[j + 1] = b[1];
                    }
                    NceMessage m = this.writeNceConsistMemory(curConsist, consistData);
                    this.tc.sendNceMessage(m, this);
                    curConsist += 16;
                    if (this.waiting <= 0) continue;
                    NceConsistRestore nceConsistRestore = this;
                    synchronized (nceConsistRestore) {
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                } while (this.waiting <= 0);
                log.error("timeout waiting for reply");
            }
            in.close();
            fstatus.dispose();
            if (this.fileValid) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SuccessfulRestore"), Bundle.getMessage("NceConsistRestore"), 1);
            } else {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("RestoreFailed"), Bundle.getMessage("NceConsistRestore"), 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private NceMessage writeNceConsistMemory(int curConsist, byte[] b) {
        this.replyLen = 1;
        ++this.waiting;
        byte[] bl = NceBinaryCommand.accMemoryWriteN(curConsist, b);
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        log.debug("waiting for {} responses", (Object)this.waiting);
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        --this.waiting;
        if (r.getNumDataElements() != this.replyLen) {
            log.error("reply length incorrect");
            return;
        }
        if (this.replyLen == 1 && r.getElement(0) != NceMessage.NCE_OKAY) {
            log.error("reply incorrect");
        }
        if (this.waiting == 0) {
            NceConsistRestore nceConsistRestore = this;
            synchronized (nceConsistRestore) {
                this.notify();
            }
        }
    }
}

