/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.consist;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.XmlFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrix.nce.consist.NceConsistRosterEntry;
import jmri.util.StringUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceConsistRoster
extends XmlFile
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    protected List<NceConsistRosterEntry> _list = new ArrayList<NceConsistRosterEntry>();
    private boolean dirty = false;
    private static String nceConsistRosterFileName = "ConsistRoster.xml";
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(NceConsistRoster.class);

    public void addEntry(NceConsistRosterEntry e) {
        int i;
        log.debug("Add entry {}", (Object)e);
        for (i = this._list.size() - 1; i >= 0 && e.getId().compareTo(this._list.get(i).getId()) <= 0; --i) {
        }
        this._list.add(i + 1, e);
        this.setDirty(true);
        this.firePropertyChange("add", null, e);
    }

    public void removeEntry(NceConsistRosterEntry e) {
        log.debug("Remove entry {}", (Object)e);
        this._list.remove(e);
        this.setDirty(true);
        this.firePropertyChange("remove", null, e);
    }

    public int numEntries() {
        return this._list.size();
    }

    public JComboBox<String> fullRosterComboBox() {
        return this.matchingComboBox(null, null, null, null, null, null, null, null, null, null);
    }

    public JComboBox<String> matchingComboBox(String roadName, String roadNumber, String consistNumber, String eng1Address, String eng2Address, String eng3Address, String eng4Address, String eng5Address, String eng6Address, String id) {
        List<NceConsistRosterEntry> l = this.matchingList(roadName, roadNumber, consistNumber, eng1Address, eng2Address, eng3Address, eng4Address, eng5Address, eng6Address, id);
        JComboBox<String> b = new JComboBox<String>();
        for (int i = 0; i < l.size(); ++i) {
            NceConsistRosterEntry r = this._list.get(i);
            b.addItem(r.titleString());
        }
        return b;
    }

    public void updateComboBox(JComboBox<String> box) {
        List<NceConsistRosterEntry> l = this.matchingList(null, null, null, null, null, null, null, null, null, null);
        box.removeAllItems();
        for (int i = 0; i < l.size(); ++i) {
            NceConsistRosterEntry r = this._list.get(i);
            box.addItem(r.titleString());
        }
    }

    public NceConsistRosterEntry entryFromTitle(String title) {
        for (int i = 0; i < this.numEntries(); ++i) {
            NceConsistRosterEntry r = this._list.get(i);
            if (!r.titleString().equals(title)) continue;
            return r;
        }
        return null;
    }

    public List<NceConsistRosterEntry> matchingList(String roadName, String roadNumber, String consistNumber, String eng1Address, String eng2Address, String eng3Address, String eng4Address, String eng5Address, String eng6Address, String id) {
        ArrayList<NceConsistRosterEntry> l = new ArrayList<NceConsistRosterEntry>();
        for (int i = 0; i < this.numEntries(); ++i) {
            if (!this.checkEntry(i, roadName, roadNumber, consistNumber, eng1Address, eng2Address, eng3Address, eng4Address, eng5Address, eng6Address, id)) continue;
            l.add(this._list.get(i));
        }
        return l;
    }

    public boolean checkEntry(int i, String roadName, String roadNumber, String consistNumber, String loco1Address, String loco2Address, String loco3Address, String loco4Address, String loco5Address, String loco6Address, String id) {
        NceConsistRosterEntry r = this._list.get(i);
        if (id != null && !id.equals(r.getId())) {
            return false;
        }
        if (roadName != null && !roadName.equals(r.getRoadName())) {
            return false;
        }
        if (roadNumber != null && !roadNumber.equals(r.getRoadNumber())) {
            return false;
        }
        if (consistNumber != null && !consistNumber.equals(r.getConsistNumber())) {
            return false;
        }
        if (loco1Address != null && !loco1Address.equals(r.getLoco1DccAddress())) {
            return false;
        }
        if (loco2Address != null && !loco2Address.equals(r.getLoco2DccAddress())) {
            return false;
        }
        if (loco3Address != null && !loco3Address.equals(r.getLoco3DccAddress())) {
            return false;
        }
        if (loco4Address != null && !loco4Address.equals(r.getLoco4DccAddress())) {
            return false;
        }
        if (loco5Address != null && !loco5Address.equals(r.getLoco5DccAddress())) {
            return false;
        }
        return loco6Address == null || loco6Address.equals(r.getLoco6DccAddress());
    }

    void writeFile(String name) throws FileNotFoundException, IOException {
        int i;
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        Element root = new Element("consist-roster-config");
        Document doc = NceConsistRoster.newDocument(root, this.dtdLocation + "consist-roster-config.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/consistRoster.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        for (int i2 = 0; i2 < this.numEntries(); ++i2) {
            NceConsistRosterEntry r = this._list.get(i2);
            String tempComment = r.getComment();
            StringBuilder buf = new StringBuilder();
            for (int k = 0; k < tempComment.length(); ++k) {
                if (tempComment.startsWith("\n", k)) {
                    buf.append("<?p?>");
                    continue;
                }
                buf.append(tempComment.charAt(k));
            }
            r.setComment(buf.toString());
        }
        Element values = new Element("roster");
        root.addContent((Content)values);
        for (i = 0; i < this.numEntries(); ++i) {
            values.addContent((Content)this._list.get(i).store());
        }
        this.writeXML(file, doc);
        for (i = 0; i < this.numEntries(); ++i) {
            NceConsistRosterEntry r = this._list.get(i);
            String xmlComment = r.getComment();
            StringBuilder buf = new StringBuilder();
            for (int k = 0; k < xmlComment.length(); ++k) {
                if (xmlComment.startsWith("<?p?>", k)) {
                    buf.append("\n");
                    k += 4;
                    continue;
                }
                buf.append(xmlComment.charAt(k));
            }
            r.setComment(buf.toString());
        }
        this.setDirty(false);
    }

    void readFile(String name) throws JDOMException, IOException {
        Element root = this.rootFromName(name);
        if (root == null) {
            log.debug("ConsistRoster file could not be read");
            return;
        }
        if (root.getChild("roster") != null) {
            List l = root.getChild("roster").getChildren("consist");
            if (log.isDebugEnabled()) {
                log.debug("readFile sees {} children", (Object)l.size());
            }
            for (Element element : l) {
                this.addEntry(new NceConsistRosterEntry(element));
            }
            for (int i = 0; i < this.numEntries(); ++i) {
                NceConsistRosterEntry r = this._list.get(i);
                String tempComment = r.getComment();
                StringBuilder buf = new StringBuilder();
                for (int k = 0; k < tempComment.length(); ++k) {
                    if (tempComment.startsWith("<?p?>", k)) {
                        buf.append("\n");
                        k += 4;
                        continue;
                    }
                    buf.append(tempComment.charAt(k));
                }
                r.setComment(buf.toString());
            }
        } else {
            log.error("Unrecognized ConsistRoster file contents in file: {}", (Object)name);
        }
    }

    void setDirty(boolean b) {
        this.dirty = b;
    }

    boolean isDirty() {
        return this.dirty;
    }

    public void dispose() {
        log.debug("dispose");
        if (this.dirty) {
            log.error("Dispose invoked on dirty ConsistRoster");
        }
    }

    public void writeRosterFile() {
        this.makeBackupFile(NceConsistRoster.defaultNceConsistRosterFilename());
        try {
            this.writeFile(NceConsistRoster.defaultNceConsistRosterFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new ConsistRoster file, may not be complete: {}", (Object)e.getMessage());
        }
    }

    public void reloadRosterFile() {
        this._list.clear();
        try {
            this.readFile(NceConsistRoster.defaultNceConsistRosterFilename());
        }
        catch (IOException | JDOMException e) {
            log.error("Exception during ConsistRoster reading: {}", (Object)e.getMessage());
        }
    }

    public static String defaultNceConsistRosterFilename() {
        return Roster.getDefault().getRosterLocation() + nceConsistRosterFileName;
    }

    public static void setNceConsistRosterFileName(String name) {
        nceConsistRosterFileName = name;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void entryIdChanged(NceConsistRosterEntry r) {
        int i;
        log.debug("EntryIdChanged");
        Object[] rarray = new NceConsistRosterEntry[this._list.size()];
        for (i = 0; i < rarray.length; ++i) {
            rarray[i] = this._list.get(i);
        }
        StringUtil.sortUpperCase(rarray);
        for (i = 0; i < rarray.length; ++i) {
            this._list.set(i, (NceConsistRosterEntry)rarray[i]);
        }
        this.firePropertyChange("change", null, r);
    }

    @Override
    public void initialize() {
        if (this.checkFile(NceConsistRoster.defaultNceConsistRosterFilename())) {
            try {
                this.readFile(NceConsistRoster.defaultNceConsistRosterFilename());
            }
            catch (IOException | JDOMException e) {
                log.error("Exception during ConsistRoster reading: {}", (Object)e.getMessage());
            }
        }
    }
}

