/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.macro;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.macro.Bundle;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class NceMacroGenPanel
extends NcePanel
implements NceListener {
    JLabel jLabel1 = new JLabel(Bundle.getMessage("MacroLabel"));
    JLabel macroText = new JLabel(Bundle.getMessage("ReplyLabel"));
    JLabel macroReply = new JLabel();
    JButton sendButton = new JButton(Bundle.getMessage("Send"));
    JTextField packetTextField = new JTextField(4);
    JLabel space1 = new JLabel("                  ");
    JLabel space3 = new JLabel("                       ");
    private NceTrafficController tc = null;

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.macro.NceMacroEditFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("TitleNceMacroGen"));
        return x.toString();
    }

    @Override
    public Dimension getMinimumDimension() {
        return new Dimension(200, 200);
    }

    @Override
    public void initComponents(NceSystemConnectionMemo memo) {
        this.memo = memo;
        this.tc = memo.getNceTrafficController();
        this.macroReply.setText(Bundle.getMessage("unknown"));
        this.sendButton.setToolTipText(Bundle.getMessage("toolTipExecuteMacro"));
        this.packetTextField.setToolTipText(Bundle.getMessage("toolTipEnterMacro", 255));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(300, 100));
        this.addItem(this.jLabel1, 0, 0);
        this.addItem(this.packetTextField, 2, 0);
        this.addItem(this.macroText, 0, 1);
        this.addItem(this.macroReply, 2, 1);
        this.addItem(this.space3, 2, 2);
        this.addItem(this.sendButton, 0, 3);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NceMacroGenPanel.this.sendButtonActionPerformed(e);
            }
        });
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        NceMessage m = this.createMacroCmd(input);
        if (m == null) {
            this.macroReply.setText(Bundle.getMessage("error"));
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("EnterMacroNumber", 255), Bundle.getMessage("NceMacro"), 0);
            return;
        }
        this.macroReply.setText(Bundle.getMessage("waiting"));
        this.tc.sendNceMessage(m, this);
        NceMessage m2 = this.createOldMacroCmd(input);
        this.tc.sendNceMessage(m2, this);
    }

    @Override
    public void message(NceMessage m) {
    }

    @Override
    public void reply(NceReply r) {
        if (r.getNumDataElements() == 1) {
            int recChar = r.getElement(0);
            if (recChar == NceMessage.NCE_OKAY) {
                this.macroReply.setText(Bundle.getMessage("okay"));
            }
            if (recChar == 48) {
                this.macroReply.setText(Bundle.getMessage("macroEmpty"));
            }
        } else {
            this.macroReply.setText(Bundle.getMessage("error"));
        }
    }

    NceMessage createMacroCmd(String s) {
        int macroNum = 0;
        try {
            macroNum = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (macroNum < 0 || macroNum > 255) {
            return null;
        }
        if (this.tc.getCommandOptions() >= 20) {
            NceMessage m = new NceMessage(5);
            m.setElement(0, 173);
            m.setElement(1, 0);
            m.setElement(2, 1);
            m.setElement(3, 1);
            m.setElement(4, macroNum);
            m.setBinary(true);
            m.setReplyLen(1);
            return m;
        }
        NceMessage m = new NceMessage(2);
        m.setElement(0, 156);
        m.setElement(1, macroNum);
        m.setBinary(true);
        m.setReplyLen(1);
        return m;
    }

    NceMessage createOldMacroCmd(String s) {
        int macroNum = 0;
        try {
            macroNum = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (macroNum < 0 || macroNum > 255) {
            return null;
        }
        NceMessage m = new NceMessage(2);
        m.setElement(0, 156);
        m.setElement(1, macroNum);
        m.setBinary(true);
        m.setReplyLen(1);
        return m;
    }

    private void addItem(JComponent c, int x, int y) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        this.add((Component)c, gc);
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE Send Macro Window", (WindowInterface)new JmriJFrameInterface(), NceMacroGenPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }
}

