/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.macro;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrix.nce.NceBinaryCommand;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.macro.Bundle;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.TextFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMacroRestore
extends Thread
implements NceListener {
    private int cs_macro_mem;
    private static final int MACRO_LNTH = 20;
    private static final int REPLY_1 = 1;
    private int replyLen = 0;
    private int waiting = 0;
    private boolean fileValid = false;
    JLabel textMacro = new JLabel();
    JLabel macroNumber = new JLabel();
    private final NceTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(NceMacroRestore.class);

    public NceMacroRestore(NceTrafficController t) {
        this.tc = t;
        this.cs_macro_mem = this.tc.csm.getMacroAddr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JmriJFileChooser fc = new JmriJFileChooser(FileUtil.getUserFilesPath());
        fc.addChoosableFileFilter(new TextFilter());
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return;
        }
        if (fc.getSelectedFile() == null) {
            return;
        }
        File f = fc.getSelectedFile();
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            JmriJFrame fstatus;
            block25: {
                JPanel ps = new JPanel();
                fstatus = new JmriJFrame(Bundle.getMessage("RestoreTitle"));
                fstatus.setLocationRelativeTo(null);
                fstatus.setSize(200, 100);
                fstatus.getContentPane().add(ps);
                ps.add(this.textMacro);
                ps.add(this.macroNumber);
                this.textMacro.setText(Bundle.getMessage("MacroNumberLabel"));
                this.textMacro.setVisible(true);
                this.macroNumber.setVisible(true);
                this.waiting = 0;
                this.fileValid = false;
                int macroNum = 0;
                int curMacro = this.cs_macro_mem;
                byte[] macroAccy = new byte[20];
                int macroMemMim = this.tc.csm.getMacroAddr();
                int macroMemMax = macroMemMim + this.tc.csm.getMacroSize() * this.tc.csm.getMacroLimit();
                do {
                    String line;
                    try {
                        line = in.readLine();
                    }
                    catch (IOException e) {
                        break block25;
                    }
                    this.macroNumber.setText(Integer.toString(macroNum++));
                    if (line == null) {
                        log.error("NCE macro file terminator :0000 not found");
                        break block25;
                    }
                    log.debug("macro {}", (Object)line);
                    String macroAddr = ":" + Integer.toHexString(curMacro);
                    String[] macroLine = line.split(" ");
                    if (macroLine[0].equalsIgnoreCase(":0000")) {
                        this.fileValid = true;
                        break block25;
                    }
                    if (!macroAddr.equalsIgnoreCase(macroLine[0])) {
                        log.error("Restore file selected is not a vaild backup file");
                        log.error("Macro addr in restore file should be {} Macro addr read {}", (Object)macroAddr, (Object)macroLine[0]);
                        break block25;
                    }
                    int macroMemAddr = Integer.parseUnsignedInt(macroLine[0].replace(":", ""), 16);
                    if (macroMemAddr < macroMemMim) {
                        log.warn("macro mem file out of range, ending restore, got: {} mimimum: {} ", (Object)Integer.toHexString(macroMemAddr), (Object)Integer.toHexString(macroMemMim));
                        this.fileValid = false;
                        break block25;
                    }
                    if (macroMemAddr >= macroMemMax) {
                        log.warn("macro mem file out of range, ending restore, got: {} maximum: {} ", (Object)Integer.toHexString(macroMemAddr), (Object)Integer.toHexString(macroMemMax));
                        this.fileValid = false;
                        break block25;
                    }
                    if (curMacro == this.cs_macro_mem && JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("dialogRestoreTime"), Bundle.getMessage("RestoreTitle"), 0) != 0) break block25;
                    fstatus.setVisible(true);
                    for (int i = 0; i < 10; ++i) {
                        int j = i << 1;
                        byte[] b = StringUtil.bytesFromHexString(macroLine[i + 1]);
                        macroAccy[j] = b[0];
                        macroAccy[j + 1] = b[1];
                    }
                    NceMessage m = this.writeNceMacroMemory(curMacro, macroAccy, false);
                    this.tc.sendNceMessage(m, this);
                    m = this.writeNceMacroMemory(curMacro, macroAccy, true);
                    this.tc.sendNceMessage(m, this);
                    curMacro += 20;
                    if (this.waiting <= 0) continue;
                    NceMacroRestore nceMacroRestore = this;
                    synchronized (nceMacroRestore) {
                        try {
                            this.wait(20000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                } while (this.waiting <= 0);
                log.error("timeout waiting for reply");
            }
            in.close();
            fstatus.dispose();
            if (this.fileValid) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("dialogRestoreSuccess"), Bundle.getMessage("RestoreTitle"), 1);
            } else {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("dialogRestoreFailed"), Bundle.getMessage("RestoreTitle"), 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private NceMessage writeNceMacroMemory(int curMacro, byte[] b, boolean second) {
        byte[] bl;
        byte[] data;
        this.replyLen = 1;
        ++this.waiting;
        if (second) {
            curMacro += 16;
            data = new byte[4];
            for (int i = 0; i < 4; ++i) {
                data[i] = b[i + 16];
            }
            bl = NceBinaryCommand.accMemoryWrite4(curMacro, data);
        } else {
            data = new byte[16];
            for (int i = 0; i < 16; ++i) {
                data[i] = b[i];
            }
            bl = NceBinaryCommand.accMemoryWriteN(curMacro, data);
        }
        NceMessage m = NceMessage.createBinaryMessage(this.tc, bl, 1);
        return m;
    }

    @Override
    public void message(NceMessage m) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void reply(NceReply r) {
        log.debug("waiting for {} responses ", (Object)this.waiting);
        if (this.waiting <= 0) {
            log.error("unexpected response");
            return;
        }
        --this.waiting;
        if (r.getNumDataElements() != this.replyLen) {
            log.error("reply length incorrect");
            return;
        }
        if (this.replyLen == 1 && r.getElement(0) != NceMessage.NCE_OKAY) {
            log.error("reply incorrect");
        }
        if (this.waiting == 0) {
            NceMacroRestore nceMacroRestore = this;
            synchronized (nceMacroRestore) {
                this.notify();
            }
        }
    }
}

