/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.ncemon;

import java.text.MessageFormat;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.ncemon.Bundle;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NceMonBinary {
    private static final Logger log = LoggerFactory.getLogger(NceMonBinary.class);
    private static final int REPLY_UNKNOWN = 0;
    private static final int REPLY_STANDARD = 1;
    private static final int REPLY_DATA = 2;
    private static final int REPLY_ENTER_PROGRAMMING_MODE = 3;
    private static final int REPLY_ZERO = 48;
    private static final int REPLY_ONE = 49;
    private static final int REPLY_TWO = 50;
    private static final int REPLY_THREE = 51;
    private static final int REPLY_FOUR = 52;
    private static final int REPLY_OK = 33;
    private int replyType = 0;

    public String displayMessage(NceMessage m) {
        return this.parseMessage(m);
    }

    private String parseMessage(NceMessage m) {
        this.replyType = 1;
        switch (m.getOpCode() & 0xFF) {
            case 128: {
                return Bundle.getMessage("NOP_CMD");
            }
            case 131: {
                return Bundle.getMessage("STOP_CLOCK_CMD");
            }
            case 132: {
                return Bundle.getMessage("START_CLOCK_CMD");
            }
            case 133: {
                if (m.getNumDataElements() != 3) break;
                return MessageFormat.format(Bundle.getMessage("SET_CLOCK_CMD"), m.getElement(1), m.getElement(2));
            }
            case 134: {
                if (m.getNumDataElements() != 2) break;
                String hr = "12";
                if (m.getElement(1) == 1) {
                    hr = "24";
                }
                return MessageFormat.format(Bundle.getMessage("CLOCK_1224_CMD"), hr);
            }
            case 135: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("CLOCK_RATIO_CMD"), m.getElement(1));
            }
            case 137: {
                return Bundle.getMessage("ENABLE_MAIN_CMD");
            }
            case 139: {
                return Bundle.getMessage("KILL_MAIN_CMD");
            }
            case 142: {
                if (m.getNumDataElements() != 20) break;
                return MessageFormat.format(Bundle.getMessage("WRITEn_CMD"), m.getElement(3), this.getAddress(m), this.getDataBytes(m, 4, 16));
            }
            case 147: {
                if (m.getNumDataElements() != 5) break;
                return MessageFormat.format(Bundle.getMessage("SENDn_BYTES_CMD"), "3", m.getElement(1), this.getDataBytes(m, 2, 3));
            }
            case 148: {
                if (m.getNumDataElements() != 6) break;
                return MessageFormat.format(Bundle.getMessage("SENDn_BYTES_CMD"), "4", m.getElement(1), this.getDataBytes(m, 2, 4));
            }
            case 149: {
                if (m.getNumDataElements() != 7) break;
                return MessageFormat.format(Bundle.getMessage("SENDn_BYTES_CMD"), "5", m.getElement(1), this.getDataBytes(m, 2, 5));
            }
            case 150: {
                if (m.getNumDataElements() != 8) break;
                return MessageFormat.format(Bundle.getMessage("SENDn_BYTES_CMD"), "6", m.getElement(1), this.getDataBytes(m, 2, 6));
            }
            case 151: {
                if (m.getNumDataElements() != 4) break;
                return MessageFormat.format(Bundle.getMessage("WRITE1_CMD"), this.getAddress(m), this.getDataBytes(m, 3, 1));
            }
            case 152: {
                if (m.getNumDataElements() != 5) break;
                return MessageFormat.format(Bundle.getMessage("WRITE2_CMD"), this.getAddress(m), this.getDataBytes(m, 3, 2));
            }
            case 153: {
                if (m.getNumDataElements() != 7) break;
                return MessageFormat.format(Bundle.getMessage("WRITE4_CMD"), this.getAddress(m), this.getDataBytes(m, 3, 4));
            }
            case 154: {
                if (m.getNumDataElements() != 11) break;
                return MessageFormat.format(Bundle.getMessage("WRITE8_CMD"), this.getAddress(m), this.getDataBytes(m, 3, 8));
            }
            case 156: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("MACRO_CMD"), m.getElement(1));
            }
            case 158: {
                this.replyType = 3;
                return Bundle.getMessage("ENTER_PROG_CMD");
            }
            case 159: {
                return Bundle.getMessage("EXIT_PROG_CMD");
            }
            case 160: {
                if (m.getNumDataElements() != 4) break;
                return MessageFormat.format(Bundle.getMessage("WRITE_PAGED_CV_CMD"), this.getNumber(m), this.getDataBytes(m, 3, 1));
            }
            case 162: {
                if (m.getNumDataElements() != 5) break;
                switch (m.getElement(3)) {
                    case 0: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_00"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 1: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_01"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 2: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_02"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 3: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_03"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 4: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_04"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 5: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_05"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 6: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_06"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 7: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_07"), this.getLocoAddress(m), m.getElement(4), this.getFunctionNumber(m));
                    }
                    case 8: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_08"), this.getLocoAddress(m), m.getElement(4), this.getFunctionNumber(m));
                    }
                    case 9: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_09"), this.getLocoAddress(m), m.getElement(4), this.getFunctionNumber(m));
                    }
                    case 10: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_0A"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 11: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_0B"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 12: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_0C"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 13: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_0D"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 14: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_0E"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 15: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_0F"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 16: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_10"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 17: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_11"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 18: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_12"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 21: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_15"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 22: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_16"), this.getLocoAddress(m), m.getElement(4));
                    }
                    case 23: {
                        return MessageFormat.format(Bundle.getMessage("LOCO_CMD_Op1_17"), this.getLocoAddress(m), m.getElement(4));
                    }
                }
                log.error("Unhandled loco cmd op1 code: {}", (Object)m.getElement(3));
                break;
            }
            case 163: {
                if (m.getNumDataElements() != 5) break;
                return MessageFormat.format(Bundle.getMessage("QUEUEn_BYTES_CMD"), "3", m.getElement(1), this.getDataBytes(m, 2, 3));
            }
            case 164: {
                if (m.getNumDataElements() != 6) break;
                return MessageFormat.format(Bundle.getMessage("QUEUEn_BYTES_CMD"), "4", m.getElement(1), this.getDataBytes(m, 2, 4));
            }
            case 165: {
                if (m.getNumDataElements() != 7) break;
                return MessageFormat.format(Bundle.getMessage("QUEUEn_BYTES_CMD"), "5", m.getElement(1), this.getDataBytes(m, 2, 5));
            }
            case 166: {
                if (m.getNumDataElements() != 3) break;
                return MessageFormat.format(Bundle.getMessage("WRITE_REG_CMD"), m.getElement(1), this.getDataBytes(m, 2, 1));
            }
            case 168: {
                if (m.getNumDataElements() != 4) break;
                return MessageFormat.format(Bundle.getMessage("WRITE_DIR_CV_CMD"), this.getNumber(m), this.getDataBytes(m, 3, 1));
            }
            case 173: {
                if (m.getNumDataElements() != 5) break;
                switch (m.getElement(3)) {
                    case 1: {
                        return MessageFormat.format(Bundle.getMessage("ACC_CMD_Op1_01"), m.getElement(4));
                    }
                    case 3: {
                        return MessageFormat.format(Bundle.getMessage("ACC_CMD_Op1_03"), this.getNumber(m));
                    }
                    case 4: {
                        return MessageFormat.format(Bundle.getMessage("ACC_CMD_Op1_04"), this.getNumber(m));
                    }
                    case 5: {
                        return MessageFormat.format(Bundle.getMessage("ACC_CMD_Op1_05"), this.getNumber(m), m.getElement(4));
                    }
                }
                log.error("Unhandled acc cmd op1 code: {}", (Object)m.getElement(3));
                break;
            }
            case 177: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("Usb_Set_Cab_Op1"), m.getElement(1));
            }
            case 179: {
                if (m.getNumDataElements() != 3) break;
                return MessageFormat.format(Bundle.getMessage("Usb_Set_Mem_Ptr_Cmd"), m.getElement(1), m.getElement(2));
            }
            case 180: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("Usb_Mem_Write_Cmd"), m.getElement(1));
            }
        }
        this.replyType = 2;
        switch (m.getOpCode() & 0xFF) {
            case 130: {
                return Bundle.getMessage("READ_CLOCK_CMD");
            }
            case 138: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("READ_AUI4_CMD"), m.getElement(1));
            }
            case 140: {
                return Bundle.getMessage("DUMMY_CMD");
            }
            case 143: {
                if (m.getNumDataElements() != 3) break;
                return MessageFormat.format(Bundle.getMessage("READ16_CMD"), this.getAddress(m));
            }
            case 181: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("Usb_Mem_Read_Cmd"), m.getElement(1));
            }
            case 155: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("READ_AUI2_CMD"), m.getElement(1));
            }
            case 157: {
                if (m.getNumDataElements() != 3) break;
                return MessageFormat.format(Bundle.getMessage("READ1_CMD"), this.getAddress(m));
            }
            case 161: {
                if (m.getNumDataElements() != 3) break;
                return MessageFormat.format(Bundle.getMessage("READ_PAGED_CV_CMD"), this.getNumber(m));
            }
            case 167: {
                if (m.getNumDataElements() != 2) break;
                return MessageFormat.format(Bundle.getMessage("READ_REG_CMD"), m.getElement(1));
            }
            case 169: {
                if (m.getNumDataElements() != 3) break;
                return MessageFormat.format(Bundle.getMessage("READ_DIR_CV_CMD"), this.getNumber(m));
            }
            case 170: {
                return Bundle.getMessage("SW_REV_CMD");
            }
            default: {
                log.debug("Unhandled command code: {} after 2nd pass", (Object)Integer.toHexString(m.getOpCode() & 0xFF));
            }
        }
        this.replyType = 0;
        log.debug("Unhandled command code: {}, display as raw", (Object)Integer.toHexString(m.getOpCode() & 0xFF));
        return MessageFormat.format(Bundle.getMessage("BIN_CMD"), m.toString());
    }

    private String getAddress(NceMessage m) {
        return StringUtil.twoHexFromInt(m.getElement(1)) + StringUtil.twoHexFromInt(m.getElement(2));
    }

    private String getDataBytes(NceMessage m, int start, int number) {
        StringBuilder sb = new StringBuilder(" ");
        for (int i = start; i < start + number; ++i) {
            sb.append(StringUtil.twoHexFromInt(m.getElement(i))).append(" ");
        }
        return sb.toString();
    }

    private String getNumber(NceMessage m) {
        return Integer.toString((m.getElement(1) & 0xFF) << 8 | m.getElement(2) & 0xFF);
    }

    private String getLocoAddress(NceMessage m) {
        String appendix = " (short)";
        if ((m.getElement(1) & 0xE0) != 0) {
            appendix = " (long)";
        }
        return Integer.toString((m.getElement(1) & 0x3F) << 8 | m.getElement(2) & 0xFF) + appendix;
    }

    private String getFunctionNumber(NceMessage m) {
        switch (m.getElement(3)) {
            case 7: {
                StringBuilder buf = new StringBuilder();
                if ((m.getElement(4) & 0x10) != 0) {
                    buf.append(Bundle.getMessage("F0_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F0_OFF")).append(", ");
                }
                if ((m.getElement(4) & 1) != 0) {
                    buf.append(Bundle.getMessage("F1_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F1_OFF")).append(", ");
                }
                if ((m.getElement(4) & 2) != 0) {
                    buf.append(Bundle.getMessage("F2_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F2_OFF")).append(", ");
                }
                if ((m.getElement(4) & 4) != 0) {
                    buf.append(Bundle.getMessage("F3_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F3_OFF")).append(", ");
                }
                if ((m.getElement(4) & 8) != 0) {
                    buf.append(Bundle.getMessage("F4_ON"));
                } else {
                    buf.append(Bundle.getMessage("F4_OFF"));
                }
                return buf.toString();
            }
            case 8: {
                StringBuilder buf = new StringBuilder();
                if ((m.getElement(4) & 1) != 0) {
                    buf.append(Bundle.getMessage("F5_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F5_OFF")).append(", ");
                }
                if ((m.getElement(4) & 2) != 0) {
                    buf.append(Bundle.getMessage("F6_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F6_OFF")).append(", ");
                }
                if ((m.getElement(4) & 4) != 0) {
                    buf.append(Bundle.getMessage("F7_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F7_OFF")).append(", ");
                }
                if ((m.getElement(4) & 8) != 0) {
                    buf.append(Bundle.getMessage("F8_ON"));
                } else {
                    buf.append(Bundle.getMessage("F8_OFF"));
                }
                return buf.toString();
            }
            case 9: {
                StringBuilder buf = new StringBuilder();
                if ((m.getElement(4) & 1) != 0) {
                    buf.append(Bundle.getMessage("F9_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F9_OFF")).append(", ");
                }
                if ((m.getElement(4) & 2) != 0) {
                    buf.append(Bundle.getMessage("F10_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F10_OFF")).append(", ");
                }
                if ((m.getElement(4) & 4) != 0) {
                    buf.append(Bundle.getMessage("F11_ON")).append(", ");
                } else {
                    buf.append(Bundle.getMessage("F11_OFF")).append(", ");
                }
                if ((m.getElement(4) & 8) != 0) {
                    buf.append(Bundle.getMessage("F12_ON"));
                } else {
                    buf.append(Bundle.getMessage("F12_OFF"));
                }
                return buf.toString();
            }
        }
        return "Error";
    }

    public String displayReply(NceReply r) {
        return this.parseReply(r);
    }

    private String parseReply(NceReply r) {
        switch (this.replyType) {
            case 1: {
                if (r.getNumDataElements() != 1) break;
                switch (r.getOpCode() & 0xFF) {
                    case 48: {
                        return Bundle.getMessage("NceReplyZero");
                    }
                    case 49: {
                        return Bundle.getMessage("NceReplyOne");
                    }
                    case 50: {
                        return Bundle.getMessage("NceReplyTwo");
                    }
                    case 51: {
                        return Bundle.getMessage("NceReplyThree");
                    }
                    case 52: {
                        return Bundle.getMessage("NceReplyFour");
                    }
                    case 33: {
                        return Bundle.getMessage("NceReplyOK");
                    }
                }
                log.error("Unhandled reply code: {}", (Object)Integer.toHexString(r.getOpCode() & 0xFF));
                break;
            }
            case 3: {
                if (r.getNumDataElements() != 1) break;
                switch (r.getOpCode() & 0xFF) {
                    case 51: {
                        return Bundle.getMessage("NceReplyThreeProg");
                    }
                    case 33: {
                        return Bundle.getMessage("NceReplyOK");
                    }
                }
                log.error("Unhandled programming reply code: {}", (Object)Integer.toHexString(r.getOpCode() & 0xFF));
                break;
            }
            case 2: {
                break;
            }
            default: {
                log.debug("Unhandled reply type code1: {}, display as raw", (Object)this.replyType);
            }
        }
        return MessageFormat.format(Bundle.getMessage("NceReply"), r.toString());
    }
}

