/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrix.nce.NceListener;
import jmri.jmrix.nce.NceMessage;
import jmri.jmrix.nce.NceReply;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.packetgen.Bundle;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanel;
import jmri.util.StringUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;

public class NcePacketGenPanel
extends NcePanel
implements NceListener {
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(20);
    JCheckBox checkBoxBinCmd = new JCheckBox();
    JTextField replyLenTextField = new JTextField(2);
    private NceTrafficController tc = null;

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.packetgen.NcePacketGenFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("Title"));
        return x.toString();
    }

    @Override
    public Dimension getMinimumDimension() {
        return new Dimension(200, 200);
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        this.memo = m;
        this.tc = m.getNceTrafficController();
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("MenuItemSendCommand"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.checkBoxBinCmd.setText(Bundle.getMessage("Binary"));
        this.checkBoxBinCmd.setVisible(true);
        this.checkBoxBinCmd.setToolTipText(Bundle.getMessage("TooltipBinary"));
        this.checkBoxBinCmd.setSelected(true);
        this.jLabel2.setText(Bundle.getMessage("BytesLabel"));
        this.jLabel2.setVisible(true);
        this.replyLenTextField.setVisible(true);
        this.replyLenTextField.setMaximumSize(new Dimension(50, this.replyLenTextField.getPreferredSize().height));
        this.replyLenTextField.setToolTipText(Bundle.getMessage("TooltipExpectedBytes"));
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(300, 150));
        JPanel command = new JPanel();
        command.setLayout(new BoxLayout(command, 0));
        command.add(this.jLabel1);
        command.add(this.packetTextField);
        JPanel bytes = new JPanel();
        bytes.setLayout(new BoxLayout(bytes, 0));
        bytes.add(this.jLabel2);
        bytes.add(this.replyLenTextField);
        this.add(command);
        this.add(this.checkBoxBinCmd);
        this.add(bytes);
        this.add(this.sendButton);
        this.sendButton.addActionListener(this::sendButtonActionPerformed);
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        if (this.checkBoxBinCmd.isSelected()) {
            NceMessage m = this.createPacket(input);
            if (m == null) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DialogHexOnly"), Bundle.getMessage("BinaryTitle"), 0);
                return;
            }
            m.setBinary(true);
            int replyLen = this.getReplyLen(this.replyLenTextField.getText());
            if (replyLen > 0) {
                m.setReplyLen(replyLen);
            } else {
                m.setReplyLen(this.getMessageLength(m.getOpCode()));
            }
            this.tc.sendNceMessage(m, this);
        } else {
            NceMessage m = new NceMessage(input.length());
            for (int i = 0; i < input.length(); ++i) {
                m.setElement(i, input.charAt(i));
            }
            this.tc.sendNceMessage(m, this);
        }
    }

    @Override
    public void message(NceMessage m) {
    }

    @Override
    public void reply(NceReply r) {
    }

    NceMessage createPacket(String s) {
        byte[] b;
        try {
            b = StringUtil.bytesFromHexString(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (b.length == 0) {
            return null;
        }
        NceMessage m = new NceMessage(b.length);
        for (int i = 0; i < b.length; ++i) {
            m.setElement(i, b[i]);
        }
        return m;
    }

    private int getReplyLen(String s) {
        int b;
        try {
            b = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return b;
    }

    private int getMessageLength(int opcode) {
        int replyLen;
        switch (opcode & 0xFF) {
            case 171: 
            case 172: {
                replyLen = 0;
                break;
            }
            case 130: 
            case 155: 
            case 161: 
            case 167: 
            case 169: {
                replyLen = 2;
                break;
            }
            case 140: 
            case 170: {
                replyLen = 3;
                break;
            }
            case 138: {
                replyLen = 4;
                break;
            }
            case 143: {
                replyLen = 16;
                break;
            }
            default: {
                replyLen = 1;
            }
        }
        return replyLen;
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE Send Binary Command", (WindowInterface)new JmriJFrameInterface(), NcePacketGenPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }
}

