/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.ph5driver;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.nce.NcePortController;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.ph5driver.Bundle;
import jmri.jmrix.nce.ph5driver.Ph5CmdStationMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ph5DriverAdapter
extends NcePortController {
    private String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600")};
    private int[] validSpeedValues = new int[]{9600};
    private static final Logger log = LoggerFactory.getLogger(Ph5DriverAdapter.class);

    public Ph5DriverAdapter() {
        super(new NceSystemConnectionMemo());
        this.option1Name = "Eprom";
        this.options.put(this.option1Name, new AbstractPortController.Option("Command Station EPROM", new String[]{"2023 or later"}));
        this.setManufacturer("NCE");
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("{}: failed to connect PH5 to {}", (Object)this.manufacturerName, (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("{}: Connecting PH5 to {} {}", new Object[]{this.manufacturerName, portName, this.currentSerialPort});
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        NceTrafficController tc = new NceTrafficController();
        this.getSystemConnectionMemo().setNceTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureCommandStation(80);
        this.getSystemConnectionMemo().setNceCmdGroups(-65L);
        tc.csm = new Ph5CmdStationMemory();
        tc.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

