/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.serialdriver;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.nce.NceCmdStationMemory;
import jmri.jmrix.nce.NcePortController;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialDriverAdapter
extends NcePortController {
    private String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600")};
    private int[] validSpeedValues = new int[]{9600};
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new NceSystemConnectionMemo());
        this.option1Name = "Eprom";
        this.options.put(this.option1Name, new AbstractPortController.Option("Command Station EPROM", new String[]{"2006 or later", "2004 or earlier"}));
        this.setManufacturer("NCE");
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("{}: failed to connect NCE to {}", (Object)this.getUserName(), (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("{}: Connecting serial to {} {}", new Object[]{this.getUserName(), portName, this.currentSerialPort});
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        NceTrafficController tc = new NceTrafficController();
        this.getSystemConnectionMemo().setNceTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[0])) {
            this.getSystemConnectionMemo().configureCommandStation(20);
            this.getSystemConnectionMemo().setNceCmdGroups(-65L);
        } else {
            this.getSystemConnectionMemo().configureCommandStation(10);
            this.getSystemConnectionMemo().setNceCmdGroups(-65L);
        }
        tc.csm = new NceCmdStationMemory();
        tc.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

