/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.nce.usbdriver;

import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.nce.NcePortController;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.NceTrafficController;
import jmri.jmrix.nce.usbdriver.Bundle;
import jmri.jmrix.nce.usbdriver.UsbCmdStationMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbDriverAdapter
extends NcePortController {
    String[] option1Values = new String[]{"PowerCab", "SB3/SB3a", "Power Pro", "Twin", "SB5"};
    String[] option2Values = new String[]{"V6.x.x", "V7.x.x"};
    private String[] validSpeeds = new String[]{Bundle.getMessage("Baud9600"), Bundle.getMessage("Baud19200")};
    private int[] validSpeedValues = new int[]{9600, 19200};
    private static final Logger log = LoggerFactory.getLogger(UsbDriverAdapter.class);

    public UsbDriverAdapter() {
        super(new NceSystemConnectionMemo());
        this.option1Name = "System";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("SystemLabel"), this.option1Values, false));
        this.option2Name = "USB Version";
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("UsbVersionLabel"), this.option2Values, false));
        this.setOptionState(this.option2Name, this.getOptionChoices(this.option2Name)[1]);
    }

    @Override
    public String openPort(String portName, String appName) {
        this.currentSerialPort = this.activatePort(portName, log);
        if (this.currentSerialPort == null) {
            log.error("{}: failed to connect NCE USB to {}", (Object)this.manufacturerName, (Object)portName);
            return Bundle.getMessage("SerialPortNotFound", portName);
        }
        log.info("{}: Connecting NCE USB to {} {}", new Object[]{this.manufacturerName, portName, this.currentSerialPort});
        int baud = this.currentBaudNumber(this.mBaudRate);
        this.setBaudRate(this.currentSerialPort, baud);
        this.configureLeads(this.currentSerialPort, true, true);
        this.setFlowControl(this.currentSerialPort, AbstractSerialPortController.FlowControl.NONE);
        this.reportPortStatus(log, portName);
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        log.trace("configure with {}", (Object)this.getSystemConnectionMemo());
        NceTrafficController tc = new NceTrafficController();
        this.getSystemConnectionMemo().setNceTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        if (this.getOptionState(this.option2Name).equals(this.getOptionChoices(this.option2Name)[1])) {
            if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[4])) {
                tc.setUsbSystem(5);
                tc.setCmdGroups(348L);
                this.getSystemConnectionMemo().configureCommandStation(40);
            } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[3])) {
                tc.setUsbSystem(4);
                tc.setCmdGroups(350L);
                this.getSystemConnectionMemo().configureCommandStation(40);
            } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[2])) {
                tc.setUsbSystem(3);
                tc.setCmdGroups(320L);
                this.getSystemConnectionMemo().configureCommandStation(20);
            } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[1])) {
                tc.setUsbSystem(2);
                tc.setCmdGroups(336L);
                this.getSystemConnectionMemo().configureCommandStation(30);
            } else {
                tc.setUsbSystem(1);
                tc.setCmdGroups(350L);
                this.getSystemConnectionMemo().configureCommandStation(40);
            }
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[4])) {
            tc.setUsbSystem(5);
            tc.setCmdGroups(336L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[3])) {
            tc.setUsbSystem(4);
            tc.setCmdGroups(336L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[2])) {
            tc.setUsbSystem(3);
            tc.setCmdGroups(320L);
            this.getSystemConnectionMemo().configureCommandStation(20);
        } else if (this.getOptionState(this.option1Name).equals(this.getOptionChoices(this.option1Name)[1])) {
            tc.setUsbSystem(2);
            tc.setCmdGroups(337L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        } else {
            tc.setUsbSystem(1);
            tc.setCmdGroups(338L);
            this.getSystemConnectionMemo().configureCommandStation(30);
        }
        tc.csm = new UsbCmdStationMemory();
        tc.connectPort(this);
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

