/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.ncemonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrix.AbstractMonPane;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.SerialPort;
import jmri.jmrix.nce.NceSystemConnectionMemo;
import jmri.jmrix.nce.swing.NceNamedPaneAction;
import jmri.jmrix.nce.swing.NcePanelInterface;
import jmri.jmrix.ncemonitor.Bundle;
import jmri.util.swing.WindowInterface;
import jmri.util.swing.sdi.JmriJFrameInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="serialStream is access from separate thread, and this class isn't used much")
public class NcePacketMonitorPanel
extends AbstractMonPane
implements NcePanelInterface {
    Vector<String> portNameVector = null;
    SerialPort activeSerialPort = null;
    NceSystemConnectionMemo memo = null;
    protected JCheckBox dupFilterCheckBox = new JCheckBox(Bundle.getMessage("DupFilterCheckBoxLabel"));
    protected JComboBox<String> portBox = new JComboBox();
    protected JButton openButton = new JButton(Bundle.getMessage("OpenButtonLabel"));
    protected JButton closePortButton = new JButton(Bundle.getMessage("CloseButtonLabel"));
    protected JRadioButton verboseButton = new JRadioButton(Bundle.getMessage("VerboseButtonLabel"));
    protected JRadioButton origHex0Button = new JRadioButton(Bundle.getMessage("OrigHex0Label"));
    protected JRadioButton origHex1Button = new JRadioButton(Bundle.getMessage("OrigHex1Label"));
    protected JRadioButton origHex2Button = new JRadioButton(Bundle.getMessage("OrigHex2Label"));
    protected JRadioButton origHex3Button = new JRadioButton(Bundle.getMessage("OrigHex3Label"));
    protected JRadioButton origHex4Button = new JRadioButton(Bundle.getMessage("OrigHex4Label"));
    protected JRadioButton origHex5Button = new JRadioButton(Bundle.getMessage("OrigHex5Label"));
    protected JRadioButton newHex0Button = new JRadioButton(Bundle.getMessage("NewHex0Label"));
    protected JRadioButton newHex1Button = new JRadioButton(Bundle.getMessage("NewHex1Label"));
    protected JRadioButton accOnButton = new JRadioButton(Bundle.getMessage("AccOnLabel"));
    protected JRadioButton idleOnButton = new JRadioButton(Bundle.getMessage("IdleOnLabel"));
    protected JRadioButton locoOnButton = new JRadioButton(Bundle.getMessage("LocoOnLabel"));
    protected JRadioButton resetOnButton = new JRadioButton(Bundle.getMessage("ResetOnLabel"));
    protected JRadioButton signalOnButton = new JRadioButton(Bundle.getMessage("SignalOnLabel"));
    protected JRadioButton accSingleButton = new JRadioButton(Bundle.getMessage("AccSingleLabel"));
    protected JRadioButton accPairedButton = new JRadioButton(Bundle.getMessage("AccPairedLabel"));
    protected JComboBox<String> modelBox = new JComboBox();
    protected JLabel modelBoxLabel;
    private String[] validModelNames = new String[]{Bundle.getMessage("PacketAnalyzer"), Bundle.getMessage("DccMeter/Analyzer")};
    private static final int MODELORIG = 0;
    private static final int MODELNEW = 1;
    private int[] validModelValues = new int[]{0, 1};
    private int[] modelBaudRates = new int[]{38400, 115200};
    private int[] modelBitValues = new int[]{8, 8};
    private int[] modelStopValues = new int[]{1, 1};
    private int[] modelParityValues = new int[]{0, 0};
    Thread readerThread;
    DataInputStream serialStream = null;
    OutputStream ostream = null;
    private static final Logger log = LoggerFactory.getLogger(NcePacketMonitorPanel.class);

    @Override
    public void init() {
    }

    @Override
    public void initContext(Object context) {
        if (context instanceof NceSystemConnectionMemo) {
            this.initComponents((NceSystemConnectionMemo)context);
        }
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrix.nce.analyzer.NcePacketMonitorFrame";
    }

    @Override
    public String getTitle() {
        StringBuilder x = new StringBuilder();
        if (this.memo != null) {
            x.append(this.memo.getUserName());
        } else {
            x.append("NCE_");
        }
        x.append(": ");
        x.append(Bundle.getMessage("Title"));
        return x.toString();
    }

    @Override
    public Dimension getMinimumDimension() {
        return new Dimension(500, 500);
    }

    @Override
    public void initComponents(NceSystemConnectionMemo m) {
        int i;
        this.memo = m;
        this.enableDisableWhenOpen(false);
        this.portBox.setToolTipText(Bundle.getMessage("PortBoxToolTip"));
        this.portBox.setAlignmentX(0.0f);
        Vector<String> v = this.getPortNames();
        for (i = 0; i < v.size(); ++i) {
            this.portBox.addItem(v.elementAt(i));
        }
        this.modelBox.setToolTipText(Bundle.getMessage("ModelBoxToolTip"));
        this.modelBox.setAlignmentX(0.0f);
        for (i = 0; i < this.validModelNames.length; ++i) {
            this.modelBox.addItem(this.validModelNames[i]);
        }
        this.openButton.setToolTipText(Bundle.getMessage("OpenButtonToolTip"));
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    NcePacketMonitorPanel.this.openPortButtonActionPerformed(evt);
                }
                catch (UnsatisfiedLinkError ex) {
                    log.error("Error while opening port.  Did you select the right one?\nException: ", (Throwable)ex);
                }
            }
        });
        this.closePortButton.setToolTipText(Bundle.getMessage("CloseButtonToolTip"));
        this.closePortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    NcePacketMonitorPanel.this.closePortButtonActionPerformed();
                }
                catch (UnsatisfiedLinkError ex) {
                    log.error("Error while closing port.  Did you select the right one?\\nException: ", (Throwable)ex);
                }
            }
        });
        JSeparator js = new JSeparator();
        js.setMaximumSize(new Dimension(10000, 10));
        this.add(js);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout());
        p1.add(new JLabel(Bundle.getMessage("SerialPortLabel")));
        p1.add(this.portBox);
        p1.add(new JLabel(Bundle.getMessage("ModelBoxLabel")));
        p1.add(this.modelBox);
        p1.add(this.openButton);
        p1.add(this.closePortButton);
        this.add(p1);
        js = new JSeparator();
        js.setMaximumSize(new Dimension(10000, 10));
        this.add(js);
        JPanel p2 = new JPanel();
        JPanel p2A = new JPanel();
        p2A.setLayout(new BoxLayout(p2A, 1));
        JPanel p2B = new JPanel();
        JPanel p2C = new JPanel();
        JPanel p2D = new JPanel();
        ButtonGroup gD = new ButtonGroup();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.dupFilterCheckBox.setToolTipText(Bundle.getMessage("DupFilterCheckBoxToolTip"));
        p.add(this.dupFilterCheckBox);
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        this.verboseButton.setToolTipText(Bundle.getMessage("VerboseButtonToolTip"));
        gD.add(this.verboseButton);
        p.add(this.verboseButton);
        this.verboseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{86});
            }
        });
        p2A.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.origHex0Button.setToolTipText(Bundle.getMessage("OrigHex0ButtonToolTip"));
        gD.add(this.origHex0Button);
        p.add(this.origHex0Button);
        this.origHex0Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 48});
            }
        });
        p2B.add(p);
        this.origHex1Button.setToolTipText(Bundle.getMessage("OrigHex1ButtonToolTip"));
        gD.add(this.origHex1Button);
        p.add(this.origHex1Button);
        this.origHex1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 49});
            }
        });
        p2B.add(p);
        this.origHex2Button.setToolTipText(Bundle.getMessage("OrigHex2ButtonToolTip"));
        gD.add(this.origHex2Button);
        p.add(this.origHex2Button);
        this.origHex2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 50});
            }
        });
        p2.add(p);
        this.origHex3Button.setToolTipText(Bundle.getMessage("OrigHex3ButtonToolTip"));
        gD.add(this.origHex3Button);
        p.add(this.origHex3Button);
        this.origHex3Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 51});
            }
        });
        p2B.add(p);
        this.origHex4Button.setToolTipText(Bundle.getMessage("OrigHex4ButtonToolTip"));
        gD.add(this.origHex4Button);
        p.add(this.origHex4Button);
        this.origHex4Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 52});
            }
        });
        p2.add(p);
        this.origHex5Button.setToolTipText(Bundle.getMessage("OrigHex5ButtonToolTip"));
        gD.add(this.origHex5Button);
        p.add(this.origHex5Button);
        this.origHex5Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 53});
            }
        });
        p2B.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.newHex0Button.setToolTipText(Bundle.getMessage("NewHex0ButtonToolTip"));
        gD.add(this.newHex0Button);
        p.add(this.newHex0Button);
        this.newHex0Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 48});
            }
        });
        p2C.add(p);
        this.newHex1Button.setToolTipText(Bundle.getMessage("NewHex1ButtonToolTip"));
        gD.add(this.newHex1Button);
        p.add(this.newHex1Button);
        this.newHex1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{72, 49});
            }
        });
        p2C.add(p);
        p2D.setLayout(new BoxLayout(p2D, 0));
        p2D.add(p2B);
        p2D.add(p2C);
        p2A.add(p2D);
        p2.add(p2A);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        this.accOnButton.setToolTipText(Bundle.getMessage("AccOnButtonToolTip"));
        p.add(this.accOnButton);
        this.accOnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NcePacketMonitorPanel.this.accOnButton.isSelected()) {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 43});
                } else {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 45});
                }
            }
        });
        this.idleOnButton.setToolTipText(Bundle.getMessage("IdleOnButtonToolTip"));
        p.add(this.idleOnButton);
        this.idleOnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NcePacketMonitorPanel.this.idleOnButton.isSelected()) {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{73, 43});
                } else {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{73, 45});
                }
            }
        });
        this.locoOnButton.setToolTipText(Bundle.getMessage("LocoOnButtonToolTip"));
        p.add(this.locoOnButton);
        this.locoOnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NcePacketMonitorPanel.this.locoOnButton.isSelected()) {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{76, 43});
                } else {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{76, 45});
                }
            }
        });
        this.resetOnButton.setToolTipText(Bundle.getMessage("ResetOnButtonToolTip"));
        p.add(this.resetOnButton);
        this.resetOnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NcePacketMonitorPanel.this.resetOnButton.isSelected()) {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{82, 43});
                } else {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{82, 45});
                }
            }
        });
        this.signalOnButton.setToolTipText(Bundle.getMessage("SignalOnButtonToolTip"));
        p.add(this.signalOnButton);
        this.signalOnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NcePacketMonitorPanel.this.signalOnButton.isSelected()) {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{83, 43});
                } else {
                    NcePacketMonitorPanel.this.sendBytes(new byte[]{83, 45});
                }
            }
        });
        p2.add(p);
        p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel t = new JLabel(Bundle.getMessage("MonitorCmdLabel"));
        p.add(t);
        p.setLayout(new BoxLayout(p, 1));
        ButtonGroup gA = new ButtonGroup();
        this.accSingleButton.setToolTipText(Bundle.getMessage("AccSingleButtonToolTip"));
        gA.add(this.accSingleButton);
        p.add(this.accSingleButton);
        this.accSingleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 83});
            }
        });
        this.accPairedButton.setToolTipText(Bundle.getMessage("AccPairedButtonToolTip"));
        gA.add(this.accPairedButton);
        p.add(this.accPairedButton);
        this.accPairedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NcePacketMonitorPanel.this.sendBytes(new byte[]{65, 80});
            }
        });
        p2.add(p);
        p2.setMaximumSize(p2.getPreferredSize());
        JScrollPane ps = new JScrollPane(p2);
        ps.setMaximumSize(ps.getPreferredSize());
        ps.setVisible(true);
        this.add(ps);
    }

    synchronized void sendBytes(byte[] bytes) {
        try {
            if (this.ostream == null) {
                throw new IOException("Unable to send data to command station: output stream is null");
            }
            for (int i = 0; i < bytes.length; ++i) {
                this.ostream.write(bytes[i]);
                this.wait(3L);
            }
            int endbyte = 13;
            this.ostream.write(13);
        }
        catch (IOException e) {
            log.error("Exception on output: ", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("Interrupted output: ", (Throwable)e);
        }
    }

    void enableDisableWhenOpen(boolean isOpen) {
        this.openButton.setEnabled(!isOpen);
        this.closePortButton.setEnabled(isOpen);
        this.portBox.setEnabled(!isOpen);
        this.modelBox.setEnabled(!isOpen);
        this.verboseButton.setEnabled(isOpen);
        if (!isOpen || this.modelBox.getSelectedIndex() == 0) {
            this.origHex0Button.setEnabled(isOpen);
            this.origHex1Button.setEnabled(isOpen);
            this.origHex2Button.setEnabled(isOpen);
            this.origHex3Button.setEnabled(isOpen);
            this.origHex4Button.setEnabled(isOpen);
            this.origHex5Button.setEnabled(isOpen);
        }
        if (!isOpen || this.modelBox.getSelectedIndex() == 1) {
            this.newHex0Button.setEnabled(isOpen);
            this.newHex1Button.setEnabled(isOpen);
        }
        this.accOnButton.setEnabled(isOpen);
        this.idleOnButton.setEnabled(isOpen);
        this.locoOnButton.setEnabled(isOpen);
        this.resetOnButton.setEnabled(isOpen);
        this.signalOnButton.setEnabled(isOpen);
        this.accSingleButton.setEnabled(isOpen);
        this.accPairedButton.setEnabled(isOpen);
    }

    void openPortButtonActionPerformed(ActionEvent e) {
        String portName = (String)this.portBox.getSelectedItem();
        int modelValue = this.validModelValues[this.modelBox.getSelectedIndex()];
        int numDataBits = this.modelBitValues[modelValue];
        int numStopBits = this.modelStopValues[modelValue];
        int parity = this.modelParityValues[modelValue];
        int baudrate = this.modelBaudRates[modelValue];
        this.activeSerialPort = AbstractSerialPortController.activatePort(null, portName, log, numStopBits, SerialPort.Parity.getParity(parity));
        this.activeSerialPort.setNumDataBits(numDataBits);
        this.activeSerialPort.setBaudRate(baudrate);
        this.activeSerialPort.setRTS();
        this.activeSerialPort.setDTR();
        this.serialStream = new DataInputStream(this.activeSerialPort.getInputStream());
        this.ostream = this.activeSerialPort.getOutputStream();
        if (log.isInfoEnabled()) {
            log.info("Port {} {} opened at {} baud, sees DTR: {} RTS: {} DSR: {} CTS: {} DCD: {}", new Object[]{portName, this.activeSerialPort.getDescriptivePortName(), this.activeSerialPort.getBaudRate(), this.activeSerialPort.getDTR(), this.activeSerialPort.getRTS(), this.activeSerialPort.getDSR(), this.activeSerialPort.getCTS(), this.activeSerialPort.getDCD()});
        }
        this.readerThread = new Thread(new Reader());
        this.readerThread.start();
        this.readerThread.setName("NCE Packet Monitor");
        this.enableDisableWhenOpen(true);
    }

    void closePortButtonActionPerformed() {
        if (this.readerThread != null) {
            this.stopThread(this.readerThread);
        }
        if (this.activeSerialPort != null) {
            this.activeSerialPort.closePort();
            log.info("{} port closed", this.portBox.getSelectedItem());
        }
        this.serialStream = null;
        this.ostream = null;
        this.activeSerialPort = null;
        this.portNameVector = null;
        this.enableDisableWhenOpen(false);
    }

    void stopThread(Thread t) {
        t.interrupt();
    }

    @Override
    public synchronized void dispose() {
        this.closePortButtonActionPerformed();
        super.dispose();
    }

    public Vector<String> getPortNames() {
        return AbstractSerialPortController.getActualPortNames();
    }

    public static class Default
    extends NceNamedPaneAction {
        public Default() {
            super("Open NCE DCC Packet Analyzer", (WindowInterface)new JmriJFrameInterface(), NcePacketMonitorPanel.class.getName(), InstanceManager.getDefault(NceSystemConnectionMemo.class));
        }
    }

    class Reader
    implements Runnable {
        static final int maxMsg = 80;
        StringBuffer msg;
        private int duplicates = 0;
        String msgString;
        String matchString = "";

        Reader() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.handleIncomingData();
                }
            }
            catch (EOFException e) {
                log.info("{} thread ending, port closed", (Object)Thread.currentThread().getName());
                return;
            }
            catch (IOException e) {
                log.warn("{} thread ending: Exception: {}", (Object)Thread.currentThread().getName(), (Object)e.toString());
                return;
            }
        }

        void handleIncomingData() throws IOException {
            char char1;
            this.msg = new StringBuffer(80);
            for (int i = 0; i < 80 && (char1 = (char)NcePacketMonitorPanel.this.serialStream.readByte()) != '\r'; ++i) {
                this.msg.append(char1);
            }
            this.msgString = this.msg.toString();
            if (this.msgString.equals(this.matchString) && NcePacketMonitorPanel.this.dupFilterCheckBox.isSelected()) {
                ++this.duplicates;
            } else {
                if (!this.msgString.equals(this.matchString) && NcePacketMonitorPanel.this.dupFilterCheckBox.isSelected() && this.duplicates > 0) {
                    final String dupString = this.matchString + " [" + this.duplicates + "]\n";
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            NcePacketMonitorPanel.this.nextLine(dupString, "");
                        }
                    };
                    SwingUtilities.invokeLater(r);
                }
                this.duplicates = 0;
                this.matchString = this.msgString;
                this.msgString = this.msgString + "\n";
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        NcePacketMonitorPanel.this.nextLine(Reader.this.msgString, "");
                    }
                };
                SwingUtilities.invokeLater(r);
            }
        }
    }
}

