/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.oaktree;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.NamedBean;
import jmri.jmrix.oaktree.Bundle;
import jmri.jmrix.oaktree.OakTreeSystemConnectionMemo;
import jmri.jmrix.oaktree.SerialNode;
import jmri.jmrix.oaktree.SerialTrafficController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialAddress {
    OakTreeSystemConnectionMemo _memo = null;
    private static final Logger log = LoggerFactory.getLogger(SerialAddress.class);

    public SerialAddress(OakTreeSystemConnectionMemo memo) {
        this._memo = memo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SerialNode getNodeFromSystemName(String systemName, SerialTrafficController tc) {
        int ua;
        String prefix = tc.getSystemConnectionMemo().getSystemPrefix();
        if (prefix.length() < 1) {
            return null;
        }
        log.debug("systemName = {}", (Object)systemName);
        log.debug("prefix = {}", (Object)prefix);
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != 'L' && systemName.charAt(prefix.length()) != 'S' && systemName.charAt(prefix.length()) != 'T') {
            log.error("illegal character in header field of system name: {}", (Object)systemName);
            return null;
        }
        String s = "";
        boolean noB = true;
        for (int i = prefix.length() + 1; i < systemName.length() && noB; ++i) {
            if (systemName.charAt(i) != 'B') continue;
            s = systemName.substring(prefix.length() + 1, i);
            noB = false;
        }
        if (noB) {
            int num;
            try {
                num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            }
            catch (NumberFormatException ex) {
                log.warn("invalid character in number field of system name: {}", (Object)systemName);
                return null;
            }
            if (num > 0) {
                ua = num / 1000;
                return (SerialNode)tc.getNodeFromAddress(ua);
            }
            log.error("invalid system name: {}", (Object)systemName);
            return null;
        }
        if (s.length() == 0) {
            log.error("no node address before 'B' in system name: {}", (Object)systemName);
            return null;
        }
        try {
            ua = Integer.parseInt(s);
            return (SerialNode)tc.getNodeFromAddress(ua);
        }
        catch (NumberFormatException e) {
            log.error("illegal character in system name: {}", (Object)systemName);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getBitFromSystemName(String systemName, String prefix) {
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != 'L' && systemName.charAt(prefix.length()) != 'S' && systemName.charAt(prefix.length()) != 'T') {
            log.error("illegal character in header field of system name: {}", (Object)systemName);
            return 0;
        }
        int k = 0;
        for (int i = prefix.length() + 1; i < systemName.length() && k == 0; ++i) {
            if (systemName.charAt(i) != 'B') continue;
            k = i + 1;
        }
        int n = 0;
        if (k == 0) {
            int num;
            try {
                num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            }
            catch (NumberFormatException e) {
                log.error("illegal character in number field of system name: {}", (Object)systemName);
                return 0;
            }
            if (num > 0) {
                return num - num / 1000 * 1000;
            }
            log.error("invalid system name: {}", (Object)systemName);
            return 0;
        }
        try {
            return Integer.parseInt(systemName.substring(k, systemName.length()));
        }
        catch (NumberFormatException e) {
            log.error("illegal character in bit number field system name: {}", (Object)systemName);
            return 0;
        }
    }

    public static String validateSystemNameFormat(String systemName, String prefix, Locale locale) throws IllegalArgumentException {
        if (!systemName.startsWith(prefix)) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidPrefix", systemName), Bundle.getMessage(locale, "InvalidSystemNameInvalidPrefix", systemName));
        }
        String address = systemName.substring(prefix.length());
        int node = 0;
        int bit = 0;
        if (!address.contains("B")) {
            try {
                int num = Integer.parseInt(address);
                node = num / 1000;
                bit = num - num / 1000 * 1000;
            }
            catch (NumberFormatException e) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNotInteger", systemName, prefix), Bundle.getMessage(locale, "InvalidSystemNameNotInteger", systemName, prefix));
            }
        }
        String[] parts = address.split("B");
        if (parts.length != 2) {
            if (address.indexOf("B") == 0) {
                throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, ""), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, ""));
            }
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, ""), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, ""));
        }
        try {
            node = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            log.debug("invalid character in node address field of CMRI system name: {}", (Object)systemName);
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, parts[0]), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, parts[0]));
        }
        try {
            bit = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException ex) {
            log.debug("invalid character in bit number field of CMRI system name: {}", (Object)systemName);
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, parts[1]), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, parts[1]));
        }
        if (node < 0 || node >= 128) {
            log.debug("node address field out of range in CMRI system name: {}", (Object)systemName);
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameNodeInvalid", systemName, node), Bundle.getMessage(locale, "InvalidSystemNameNodeInvalid", systemName, node));
        }
        if (bit < 1 || bit > 2048) {
            log.debug("bit number field out of range in CMRI system name: {}", (Object)systemName);
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameBitInvalid", systemName, bit), Bundle.getMessage(locale, "InvalidSystemNameBitInvalid", systemName, bit));
        }
        return systemName;
    }

    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        int num;
        if (!systemName.startsWith(prefix) || systemName.charAt(prefix.length()) != type) {
            log.error("invalid character in header field system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        String s = "";
        int k = 0;
        boolean noB = true;
        for (int i = prefix.length() + 1; i < systemName.length() && noB; ++i) {
            if (systemName.charAt(i) != 'B') continue;
            s = systemName.substring(prefix.length() + 1, i);
            k = i + 1;
            noB = false;
        }
        if (noB) {
            try {
                num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            }
            catch (NumberFormatException e) {
                log.warn("invalid character in number field system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 1 || num >= 256000) {
                log.warn("number field out of range in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num - num / 1000 * 1000 == 0) {
                log.warn("bit number not in range 1 - 999 in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        } else {
            if (s.length() == 0) {
                log.warn("no node address before 'B' in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            try {
                num = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                log.warn("invalid character in node address field of system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 0 || num >= 128) {
                log.warn("node address field out of range in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            try {
                num = Integer.parseInt(systemName.substring(k, systemName.length()));
            }
            catch (NumberFormatException e) {
                log.warn("invalid character in bit number field of system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
            if (num < 1 || num > 2048) {
                log.warn("bit number field out of range in system name: {}", (Object)systemName);
                return Manager.NameValidity.INVALID;
            }
        }
        return Manager.NameValidity.VALID;
    }

    public static boolean validSystemNameConfig(String systemName, char type, OakTreeSystemConnectionMemo memo) {
        if (SerialAddress.validSystemNameFormat(systemName, type, memo.getSystemPrefix()) != Manager.NameValidity.VALID) {
            log.warn("invalid system name {}; bad format", (Object)systemName);
            return false;
        }
        SerialNode node = SerialAddress.getNodeFromSystemName(systemName, memo.getTrafficController());
        if (node == null) {
            log.warn("invalid system name {}; no such node", (Object)systemName);
            return false;
        }
        int bit = SerialAddress.getBitFromSystemName(systemName, memo.getSystemPrefix());
        if (type == 'T' || type == 'L') {
            if (bit <= 0 || bit > SerialNode.outputBytes[node.nodeType] * 8) {
                log.warn("invalid system name {}; bad bit number", (Object)systemName);
                return false;
            }
        } else if (type == 'S') {
            if (bit <= 0 || bit > SerialNode.inputBytes[node.nodeType] * 8) {
                log.warn("invalid system name {}; bad bit number", (Object)systemName);
                return false;
            }
        } else {
            log.error("Invalid type specification in validSystemNameConfig call");
            return false;
        }
        return true;
    }

    public static String convertSystemNameToAlternate(String systemName, String prefix) {
        String altName;
        if (SerialAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        String s = "";
        int k = 0;
        boolean noB = true;
        for (int i = prefix.length() + 1; i < systemName.length() && noB; ++i) {
            if (systemName.charAt(i) != 'B') continue;
            s = systemName.substring(prefix.length() + 1, i);
            k = i + 1;
            noB = false;
        }
        if (noB) {
            int num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            int nAddress = num / 1000;
            int bitNum = num - nAddress * 1000;
            altName = prefix + systemName.charAt(prefix.length()) + Integer.toString(nAddress) + "B" + Integer.toString(bitNum);
        } else {
            int nAddress = Integer.parseInt(s);
            int bitNum = Integer.parseInt(systemName.substring(k, systemName.length()));
            if (bitNum > 999) {
                return "";
            }
            altName = prefix + systemName.charAt(prefix.length()) + Integer.toString(nAddress * 1000 + bitNum);
        }
        return altName;
    }

    public static String normalizeSystemName(String systemName, String prefix) {
        String nName;
        if (prefix.length() < 1) {
            log.error("invalid system name prefix: {}", (Object)prefix);
            return "";
        }
        if (SerialAddress.validSystemNameFormat(systemName, systemName.charAt(prefix.length()), prefix) != Manager.NameValidity.VALID) {
            return "";
        }
        String s = "";
        int k = 0;
        boolean noB = true;
        for (int i = prefix.length() + 1; i < systemName.length() && noB; ++i) {
            if (systemName.charAt(i) != 'B') continue;
            s = systemName.substring(prefix.length() + 1, i);
            k = i + 1;
            noB = false;
        }
        char type = systemName.charAt(prefix.length());
        if (noB) {
            int num = Integer.parseInt(systemName.substring(prefix.length() + 1));
            int nAddress = num / 1000;
            int bitNum = num - nAddress * 1000;
            nName = prefix + type + Integer.toString(nAddress * 1000 + bitNum);
        } else {
            int nAddress = Integer.parseInt(s);
            int bitNum = Integer.parseInt(systemName.substring(k, systemName.length()));
            nName = prefix + type + Integer.toString(nAddress) + "B" + Integer.toString(bitNum);
        }
        return nName;
    }
}

