/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.oaktree;

import jmri.implementation.AbstractLight;
import jmri.jmrix.oaktree.OakTreeSystemConnectionMemo;
import jmri.jmrix.oaktree.SerialAddress;
import jmri.jmrix.oaktree.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialLight
extends AbstractLight {
    private OakTreeSystemConnectionMemo _memo = null;
    int mBit = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialLight.class);

    public SerialLight(String systemName, OakTreeSystemConnectionMemo memo) {
        super(systemName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    public SerialLight(String systemName, String userName, OakTreeSystemConnectionMemo memo) {
        super(systemName, userName);
        this._memo = memo;
        this.initializeLight(systemName);
    }

    private void initializeLight(String systemName) {
        this.mBit = SerialAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
        this.setState(4);
    }

    @Override
    protected void doNewState(int oldState, int newState) {
        SerialNode mNode = SerialAddress.getNodeFromSystemName(this.getSystemName(), this._memo.getTrafficController());
        if (mNode != null) {
            if (newState == 2) {
                mNode.setOutputBit(this.mBit, false);
            } else if (newState == 4) {
                mNode.setOutputBit(this.mBit, true);
            } else {
                log.warn("illegal state requested for Light: {}", (Object)this.getSystemName());
            }
        }
    }
}

