/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.oaktree;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractNode;
import jmri.jmrix.oaktree.OakTreeSystemConnectionMemo;
import jmri.jmrix.oaktree.SerialMessage;
import jmri.jmrix.oaktree.SerialReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialNode
extends AbstractNode {
    static final int MAXSENSORS = 999;
    public static final int IO24 = 0;
    public static final int IO48 = 1;
    public static final int O48 = 2;
    private static final String[] boardNames = new String[]{"IO24", "IO48", "O48"};
    static final int[] outputBytes = new int[]{2, 4, 6};
    static final int[] inputBytes = new int[]{1, 2, 0};
    protected int nodeType = 0;
    protected byte[] outputArray = new byte[256];
    protected boolean[] outputByteChanged = new boolean[256];
    protected boolean hasActiveSensors = false;
    protected int lastUsedSensor = 0;
    protected Sensor[] sensorArray = new Sensor[1000];
    protected int[] sensorLastSetting = new int[1000];
    protected int[] sensorTempSetting = new int[1000];
    OakTreeSystemConnectionMemo _memo = null;
    boolean warned = false;
    int timeout = 0;
    private static final Logger log = LoggerFactory.getLogger(SerialNode.class);

    public static String[] getBoardNames() {
        return (String[])boardNames.clone();
    }

    public SerialNode(OakTreeSystemConnectionMemo memo) {
        this(0, 0, memo);
    }

    public SerialNode(int address, int type, OakTreeSystemConnectionMemo memo) {
        int i;
        this._memo = memo;
        this.setNodeAddress(address);
        this.setNodeType(type);
        for (i = 0; i < 1000; ++i) {
            this.sensorArray[i] = null;
            this.sensorLastSetting[i] = 1;
            this.sensorTempSetting[i] = 1;
        }
        for (i = 0; i < 256; ++i) {
            this.outputArray[i] = 0;
            this.outputByteChanged[i] = false;
        }
        this.setMustSend();
        this.hasActiveSensors = false;
        this._memo.getTrafficController().registerNode(this);
    }

    public void setOutputBit(int bitNumber, boolean state) {
        int byteNumber = (bitNumber - 1) / 8;
        if (byteNumber > outputBytes[this.nodeType]) {
            this.warn("Output bit out-of-range for defined node: " + bitNumber);
        }
        if (byteNumber >= 256) {
            byteNumber = 255;
        }
        byte bit = (byte)(1 << (bitNumber - 1) % 8);
        byte oldByte = this.outputArray[byteNumber];
        if (state) {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] & ~bit);
        } else {
            int n = byteNumber;
            this.outputArray[n] = (byte)(this.outputArray[n] | bit);
        }
        if (oldByte != this.outputArray[byteNumber]) {
            this.setMustSend();
            this.outputByteChanged[byteNumber] = true;
        }
    }

    @Override
    public boolean getSensorsActive() {
        return this.hasActiveSensors;
    }

    @Override
    public void resetMustSend() {
        for (int i = 0; i < outputBytes[this.nodeType]; ++i) {
            if (!this.outputByteChanged[i]) continue;
            return;
        }
        super.resetMustSend();
    }

    public int getNodeType() {
        return this.nodeType;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public void setNodeType(int type) {
        this.nodeType = type;
        switch (this.nodeType) {
            default: {
                log.error("Unexpected nodeType in setNodeType: {}", (Object)this.nodeType);
            }
            case 0: 
            case 1: 
            case 2: 
        }
    }

    @Override
    protected boolean checkNodeAddress(int address) {
        return address >= 0 && address < 256;
    }

    @Override
    public AbstractMRMessage createInitPacket() {
        return null;
    }

    @Override
    public AbstractMRMessage createOutPacket() {
        if (log.isDebugEnabled()) {
            log.debug("createOutPacket for nodeType {} with {} {};{} {};{} {};{} {}.", new Object[]{this.nodeType, this.outputByteChanged[0], this.outputArray[0], this.outputByteChanged[1], this.outputArray[1], this.outputByteChanged[2], this.outputArray[2], this.outputByteChanged[3], this.outputArray[3]});
        }
        SerialMessage m = new SerialMessage(1);
        m.setElement(0, this.getNodeAddress());
        m.setElement(1, 17);
        for (int i = 0; i < outputBytes[this.nodeType]; ++i) {
            if (!this.outputByteChanged[i]) continue;
            this.outputByteChanged[i] = false;
            m.setElement(2, i);
            m.setElement(3, this.outputArray[i]);
            return m;
        }
        m.setElement(2, 0);
        m.setElement(3, this.outputArray[0]);
        return m;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="only logging 1st warning string passed")
    void warn(String s) {
        if (this.warned) {
            return;
        }
        this.warned = true;
        log.warn(s);
    }

    public void markChanges(SerialReply l) {
        try {
            for (int i = 0; i <= this.lastUsedSensor; ++i) {
                if (this.sensorArray[i] == null) continue;
                int loc = i / 8;
                int bit = i % 8;
                boolean value = (l.getElement(loc + 2) >> bit & 1) == 1 ^ this.sensorArray[i].getInverted();
                log.debug("markChanges loc={} bit={} is {}", new Object[]{loc, bit, value});
                if (value) {
                    if ((this.sensorTempSetting[i] == 2 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 2) {
                        this.sensorLastSetting[i] = 2;
                        this.sensorArray[i].setKnownState(2);
                    }
                    this.sensorTempSetting[i] = 2;
                    continue;
                }
                if ((this.sensorTempSetting[i] == 4 || this.sensorTempSetting[i] == 1) && this.sensorLastSetting[i] != 4) {
                    this.sensorLastSetting[i] = 4;
                    this.sensorArray[i].setKnownState(4);
                }
                this.sensorTempSetting[i] = 4;
            }
        }
        catch (JmriException e) {
            log.error("exception in markChanges", (Throwable)e);
        }
    }

    public void registerSensor(Sensor s, int i) {
        if (i < 0 || i > inputBytes[this.nodeType] * 8 - 1 || i > 999) {
            log.error("Unexpected sensor ordinal in registerSensor: {}", (Object)Integer.toString(i + 1));
            return;
        }
        this.hasActiveSensors = true;
        if (this.sensorArray[i] == null) {
            this.sensorArray[i] = s;
            if (this.lastUsedSensor < i) {
                this.lastUsedSensor = i;
            }
        } else {
            log.warn("multiple registration of same sensor: {}S{}", (Object)InstanceManager.getDefault(OakTreeSystemConnectionMemo.class).getSystemPrefix(), (Object)Integer.toString(this.getNodeAddress() * 1000 + i + 1));
        }
    }

    @Override
    public boolean handleTimeout(AbstractMRMessage m, AbstractMRListener l) {
        ++this.timeout;
        if (m.getElement(1) != 80) {
            return false;
        }
        log.warn("Timeout to poll for addr={}: consecutive timeouts: {}", (Object)this.getNodeAddress(), (Object)this.timeout);
        if (this.timeout > 5) {
            this.timeout = 0;
            this.setMustSend();
            return true;
        }
        return false;
    }

    @Override
    public void resetTimeout(AbstractMRMessage m) {
        if (this.timeout > 0) {
            log.debug("Reset {} timeout count", (Object)this.timeout);
        }
        this.timeout = 0;
    }
}

