/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.oaktree;

import jmri.implementation.AbstractTurnout;
import jmri.jmrix.oaktree.OakTreeSystemConnectionMemo;
import jmri.jmrix.oaktree.SerialAddress;
import jmri.jmrix.oaktree.SerialNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnout
extends AbstractTurnout {
    private OakTreeSystemConnectionMemo _memo = null;
    String tSystemName;
    int tBit;
    private static final Logger log = LoggerFactory.getLogger(SerialTurnout.class);

    public SerialTurnout(String systemName, String userName, OakTreeSystemConnectionMemo memo) {
        super(systemName, userName);
        this.tSystemName = systemName;
        this._memo = memo;
        this.tBit = SerialAddress.getBitFromSystemName(systemName, this._memo.getSystemPrefix());
    }

    @Override
    protected void forwardCommandChangeToLayout(int newState) {
        if ((newState & 2) != 0) {
            if ((newState & 4) != 0) {
                log.error("Cannot command both CLOSED and THROWN {}", (Object)newState);
                return;
            }
            this.sendMessage(!this.getInverted());
        } else {
            this.sendMessage(this.getInverted());
        }
    }

    @Override
    protected void turnoutPushbuttonLockout(boolean _pushButtonLockout) {
        log.debug("Send command to {} Pushbutton", (Object)(_pushButtonLockout ? "Lock" : "Unlock"));
    }

    protected void sendMessage(boolean closed) {
        SerialNode tNode = SerialAddress.getNodeFromSystemName(this.tSystemName, this._memo.getTrafficController());
        if (tNode == null) {
            return;
        }
        tNode.setOutputBit(this.tBit, closed);
    }
}

