/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.oaktree;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Manager;
import jmri.Turnout;
import jmri.jmrix.oaktree.Bundle;
import jmri.jmrix.oaktree.OakTreeSystemConnectionMemo;
import jmri.jmrix.oaktree.SerialAddress;
import jmri.jmrix.oaktree.SerialTurnout;
import jmri.managers.AbstractTurnoutManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialTurnoutManager
extends AbstractTurnoutManager {
    private static final Logger log = LoggerFactory.getLogger(SerialTurnoutManager.class);

    public SerialTurnoutManager(OakTreeSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    public OakTreeSystemConnectionMemo getMemo() {
        return (OakTreeSystemConnectionMemo)this.memo;
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        String sName = SerialAddress.normalizeSystemName(systemName, this.getSystemPrefix());
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("Cannot create System Name from " + systemName);
        }
        Turnout t = (Turnout)this.getBySystemName(sName);
        if (t != null) {
            return t;
        }
        String altName = SerialAddress.convertSystemNameToAlternate(sName, this.getSystemPrefix());
        t = (Turnout)this.getBySystemName(altName);
        if (t != null) {
            return t;
        }
        t = new SerialTurnout(sName, userName, this.getMemo());
        if (!SerialAddress.validSystemNameConfig(sName, 'T', this.getMemo())) {
            log.warn("Turnout '{}' refers to an undefined Serial Node", (Object)sName);
        }
        return t;
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return SerialAddress.validateSystemNameFormat(systemName, this.getSystemNamePrefix(), locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return SerialAddress.validSystemNameFormat(systemName, this.typeLetter(), this.getSystemPrefix());
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddOutputEntryToolTip");
    }
}

