/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.oaktree.serialmon;

import jmri.jmrix.AbstractMonFrame;
import jmri.jmrix.oaktree.OakTreeSystemConnectionMemo;
import jmri.jmrix.oaktree.SerialListener;
import jmri.jmrix.oaktree.SerialMessage;
import jmri.jmrix.oaktree.SerialReply;
import jmri.jmrix.oaktree.serialmon.Bundle;

public class SerialMonFrame
extends AbstractMonFrame
implements SerialListener {
    private OakTreeSystemConnectionMemo _memo = null;

    public SerialMonFrame(OakTreeSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    protected String title() {
        return Bundle.getMessage("MonitorXTitle", "OakTree");
    }

    @Override
    protected void init() {
        this._memo.getTrafficController().addSerialListener(this);
    }

    @Override
    public void dispose() {
        this._memo.getTrafficController().removeSerialListener(this);
        super.dispose();
    }

    @Override
    public synchronized void message(SerialMessage l) {
        if (l.getNumDataElements() < 5) {
            this.nextLine("Truncated message of length " + l.getNumDataElements() + "\n", l.toString());
        } else if (l.isPoll()) {
            this.nextLine("Poll addr=" + l.getAddr() + "\n", l.toString());
        } else if (l.isXmt()) {
            String s = "Transmit addr=" + l.getAddr() + " byte " + (l.getElement(2) & 0xFF) + " data = " + Integer.toHexString(l.getElement(3) & 0xFF);
            this.nextLine(s + "\n", l.toString());
        } else {
            this.nextLine("Unrecognized cmd: \"" + l.toString() + "\"\n", l.toString());
        }
    }

    @Override
    public synchronized void reply(SerialReply l) {
        if (l.getNumDataElements() == 1) {
            if (l.getElement(0) == 0) {
                this.nextLine("NACK\n", l.toString());
            } else {
                this.nextLine("Ack from node " + l.getElement(0) + "\n", l.toString());
            }
        } else if (l.getNumDataElements() != 5) {
            this.nextLine("Truncated reply of length " + l.getNumDataElements() + ":" + l.toString() + "\n", l.toString());
        } else {
            StringBuilder s = new StringBuilder(String.format("Receive addr=%d IB=", l.getAddr()));
            for (int i = 2; i < 4; ++i) {
                s.append(Integer.toHexString(l.getElement(i))).append(" ");
            }
            this.nextLine(s.append("\n").toString(), l.toString());
        }
    }
}

