/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.NamedBean;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.openlcb.OlcbEventNameStore;
import jmri.util.StringUtil;
import org.openlcb.EventID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OlcbAddress {
    static final String singleAddressPattern = "([xX](\\p{XDigit}\\p{XDigit}){1,8})|((\\p{XDigit}?\\p{XDigit}.){7}\\p{XDigit}?\\p{XDigit})";
    private Matcher hCode = null;
    private String aString;
    private int[] aFrame = null;
    private boolean match = false;
    private boolean fromName = false;
    private static final Logger log = LoggerFactory.getLogger(OlcbAddress.class);

    private Matcher getMatcher() {
        if (this.hCode == null) {
            this.hCode = Pattern.compile("^([xX](\\p{XDigit}\\p{XDigit}){1,8})|((\\p{XDigit}?\\p{XDigit}.){7}\\p{XDigit}?\\p{XDigit})$").matcher("");
        }
        return this.hCode;
    }

    public OlcbAddress(EventID e) {
        byte[] contents = e.getContents();
        this.aFrame = new int[contents.length];
        int i = 0;
        for (int n : contents) {
            this.aFrame[i++] = n;
        }
        this.aString = this.toCanonicalString();
    }

    public OlcbAddress(String input, CanSystemConnectionMemo memo) {
        int from;
        String s = input.strip();
        OlcbEventNameStore nameStore = null;
        if (memo != null) {
            nameStore = memo.get(OlcbEventNameStore.class);
        }
        if (nameStore != null && nameStore.hasEventID(s)) {
            EventID eid = nameStore.getEventID(s);
            byte[] contents = eid.getContents();
            this.aFrame = new int[contents.length];
            int i = 0;
            for (int n : contents) {
                this.aFrame[i++] = n;
            }
            this.match = true;
            this.fromName = true;
            this.aString = s;
            return;
        }
        if (s.startsWith("T")) {
            try {
                from = Integer.parseInt(s.substring(1));
            }
            catch (NumberFormatException e) {
                from = 0;
            }
            from = from >= 2045 ? (from -= 2045) : (from += 3);
            long event = 0x101020000FF0000L | (long)(from << 1);
            s = String.format("%016X;%016X", event, event + 1L);
            log.trace(" Turnout form converted to {}", (Object)s);
        } else if (s.startsWith("S")) {
            try {
                from = Integer.parseInt(s.substring(1));
            }
            catch (NumberFormatException e) {
                from = 0;
            }
            from = 0xFFF & from - 1;
            long event1 = 0x101020000FB0000L | (long)from;
            long event2 = 0x101020000FA0000L | (long)from;
            s = String.format("%016X;%016X", event1, event2);
            log.trace(" Sensor form converted to {}", (Object)s);
        }
        this.aString = s;
        if (this.aString.contains(";")) {
            return;
        }
        if (this.aString.contains(".")) {
            String[] terms = s.split("\\.");
            if (terms.length != 8) {
                log.debug("unexpected number of terms: {}, address is {}", (Object)terms.length, (Object)s);
            }
            int[] tFrame = new int[terms.length];
            int i = -1;
            try {
                for (i = 0; i < terms.length; ++i) {
                    tFrame[i] = Integer.parseInt(terms[i].strip(), 16);
                }
            }
            catch (NumberFormatException ex) {
                log.debug("failed to parse EventID \"{}\" at {} due to {}; might be a partial value", new Object[]{s, i, terms[i].strip()});
                return;
            }
            this.aFrame = tFrame;
            this.match = true;
        } else {
            if (this.aString.startsWith("x")) {
                this.aString = this.aString.substring(1);
            }
            if (this.aString.startsWith("X")) {
                this.aString = this.aString.substring(1);
            }
            int len = this.aString.length() / 2;
            int[] tFrame = new int[len];
            try {
                for (int i = 0; i < len; ++i) {
                    String two = this.aString.substring(2 * i, 2 * i + 2);
                    tFrame[i] = Integer.parseInt(two, 16);
                }
            }
            catch (NumberFormatException ex) {
                log.debug("failed to parse EventID \"{}\"; might be a partial value", (Object)s);
                return;
            }
            this.aFrame = tFrame;
            this.match = true;
        }
    }

    public boolean equals(Object r) {
        if (r == null) {
            return false;
        }
        if (!r.getClass().equals(this.getClass())) {
            return false;
        }
        OlcbAddress opp = (OlcbAddress)r;
        if (this.aFrame == null || opp.aFrame == null) {
            return this.aString.equals(opp.aString);
        }
        if (opp.aFrame.length != this.aFrame.length) {
            return false;
        }
        for (int i = 0; i < this.aFrame.length; ++i) {
            if (this.aFrame[i] == opp.aFrame[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (int value : this.aFrame) {
            ret += value * 8;
        }
        return ret;
    }

    public int compare(@Nonnull OlcbAddress opp) {
        if (!this.match && !opp.match) {
            return this.aString.compareTo(opp.aString);
        }
        if (this.match && !opp.match) {
            return -1;
        }
        if (!this.match && opp.match) {
            return 1;
        }
        for (int i = 0; i < Math.min(this.aFrame.length, opp.aFrame.length); ++i) {
            if (this.aFrame[i] == opp.aFrame[i]) continue;
            return Integer.signum(this.aFrame[i] - opp.aFrame[i]);
        }
        return Integer.signum(this.aFrame.length - opp.aFrame.length);
    }

    public CanMessage makeMessage() {
        CanMessage c = new CanMessage(this.aFrame, 425410560);
        c.setExtended(true);
        return c;
    }

    public boolean check() {
        return this.getMatcher().reset(this.aString).matches();
    }

    boolean match(CanReply r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        for (int i = 0; i < this.aFrame.length; ++i) {
            if (this.aFrame[i] == r.getElement(i)) continue;
            return false;
        }
        if (!r.isExtended()) {
            return false;
        }
        return (r.getHeader() & 0x1FFFF000) == 425410560;
    }

    boolean match(CanMessage r) {
        if (r.getNumDataElements() != this.aFrame.length) {
            return false;
        }
        for (int i = 0; i < this.aFrame.length; ++i) {
            if (this.aFrame[i] == r.getElement(i)) continue;
            return false;
        }
        if (!r.isExtended()) {
            return false;
        }
        return (r.getHeader() & 0x1FFFF000) == 425410560;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Documented API, no resources to improve")
    public OlcbAddress[] split(CanSystemConnectionMemo memo) {
        if (this.aString == null || this.aString.endsWith(";")) {
            return null;
        }
        String[] pStrings = this.aString.split(";");
        OlcbAddress[] retval = new OlcbAddress[pStrings.length];
        for (int i = 0; i < pStrings.length; ++i) {
            if (pStrings[i].equals("")) {
                return null;
            }
            retval[i] = new OlcbAddress(pStrings[i], memo);
            if (retval[i].match) continue;
            return null;
        }
        return retval;
    }

    public boolean checkSplit(CanSystemConnectionMemo memo) {
        return this.split(memo) != null;
    }

    int[] elements() {
        return this.aFrame;
    }

    public String toString() {
        return this.aString;
    }

    public String toCanonicalString() {
        String retval = "x";
        for (int value : this.aFrame) {
            retval = StringUtil.appendTwoHexFromInt(value, retval);
        }
        return retval;
    }

    public String toDottedString() {
        Object retval = "";
        if (this.aFrame == null) {
            return retval;
        }
        for (int value : this.aFrame) {
            if (!((String)retval).isEmpty()) {
                retval = (String)retval + ".";
            }
            retval = StringUtil.appendTwoHexFromInt(value, (String)retval);
        }
        return retval;
    }

    public EventID toEventID() {
        if (this.aFrame == null) {
            return null;
        }
        byte[] b = new byte[8];
        for (int i = 0; i < Math.min(8, this.aFrame.length); ++i) {
            b[i] = (byte)this.aFrame[i];
        }
        return new EventID(b);
    }

    public boolean isFromName() {
        return this.fromName;
    }

    @Nonnull
    public static String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale, @Nonnull String prefix, CanSystemConnectionMemo memo) throws NamedBean.BadSystemNameException {
        String oAddr = name.substring(prefix.length());
        OlcbAddress a = new OlcbAddress(oAddr, memo);
        OlcbAddress[] v = a.split(memo);
        if (v == null) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", "Did not find usable system name: " + name + " does not convert to a valid Olcb address");
        }
        switch (v.length) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", "Wrong number of events in address: " + name);
            }
        }
        return name;
    }

    @Nonnull
    public static String validateSystemNameFormat2Part(@Nonnull String name, @Nonnull Locale locale, @Nonnull String prefix, CanSystemConnectionMemo memo) throws NamedBean.BadSystemNameException {
        String oAddr = name.substring(prefix.length());
        OlcbAddress a = new OlcbAddress(oAddr, memo);
        OlcbAddress[] v = a.split(memo);
        if (v == null) {
            throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", "Did not find usable system name: " + name + " to a valid Olcb address");
        }
        if (v.length == 2) {
            return name;
        }
        throw new NamedBean.BadSystemNameException(locale, "InvalidSystemNameCustom", "Address requires 2 Events: " + name);
    }

    @CheckReturnValue
    public static int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, CanSystemConnectionMemo memo) {
        OlcbAddress[] array1 = new OlcbAddress(suffix1, memo).split(memo);
        OlcbAddress[] array2 = new OlcbAddress(suffix2, memo).split(memo);
        for (int i = 0; i < Math.min(array1.length, array2.length); ++i) {
            int c = array1[i].compare(array2[i]);
            if (c == 0) continue;
            return c;
        }
        return Integer.signum(array1.length - array2.length);
    }
}

