/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import jmri.CommandStation;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.util.LoggingUtil;
import org.openlcb.Connection;
import org.openlcb.EventID;
import org.openlcb.Message;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProducerConsumerEventReportMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbCommandStation
implements CommandStation {
    CanSystemConnectionMemo memo;
    private static final Logger log = LoggerFactory.getLogger(OlcbCommandStation.class);

    public OlcbCommandStation(CanSystemConnectionMemo memo) {
        this.memo = memo;
    }

    @Override
    public boolean sendPacket(byte[] packet, int repeats) {
        LoggingUtil.warnOnce(log, "OpenLCB/LCC does not implement sending generic DCC packets to the rails", new Object[0]);
        return false;
    }

    @Override
    public String getUserName() {
        if (this.memo == null) {
            return "OpenLCB";
        }
        return this.memo.getUserName();
    }

    @Override
    public String getSystemPrefix() {
        if (this.memo == null) {
            return "M";
        }
        return this.memo.getSystemPrefix();
    }

    @Override
    public void sendAccSignalDecoderPkt(int address, int aspect, int count) {
        Connection connection = this.memo.get(OlcbInterface.class).getOutputConnection();
        NodeID srcNodeID = this.memo.get(OlcbInterface.class).getNodeId();
        int num = address - 1 + 4;
        byte[] content = new byte[]{1, 1, 2, 0, 1, (byte)(num / 256 & 0xFF), (byte)(num & 0xFF), (byte)aspect};
        EventID eventID = new EventID(content);
        ProducerConsumerEventReportMessage m = new ProducerConsumerEventReportMessage(srcNodeID, eventID);
        for (int i = 0; i < count; ++i) {
            connection.put((Message)m, null);
        }
    }

    @Override
    public void sendAltAccSignalDecoderPkt(int address, int aspect, int count) {
        this.sendAccSignalDecoderPkt(address + 4, aspect, count);
    }
}

