/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.openlcb;

import java.awt.event.ActionEvent;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import jmri.AddressedProgrammerManager;
import jmri.Application;
import jmri.ClockControl;
import jmri.CommandStation;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.MeterManager;
import jmri.PowerManager;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.StringIOManager;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.Version;
import jmri.jmrix.can.CanListener;
import jmri.jmrix.can.CanMessage;
import jmri.jmrix.can.CanReply;
import jmri.jmrix.can.CanSystemConnectionMemo;
import jmri.jmrix.can.ConfigurationManager;
import jmri.jmrix.can.TrafficController;
import jmri.jmrix.openlcb.OlcbClockControl;
import jmri.jmrix.openlcb.OlcbCommandStation;
import jmri.jmrix.openlcb.OlcbEventNameStore;
import jmri.jmrix.openlcb.OlcbLightManager;
import jmri.jmrix.openlcb.OlcbMeterManager;
import jmri.jmrix.openlcb.OlcbPowerManager;
import jmri.jmrix.openlcb.OlcbProgrammerManager;
import jmri.jmrix.openlcb.OlcbReporterManager;
import jmri.jmrix.openlcb.OlcbSensorManager;
import jmri.jmrix.openlcb.OlcbStringIOManager;
import jmri.jmrix.openlcb.OlcbThrottleManager;
import jmri.jmrix.openlcb.OlcbTurnoutManager;
import jmri.jmrix.openlcb.swing.OpenLcbComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.profile.ProfileManager;
import jmri.util.ThreadingUtil;
import org.openlcb.Connection;
import org.openlcb.LoaderClient;
import org.openlcb.Message;
import org.openlcb.MessageDecoder;
import org.openlcb.MimicNodeStore;
import org.openlcb.NodeID;
import org.openlcb.OlcbInterface;
import org.openlcb.ProtocolIdentificationReplyMessage;
import org.openlcb.ProtocolIdentificationRequestMessage;
import org.openlcb.SimpleNodeIdentInfoReplyMessage;
import org.openlcb.SimpleNodeIdentInfoRequestMessage;
import org.openlcb.can.AliasMap;
import org.openlcb.can.CanFrame;
import org.openlcb.can.CanInterface;
import org.openlcb.can.MessageBuilder;
import org.openlcb.can.OpenLcbCanFrame;
import org.openlcb.implementations.DatagramService;
import org.openlcb.implementations.MemoryConfigurationService;
import org.openlcb.protocols.TimeProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlcbConfigurationManager
extends ConfigurationManager {
    public static final String OPT_PROTOCOL_IDENT = "Ident";
    public static final String OPT_IDENT_NODEID = "NodeId";
    public static final String OPT_IDENT_USERNAME = "UserName";
    public static final String OPT_IDENT_DESCRIPTION = "UserDescription";
    public static final String OPT_PROTOCOL_FASTCLOCK = "FastClock";
    public static final String OPT_FASTCLOCK_ENABLE = "EnableMode";
    public static final String OPT_FASTCLOCK_ENABLE_OFF = "disabled";
    public static final String OPT_FASTCLOCK_ENABLE_GENERATOR = "generator";
    public static final String OPT_FASTCLOCK_ENABLE_CONSUMER = "consumer";
    public static final String OPT_FASTCLOCK_ID = "ClockId";
    public static final String OPT_FASTCLOCK_ID_DEFAULT = "default";
    public static final String OPT_FASTCLOCK_ID_DEFAULT_RT = "realtime";
    public static final String OPT_FASTCLOCK_ID_ALT_1 = "alt1";
    public static final String OPT_FASTCLOCK_ID_ALT_2 = "alt2";
    public static final String OPT_FASTCLOCK_ID_CUSTOM = "custom";
    public static final String OPT_FASTCLOCK_CUSTOM_ID = "ClockCustomId";
    final ComponentFactory cf;
    CanInterface olcbCanInterface;
    TrafficController tc;
    NodeID nodeID;
    LoaderClient loaderClient;
    OlcbClockControl clockControl;
    OlcbEventNameStore olcbEventNameStore = new OlcbEventNameStore();
    AliasMap aliasMap;
    MessageBuilder messageBuilder;
    protected OlcbProgrammerManager programmerManager;
    protected OlcbThrottleManager throttleManager;
    protected OlcbTurnoutManager turnoutManager;
    protected OlcbPowerManager powerManager;
    protected OlcbSensorManager sensorManager;
    protected OlcbLightManager lightManager;
    protected OlcbMeterManager meterManager;
    protected OlcbStringIOManager stringIOManager;
    protected OlcbReporterManager reporterManager;
    protected OlcbCommandStation commandStation;
    private static final Random RANDOM = new Random();
    private static final Logger log = LoggerFactory.getLogger(OlcbConfigurationManager.class);

    public OlcbConfigurationManager(CanSystemConnectionMemo memo) {
        super(memo);
        this.cf = new OpenLcbComponentFactory(this.adapterMemo);
        InstanceManager.store(this.cf, ComponentFactory.class);
        InstanceManager.store(this, OlcbConfigurationManager.class);
    }

    private void initializeFastClock() {
        boolean isMaster;
        String enableOption = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_FASTCLOCK, OPT_FASTCLOCK_ENABLE);
        if (OPT_FASTCLOCK_ENABLE_GENERATOR.equals(enableOption)) {
            isMaster = true;
        } else if (OPT_FASTCLOCK_ENABLE_CONSUMER.equals(enableOption)) {
            isMaster = false;
        } else {
            return;
        }
        NodeID clockId = null;
        String clockIdSetting = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_FASTCLOCK, OPT_FASTCLOCK_ID);
        if (OPT_FASTCLOCK_ID_DEFAULT.equals(clockIdSetting)) {
            clockId = TimeProtocol.DEFAULT_CLOCK;
        } else if (OPT_FASTCLOCK_ID_DEFAULT_RT.equals(clockIdSetting)) {
            clockId = TimeProtocol.DEFAULT_RT_CLOCK;
        } else if (OPT_FASTCLOCK_ID_ALT_1.equals(clockIdSetting)) {
            clockId = TimeProtocol.ALT_CLOCK_1;
        } else if (OPT_FASTCLOCK_ID_ALT_2.equals(clockIdSetting)) {
            clockId = TimeProtocol.ALT_CLOCK_2;
        } else if (OPT_FASTCLOCK_ID_CUSTOM.equals(clockIdSetting)) {
            String customId = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_FASTCLOCK, OPT_FASTCLOCK_CUSTOM_ID);
            if (customId == null || customId.isEmpty()) {
                log.error("OpenLCB clock initialize: User selected custom clock, but did not provide a Custom Clock ID. Using default clock.");
            } else {
                try {
                    clockId = new NodeID(customId);
                }
                catch (IllegalArgumentException e) {
                    log.error("OpenLCB clock initialize: Custom Clock ID '{}' is in illegal format. Use dotted hex notation like 05.01.01.01.DD.EE", (Object)customId);
                }
            }
        }
        if (clockId == null) {
            clockId = TimeProtocol.DEFAULT_CLOCK;
        }
        log.debug("Creating olcb clock with id {} is_master {}", (Object)clockId, (Object)isMaster);
        this.clockControl = new OlcbClockControl(this.getInterface(), clockId, isMaster);
        InstanceManager.setDefault(ClockControl.class, this.clockControl);
    }

    @Override
    public void configureManagers() {
        this.getOurNodeID();
        this.tc = this.adapterMemo.getTrafficController();
        this.olcbCanInterface = OlcbConfigurationManager.createOlcbCanInterface(this.nodeID, this.tc);
        InstanceManager.setSensorManager(this.getSensorManager());
        InstanceManager.setTurnoutManager(this.getTurnoutManager());
        InstanceManager.store(this.getPowerManager(), PowerManager.class);
        InstanceManager.setStringIOManager(this.getStringIOManager());
        InstanceManager.setThrottleManager(this.getThrottleManager());
        InstanceManager.setReporterManager(this.getReporterManager());
        InstanceManager.setLightManager(this.getLightManager());
        InstanceManager.setMeterManager(this.getMeterManager());
        InstanceManager.store(this.getCommandStation(), CommandStation.class);
        if (this.getProgrammerManager().isAddressedModePossible()) {
            InstanceManager.store(this.getProgrammerManager(), AddressedProgrammerManager.class);
        }
        if (this.getProgrammerManager().isGlobalProgrammerAvailable()) {
            InstanceManager.store(this.getProgrammerManager(), GlobalProgrammerManager.class);
        }
        new StartUpHandler().start();
        OlcbInterface iface = this.getInterface();
        this.loaderClient = new LoaderClient(iface.getOutputConnection(), iface.getMemoryConfigurationService(), iface.getDatagramService());
        iface.registerMessageListener((Connection)this.loaderClient);
        iface.registerMessageListener((Connection)new SimpleNodeIdentInfoHandler());
        iface.registerMessageListener((Connection)new PipRequestHandler());
        this.initializeFastClock();
        this.aliasMap = new AliasMap();
        this.tc.addCanListener(new CanListener(){

            @Override
            public void message(CanMessage m) {
                if (!m.isExtended() || m.isRtr()) {
                    return;
                }
                OlcbConfigurationManager.this.aliasMap.processFrame(OlcbConfigurationManager.convertFromCan(m));
            }

            @Override
            public void reply(CanReply m) {
                if (!m.isExtended() || m.isRtr()) {
                    return;
                }
                OlcbConfigurationManager.this.aliasMap.processFrame(OlcbConfigurationManager.convertFromCan(m));
            }
        });
        this.messageBuilder = new MessageBuilder(this.aliasMap);
    }

    OlcbInterface getInterface() {
        return this.olcbCanInterface.getInterface();
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.adapterMemo.getDisabled()) {
            return false;
        }
        if (type.equals(ThrottleManager.class)) {
            return true;
        }
        if (type.equals(SensorManager.class)) {
            return true;
        }
        if (type.equals(TurnoutManager.class)) {
            return true;
        }
        if (type.equals(PowerManager.class)) {
            return true;
        }
        if (type.equals(ReporterManager.class)) {
            return true;
        }
        if (type.equals(LightManager.class)) {
            return true;
        }
        if (type.equals(MeterManager.class)) {
            return true;
        }
        if (type.equals(StringIOManager.class)) {
            return true;
        }
        if (type.equals(GlobalProgrammerManager.class)) {
            return true;
        }
        if (type.equals(AddressedProgrammerManager.class)) {
            return true;
        }
        if (type.equals(CommandStation.class)) {
            return true;
        }
        if (type.equals(AliasMap.class)) {
            return true;
        }
        if (type.equals(MessageBuilder.class)) {
            return true;
        }
        if (type.equals(MimicNodeStore.class)) {
            return true;
        }
        if (type.equals(Connection.class)) {
            return true;
        }
        if (type.equals(MemoryConfigurationService.class)) {
            return true;
        }
        if (type.equals(DatagramService.class)) {
            return true;
        }
        if (type.equals(NodeID.class)) {
            return true;
        }
        if (type.equals(OlcbInterface.class)) {
            return true;
        }
        if (type.equals(CanInterface.class)) {
            return true;
        }
        if (type.equals(ClockControl.class)) {
            return this.clockControl != null;
        }
        return type.equals(OlcbEventNameStore.class);
    }

    @Override
    public <T> T get(Class<?> T) {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (T.equals(ThrottleManager.class)) {
            return (T)this.getThrottleManager();
        }
        if (T.equals(SensorManager.class)) {
            return (T)this.getSensorManager();
        }
        if (T.equals(TurnoutManager.class)) {
            return (T)this.getTurnoutManager();
        }
        if (T.equals(PowerManager.class)) {
            return (T)this.getPowerManager();
        }
        if (T.equals(LightManager.class)) {
            return (T)this.getLightManager();
        }
        if (T.equals(MeterManager.class)) {
            return (T)this.getMeterManager();
        }
        if (T.equals(StringIOManager.class)) {
            return (T)this.getStringIOManager();
        }
        if (T.equals(ReporterManager.class)) {
            return (T)this.getReporterManager();
        }
        if (T.equals(GlobalProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(AddressedProgrammerManager.class)) {
            return (T)this.getProgrammerManager();
        }
        if (T.equals(CommandStation.class)) {
            return (T)this.getCommandStation();
        }
        if (T.equals(AliasMap.class)) {
            return (T)this.aliasMap;
        }
        if (T.equals(MessageBuilder.class)) {
            return (T)this.messageBuilder;
        }
        if (T.equals(MimicNodeStore.class)) {
            return (T)this.getInterface().getNodeStore();
        }
        if (T.equals(Connection.class)) {
            return (T)this.getInterface().getOutputConnection();
        }
        if (T.equals(MemoryConfigurationService.class)) {
            return (T)this.getInterface().getMemoryConfigurationService();
        }
        if (T.equals(DatagramService.class)) {
            return (T)this.getInterface().getDatagramService();
        }
        if (T.equals(LoaderClient.class)) {
            return (T)this.loaderClient;
        }
        if (T.equals(NodeID.class)) {
            return (T)this.nodeID;
        }
        if (T.equals(OlcbInterface.class)) {
            return (T)this.getInterface();
        }
        if (T.equals(CanInterface.class)) {
            return (T)this.olcbCanInterface;
        }
        if (T.equals(ClockControl.class)) {
            return (T)this.clockControl;
        }
        if (T.equals(OlcbEventNameStore.class)) {
            return (T)this.olcbEventNameStore;
        }
        return null;
    }

    public OlcbProgrammerManager getProgrammerManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.programmerManager == null) {
            this.programmerManager = new OlcbProgrammerManager(this.adapterMemo);
        }
        return this.programmerManager;
    }

    public OlcbThrottleManager getThrottleManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.throttleManager == null) {
            this.throttleManager = new OlcbThrottleManager(this.adapterMemo);
        }
        return this.throttleManager;
    }

    public OlcbTurnoutManager getTurnoutManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.turnoutManager == null) {
            this.turnoutManager = new OlcbTurnoutManager(this.adapterMemo);
        }
        return this.turnoutManager;
    }

    public OlcbPowerManager getPowerManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.powerManager == null) {
            this.powerManager = new OlcbPowerManager(this.adapterMemo);
        }
        return this.powerManager;
    }

    public OlcbSensorManager getSensorManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.sensorManager == null) {
            this.sensorManager = new OlcbSensorManager(this.adapterMemo);
        }
        return this.sensorManager;
    }

    public OlcbLightManager getLightManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.lightManager == null) {
            this.lightManager = new OlcbLightManager(this.adapterMemo);
        }
        return this.lightManager;
    }

    public OlcbMeterManager getMeterManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.meterManager == null) {
            this.meterManager = new OlcbMeterManager(this.adapterMemo);
        }
        return this.meterManager;
    }

    public OlcbStringIOManager getStringIOManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.stringIOManager == null) {
            this.stringIOManager = new OlcbStringIOManager(this.adapterMemo);
        }
        return this.stringIOManager;
    }

    public OlcbReporterManager getReporterManager() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.reporterManager == null) {
            this.reporterManager = new OlcbReporterManager(this.adapterMemo);
        }
        return this.reporterManager;
    }

    public OlcbCommandStation getCommandStation() {
        if (this.adapterMemo.getDisabled()) {
            return null;
        }
        if (this.commandStation == null) {
            this.commandStation = new OlcbCommandStation(this.adapterMemo);
        }
        return this.commandStation;
    }

    @Override
    public void dispose() {
        if (this.turnoutManager != null) {
            InstanceManager.deregister(this.turnoutManager, OlcbTurnoutManager.class);
        }
        if (this.sensorManager != null) {
            InstanceManager.deregister(this.sensorManager, OlcbSensorManager.class);
        }
        if (this.lightManager != null) {
            InstanceManager.deregister(this.lightManager, OlcbLightManager.class);
        }
        if (this.cf != null) {
            InstanceManager.deregister(this.cf, ComponentFactory.class);
        }
        InstanceManager.deregister(this, OlcbConfigurationManager.class);
        if (this.clockControl != null) {
            this.clockControl.dispose();
            InstanceManager.deregister(this.clockControl, ClockControl.class);
        }
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.openlcb.OlcbActionListBundle");
    }

    protected void getOurNodeID() {
        try {
            List<NodeID> previous;
            String userOption = this.adapterMemo.getProtocolOption(OPT_PROTOCOL_IDENT, OPT_IDENT_NODEID);
            if (userOption != null && !userOption.isEmpty()) {
                try {
                    this.nodeID = new NodeID(userOption);
                    log.trace("getOurNodeID sets known option Node ID: {}", (Object)this.nodeID);
                    return;
                }
                catch (IllegalArgumentException e) {
                    log.error("User configured a node ID protocol option which is in invalid format ({}). Expected dotted hex notation like 02.01.12.FF.EE.DD", (Object)userOption);
                }
            }
            if (!(previous = InstanceManager.getList(NodeID.class)).isEmpty()) {
                this.nodeID = previous.get(0);
                log.trace("getOurNodeID sets known instance Node ID: {}", (Object)this.nodeID);
                return;
            }
            long pid = this.getProcessId(1L);
            log.trace("Process ID: {}", (Object)pid);
            InetAddress address = null;
            try {
                NetworkInterface n = NetworkInterface.getNetworkInterfaces().nextElement();
                if (n != null) {
                    address = n.getInetAddresses().nextElement();
                }
                log.debug("InetAddress: {}", address);
            }
            catch (SocketException | NoSuchElementException e) {
                log.warn("Can't get IP address to make NodeID. You should set a NodeID in the Connection preferences.");
            }
            byte b2 = 0;
            if (address != null) {
                b2 = address.getAddress()[0];
            } else {
                b2 = (byte)(RANDOM.nextInt(255) & 0xFF);
                log.trace("Used random value {} for address byte", (Object)b2);
            }
            this.nodeID = new NodeID(new byte[]{2, 1, 18, (byte)(b2 & 0xFF), (byte)(pid >> 8 & 0xFFL), (byte)(pid & 0xFFL)});
            log.debug("getOurNodeID sets new Node ID: {}", (Object)this.nodeID);
        }
        catch (Exception e) {
            log.error("Unexpected Exception while processing Node ID definition. Please report this to the JMRI developers", (Throwable)e);
            byte b2 = (byte)(RANDOM.nextInt(255) & 0xFF);
            byte b1 = (byte)(RANDOM.nextInt(255) & 0xFF);
            byte b0 = (byte)(RANDOM.nextInt(255) & 0xFF);
            this.nodeID = new NodeID(new byte[]{2, 1, 18, b2, b1, b0});
            log.debug("Setting random Node ID: {}", (Object)this.nodeID);
        }
    }

    protected long getProcessId(long fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.parseLong(jvmName.substring(0, index));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static CanInterface createOlcbCanInterface(NodeID nodeID, TrafficController tc) {
        final CanInterface olcbIf = new CanInterface(nodeID, frame -> tc.sendCanMessage(OlcbConfigurationManager.convertToCan(frame), null));
        tc.addCanListener(new CanListener(){

            @Override
            public void message(CanMessage m) {
            }

            @Override
            public void reply(CanReply m) {
                if (!m.isExtended() || m.isRtr()) {
                    return;
                }
                olcbIf.frameInput().send((CanFrame)OlcbConfigurationManager.convertFromCan(m));
            }
        });
        olcbIf.getInterface().setLoopbackThread(r -> ThreadingUtil.runOnLayout(r::run));
        return olcbIf;
    }

    static CanMessage convertToCan(CanFrame f) {
        CanMessage fout = new CanMessage(f.getData(), f.getHeader());
        fout.setExtended(true);
        return fout;
    }

    static OpenLcbCanFrame convertFromCan(jmri.jmrix.can.CanFrame message) {
        OpenLcbCanFrame fin = new OpenLcbCanFrame(0);
        fin.setHeader(message.getHeader());
        if (message.getNumDataElements() == 0) {
            return fin;
        }
        byte[] data = new byte[message.getNumDataElements()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(message.getElement(i) & 0xFF);
        }
        fin.setData(data);
        return fin;
    }

    class StartUpHandler {
        Timer timer;
        static final int START_DELAY = 2500;

        StartUpHandler() {
        }

        void start() {
            log.debug("StartUpHandler starts up");
            this.timer = new Timer(2500, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = ThreadingUtil.newThread(() -> OlcbConfigurationManager.this.olcbCanInterface.initialize(), "olcbCanInterface.initialize");
                    t.start();
                }
            });
            this.timer.setRepeats(false);
            this.timer.start();
        }
    }

    class PipRequestHandler
    extends MessageDecoder {
        PipRequestHandler() {
        }

        public void handleProtocolIdentificationRequest(ProtocolIdentificationRequestMessage msg, Connection sender) {
            long flags = 0x41000000000L;
            if (msg.getDestNodeID() == OlcbConfigurationManager.this.nodeID) {
                OlcbConfigurationManager.this.getInterface().getOutputConnection().put((Message)new ProtocolIdentificationReplyMessage(OlcbConfigurationManager.this.nodeID, msg.getSourceNodeID(), flags), (Connection)this);
            }
        }
    }

    class SimpleNodeIdentInfoHandler
    extends MessageDecoder {
        private final byte[] content;

        private void addStringPart(String addString, List<Byte> contents, int maxlength) {
            if (addString != null && !addString.isEmpty()) {
                byte[] bb;
                String value = addString.substring(0, Math.min(maxlength, addString.length()));
                for (byte b : bb = value.getBytes(StandardCharsets.UTF_8)) {
                    contents.add(b);
                }
            }
            contents.add((byte)0);
        }

        SimpleNodeIdentInfoHandler() {
            ArrayList<Byte> l = new ArrayList<Byte>(256);
            l.add((byte)4);
            this.addStringPart("JMRI", l, 40);
            this.addStringPart(Application.getApplicationName(), l, 40);
            String name = ProfileManager.getDefault().getActiveProfileName();
            if (name != null) {
                this.addStringPart(name, l, 20);
            } else {
                this.addStringPart("", l, 20);
            }
            this.addStringPart(Version.name(), l, 20);
            l.add((byte)2);
            this.addStringPart(OlcbConfigurationManager.this.adapterMemo.getProtocolOption(OlcbConfigurationManager.OPT_PROTOCOL_IDENT, OlcbConfigurationManager.OPT_IDENT_USERNAME), l, 62);
            this.addStringPart(OlcbConfigurationManager.this.adapterMemo.getProtocolOption(OlcbConfigurationManager.OPT_PROTOCOL_IDENT, OlcbConfigurationManager.OPT_IDENT_DESCRIPTION), l, 63);
            this.content = new byte[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                this.content[i] = (Byte)l.get(i);
            }
        }

        public void handleSimpleNodeIdentInfoRequest(SimpleNodeIdentInfoRequestMessage msg, Connection sender) {
            if (msg.getDestNodeID().equals((Object)OlcbConfigurationManager.this.nodeID) && (msg.getSourceNodeID().equals((Object)OlcbConfigurationManager.this.nodeID) || org.openlcb.Version.libVersionAtLeast((int)0, (int)7, (int)8))) {
                OlcbConfigurationManager.this.getInterface().getOutputConnection().put((Message)new SimpleNodeIdentInfoReplyMessage(OlcbConfigurationManager.this.nodeID, msg.getSourceNodeID(), this.content), (Connection)this);
            }
        }
    }
}

